<?php
/**
 * Template for displaying a search form in site header.
 *
 * @package mateo
 */

?>
<?php
if ( (int) get_theme_mod( 'header-search-box' ) === 1 ) :
	$mateo_search_id = esc_attr( wp_generate_uuid4() );
	?>
<div class="top-search">
	<form role="search" method="get" class="search-form search-inline top-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
		<div class="form-group bmd-form-group">
			<input type="search" id="<?php echo $mateo_search_id; // phpcs:ignore ?>" class="search-field" value="<?php the_search_query(); ?>" name="s" aria-label="<?php esc_attr_e( 'Search', 'mateo' ); ?>" required>
			<button type="submit" class="search-submit">
				<i class="material-icons" aria-hidden="true">search</i>
				<span class="screen-reader-text"><?php echo esc_html_x( 'Search', 'submit button', 'mateo' ); ?></span>
			</button>
			<button type="button" class="search-cancel">
				<i class="material-icons" aria-hidden="true">close</i>
				<span class="screen-reader-text"><?php echo esc_html_x( 'Close search box', 'search box button', 'mateo' ); ?></span>
			</button>

		</div>
	</form>
	<button class="top-search-btn" aria-label="<?php esc_attr_e( 'Display search box', 'mateo' ); ?>" aria-controls="<?php echo $mateo_search_id; // phpcs:ignore ?>" aria-relevant="all">
		<i class="top-search-icon" aria-hidden="true"></i>
	</button>
</div>
	<?php unset( $mateo_search_id ); ?>
<?php endif; ?>
