<?php
/**
 * Template part for displaying results in listing pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package mateo
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'content-list' ); ?>>
	<header class="entry-header">
		<h2 class="entry-title">
			<?php mateo_the_post_inline_edit_button(); ?>
			<a href="<?php echo esc_url( get_permalink() ); ?>">
				<?php mateo_list_post_title(); ?></a>
		</h2>
		<div class="divider-title"></div>
		<?php
		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<div>
					<?php mateo_posted_on(); ?>
					<?php mateo_posted_by(); ?>
				</div>
				<?php mateo_entry_sticky(); ?>
				<?php mateo_comments_info(); ?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<?php mateo_post_thumbnail(); ?>

	<div class="entry-summary">
		<?php
		echo mateo_excerpt(); // phpcs:ignore
		?>
	</div><!-- .entry-summary -->

	<footer class="entry-footer">

		<?php mateo_entry_cats(); ?>
		<?php mateo_entry_tags(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
