<?php
/**
 * Template part for displaying site header.
 *
 * @package mateo
 */

$mateo_small_menu = null;
$mateo_big_menu   = mateo_nav_menu(
	array(
		'theme_location'  => 'menu-1',
		'menu_id'         => 'primary-menu',
		'menu_class'      => 'main-menu',
		'container'       => 'div',
		'container_class' => 'collapse navbar-collapse',
	)
);
if ( $mateo_big_menu ) {
	$mateo_small_menu = mateo_nav_menu(
		array(
			'theme_location'  => 'menu-1',
			'menu_id'         => 's-primary-menu',
			'menu_class'      => 's-main-menu',
			'container'       => 'div',
			'container_class' => 'small-main-container',
		)
	);
}

?>
<header class="site-header">
	<div class="header-width">
		<nav class="navbar navbar-expand-lg">
			<div class="site-branding">
				<div class="logo-container">
					<?php
					$mateo_custom_logo = get_custom_logo();
					if ( $mateo_custom_logo ) {
						echo $mateo_custom_logo; // phpcs:ignore
					}
					?>
				</div>
				<div class="site-title">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" title="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>">
						<?php bloginfo( 'name' ); ?>
					</a>
				</div>
			</div>
			<div class="navbar-components">
			<?php if ( $mateo_big_menu ) : ?>
				<div class="main-menu-container hide-overflow">
					<?php echo $mateo_big_menu; // phpcs:ignore ?>
				</div>
			<?php endif; ?>
				<div class="top-search-block">
				<?php get_template_part( 'template-parts/search/header' ); ?>
				</div>
			<?php if ( $mateo_big_menu ) : ?>
				<?php // Button must be placed at the end of navbar to provide a fluent keyboard navigation between the main menu and the submenu. ?>
				<button class="navbar-toggler" type="button"
						aria-controls="s-primary-menu"  aria-expanded="false" aria-label="<?php echo esc_attr( __( 'Show menu', 'mateo' ) ); ?>">
					<i class="menu-burger"></i>
				</button>
			<?php endif; ?>
			</div>
		</nav>
		<?php
		if ( $mateo_small_menu ) {
			echo $mateo_small_menu; // phpcs:ignore
		}
		?>
	</div>
</header>
