<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package mateo
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php

	if ( 'post' === get_post_type() ) :
		?>
		<div class="entry-meta">
			<div>
			<?php
			mateo_posted_on();
			mateo_posted_by();
			?>
			</div>
			<?php mateo_comments_info(); ?>
		</div><!-- .entry-meta -->
	<?php endif; ?>
	<div class="entry-content">
		<?php
		if ( ! mateo_is_active_featured_in_header() ) {
			mateo_post_thumbnail();
		}
		the_content(
			sprintf(
				wp_kses(
				/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'mateo' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			)
		);
		mateo_link_pages();
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php mateo_entry_cats(); ?>
		<?php mateo_entry_tags(); ?>
	</footer><!-- .entry-footer -->

</article><!-- #post-<?php the_ID(); ?> -->

