<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package kde
 */

get_header();
?>
	<div id="primary" class="content-area">

		<?php get_template_part( 'template-parts/breadcrumb' ); ?>

		<main id="main" class="site-main">
			<?php
			while ( have_posts() ) :
				the_post();

				get_template_part( 'template-parts/content', get_post_type() );
				if ( ! is_page() ) {
					do_action( 'mateo_before_post_navigation' );
					the_post_navigation(
						array(
							'prev_text' => '<span class="post-nav-arrow material-icons">chevron_left</span>'
								. '<span class="post-nav-title">%title</span>'
								. '<span class="post-nav-title-sm">' . esc_html__( 'Previous', 'mateo' ) . '</span>',
							'next_text' => '<span class="post-nav-title">%title</span>'
								. '<span class="post-nav-title-sm">' . esc_html__( 'Next', 'mateo' ) . '</span>'
								. '<span class="post-nav-arrow  material-icons">chevron_right</span>',
						)
					);
					do_action( 'mateo_after_post_navigation' );
				}
				// If comments are open or we have at least one comment, load up the comment template.
				do_action( 'mateo_before_comments' );

				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;

				do_action( 'mateo_after_comments' );

			endwhile; // End of the loop.
			?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();
