<?php
/**
 * Initializes Features Section.
 *
 * @package mateo.
 */

if ( ! function_exists( 'mateo_customize_section_features' ) ) {
	/**
	 * Initializes Features Section in the Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 */
	function mateo_customize_section_features( $wp_customize ) {
		$section = 'mateo-features-section';

		$wp_customize->add_section(
			$section,
			array(
				'title'    => esc_html__( 'Theme Features', 'mateo' ),
				'priority' => 121,
			)
		);
		$wp_customize->add_setting(
			'header-search-box',
			array(
				'default'           => 0,
				'transport'         => 'postMessage',
				'sanitize_callback' => 'mateo_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'header-search-box',
			array(
				'type'     => 'checkbox',
				'section'  => $section,
				'label'    => __( 'Display search box in header.', 'mateo' ),
				'settings' => 'header-search-box',
			)
		);

		// Display header search box.
		$wp_customize->selective_refresh->add_partial(
			'header-search-box',
			array(
				'selector'        => '.top-search-block',
				'render_callback' => 'mateo_header_render_callback',
			)
		);
		$wp_customize->add_setting(
			'mateo-featured-in-header',
			array(
				'default'           => true,
				'transport'         => 'refresh',
				'sanitize_callback' => 'mateo_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'mateo-featured-in-header',
			array(
				'type'     => 'checkbox',
				'section'  => $section,
				'label'    => __( 'Display featured image in header.', 'mateo' ),
				'settings' => 'mateo-featured-in-header',
			)
		);
		// Breadcrumbs.
		$render_breadcrumb = array(
			'selector'            => '.breadcrumb_wrapper',
			'container_inclusive' => false,
			'fallback_refresh'    => false,
			'render_callback'     => function () {
				return mateo_breadcrumb_trail( array( 'echo' => false ) );
			},
		);

		// Breadcrumb ON/OFF.
		$id = 'mateo-breadcrumb';
		$wp_customize->add_setting(
			$id,
			array(
				'default'           => false,
				'sanitize_callback' => 'mateo_sanitize_checkbox',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			$id,
			array(
				'type'    => 'checkbox',
				'section' => $section,
				'label'   => __( 'Display breadcrumb.', 'mateo' ),
			)
		);
		$wp_customize->selective_refresh->add_partial( $id, $render_breadcrumb );

		// Breadcrumb on Home Page.
		$id = 'mateo-breadcrumb-home-disable';
		$wp_customize->add_setting(
			$id,
			array(
				'default'           => false,
				'sanitize_callback' => 'mateo_sanitize_checkbox',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			$id,
			array(
				'type'            => 'checkbox',
				'section'         => $section,
				'label'           => __( 'Disable breadcrumb on Home page.', 'mateo' ),
				'active_callback' => function() {
					return get_theme_mod( 'mateo-breadcrumb', false );
				},
			)
		);

		$wp_customize->selective_refresh->add_partial( $id, $render_breadcrumb );

		// Breadcrumb on Singe Page.
		$id = 'mateo-breadcrumb-page-disable';
		$wp_customize->add_setting(
			$id,
			array(
				'default'           => false,
				'sanitize_callback' => 'mateo_sanitize_checkbox',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->add_control(
			$id,
			array(
				'type'            => 'checkbox',
				'section'         => $section,
				'label'           => __( 'Disable breadcrumb on Page.', 'mateo' ),
				'active_callback' => function() {
					return get_theme_mod( 'mateo-breadcrumb', false );
				},
			)
		);

		$wp_customize->selective_refresh->add_partial( $id, $render_breadcrumb );
	}
}
