<?php
/**
 * Base class for the width control.
 *
 * @package Mateo
 */

namespace Mateo;

use \WP_Customize_Manager;

/**
 * Class Width_Customize_Control
 *
 * @package Mateo
 */
class Width_Customize_Control extends Slider_Customize_Control {

	/**
	 * Constructor.
	 *
	 * Supplied `$args` override class property defaults.
	 *
	 * If `$args['settings']` is not defined, use the $id as the setting ID.
	 *
	 * @since 3.4.0
	 *
	 * @param WP_Customize_Manager $manager Customizer bootstrap instance.
	 * @param string               $id      Control ID.
	 * @param array                $args    Optional. Array of properties for the new Control object. Default empty array.
	 */
	public function __construct( $manager, $id, $args = array() ) {
		$this->section     = 'mateo-layout-section';
		$this->input_attrs = array(
			'min'  => 768,
			'max'  => 1920,
			'step' => 1,
		);

		parent::__construct( $manager, $id, $args );
	}
}
