<?php
/**
 * Preconfigured settings class for the width settings.
 *
 * @package Mateo
 */

namespace Mateo;

use Mateo\Customizer\Font_Size_Setting;
use WP_Customize_Setting;
use WP_Error;
use WP_Customize_Manager;

/**
 * Class Width_Customize_Settings.
 *
 * @package Mateo
 */
class Slider_Customize_Settings extends WP_Customize_Setting {

	/**
	 * Minimal value
	 *
	 * @var integer
	 */
	protected $min = 0;
	/**
	 * Maximal value
	 *
	 * @var integer
	 */
	protected $max = 100;

	/**
	 * Any supplied $args override class property defaults.
	 *
	 * @param WP_Customize_Manager $manager Customizer bootstrap instance.
	 * @param string               $id      A specific ID of the setting.
	 *                                      Can be a theme mod or option name.
	 * @param array                $args    Optional. Array of properties for the new Setting object. Default empty array.
	 */
	public function __construct( $manager, $id, $args = array() ) {
		$this->transport = 'postMessage';
		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Callback wrapper for $this->sanitize_value() method.
	 *
	 * @param string $value Value to be sanitized.
	 * @param static $instance  Current class instance.
	 *
	 * @return float|int Sanitized and cast value.
	 */
	public static function sanitize_callback( $value, $instance ) {
		return $instance->sanitize_value( $value );
	}
	/**
	 * Sanitize an input.
	 *
	 * @param string $value The value to sanitize.
	 *
	 * @return int Sanitized value.
	 */
	public function sanitize_value( $value ) {
		return intval( $value );
	}
	/**
	 * Validates an input.
	 * Native  WP filter "customize_validate_{$this->id}" can be applied.
	 *
	 * @param mixed $value Value to validate.
	 * @return true|WP_Error True if the input was validated, otherwise WP_Error.
	 */
	public function validate( $value ) {
		$value = $this->sanitize_value( $value );
		if ( $value < $this->min || $value > $this->max ) {
			$value = new WP_Error( 'invalid_value', __( 'Invalid value.', 'mateo' ) );

		}
		return parent::validate( $value );
	}

	/**
	 * Getter.
	 *
	 * @return int Current min value.
	 */
	public function getMin() {
		return $this->min;
	}

	/**
	 * Setter for the min property.
	 *
	 * @param int $min Minimal value.
	 */
	public function setMin( $min ) {
		$this->min = $min;
	}

	/**
	 * Getter.
	 *
	 * @return int Current max value.
	 */
	public function getMax() {
		return $this->max;
	}

	/**
	 * Setter for the max property.
	 *
	 * @param int $max  Maximum value.
	 */
	public function setMax( $max ) {
		$this->max = $max;
	}
}
