<?php
/**
 * Base class for the slider control.
 *
 * @package Mateo
 */

namespace Mateo;

use WP_Customize_Control;
/**
 * Slider Custom Control
 */
class Slider_Customize_Control extends WP_Customize_Control {
	/**
	 * The type of control being rendered.
	 *
	 * @var string Custom control type.
	 */
	public $type = 'mateo_slider_control';

	/**
	 * Render the control in the customizer
	 */
	public function render_content() {
		$input_id         = '_customize-input-' . $this->id;
		$description_id   = '_customize-description-' . $this->id;
		$describedby_attr = ( ! empty( $this->description ) ) ? ' aria-describedby="' . esc_attr( $description_id ) . '" ' : '';
		?>
		<?php if ( ! empty( $this->label ) ) : ?>
			<label for="<?php echo esc_attr( $input_id ); ?>" class="customize-control-title"><?php echo esc_html( $this->label ); ?></label>
		<?php endif; ?>
		<?php if ( ! empty( $this->description ) ) : ?>
			<span id="<?php echo esc_attr( $description_id ); ?>" class="description customize-control-description">
				<?php echo esc_html( $this->description ); ?>
			</span>
		<?php endif; ?>
		<div class="range-slider">
			<input
				id="<?php echo esc_attr( $input_id ); ?>"
				type="range"
				<?php // phpcs:ignore
				echo $describedby_attr; ?>
				<?php $this->input_attrs(); ?>
				<?php if ( ! isset( $this->input_attrs['value'] ) ) : ?>
					value="<?php echo esc_attr( $this->value() ); ?>"
				<?php endif; ?>
				<?php $this->link(); ?>
				class="range-slider__range">
			<span class="range-slider__value"><?php echo esc_html( $this->value() ); ?></span>
		</div>
		<?php
	}
}
