<?php
/**
 * Base class for the width control.
 *
 * @package Mateo
 */

namespace Mateo;

use \WP_Customize_Manager;

/**
 * Class Width_Customize_Control
 *
 * @package Mateo
 */
class Logo_Customize_Control extends Slider_Customize_Control {

	/**
	 * Constructor.
	 *
	 * Supplied `$args` override class property defaults.
	 *
	 * If `$args['settings']` is not defined, use the $id as the setting ID.
	 *
	 * @since 3.4.0
	 *
	 * @param WP_Customize_Manager $manager Customizer bootstrap instance.
	 * @param string               $id      Control ID.
	 * @param array                $args    Optional. Array of properties for the new Control object. Default empty array.
	 */
	public function __construct( $manager, $id, $args = array() ) {
		$this->section     = 'title_tagline';
		$this->input_attrs = array(
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		);
		$this->priority    = 9;
		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Hides or shows the control on page load.
	 *
	 * @return bool True if has a logo otherwise false.
	 */
	public function active_callback() {
		return has_custom_logo();
	}


}
