<?php
/**
 * Theme Logger used for debugging.
 * It must NOT be activated in production.
 *
 * @package Mateo
 */

namespace Mateo;

use Psr\Log\LoggerInterface;

/**
 * Theme Logger
 *
 * @package Mateo
 */
class Logger {

	/**
	 * Logger instance.
	 *
	 * @var LoggerInterface|null
	 */
	private static $logger;

	/**
	 * Get LoggerInterface instance.
	 *
	 * @return LoggerInterface|null
	 */
	public static function instance() {
		if ( ! static::$logger ) {
			static::$logger = new \Kod\Logger(
				array(
					'channels' => array(
						array(
							'handler' => array(
								'path' => MATEO_THEME_ABSPATH . '/debug.log',
							),
						),
					),
				)
			);
		}

		return static::$logger;
	}
}
