<?php
/**
 * Class Units_Control
 *
 * @package Mateo\Customizer
 */

namespace Mateo\Customizer;

use WP_Customize_Control;
use WP_Customize_Manager;

/**
 * Class Units_Control
 *
 * @package Mateo\Customizer
 */
class Units_Control extends WP_Customize_Control {

	/**
	 * Constructor.
	 *
	 * Supplied `$args` override class property defaults.
	 *
	 * If `$args['settings']` is not defined, use the $id as the setting ID.
	 *
	 * @param WP_Customize_Manager $manager Customizer bootstrap instance.
	 * @param string               $id Control ID.
	 * @param array                $args Optional. Array of properties for the new Control object. Default empty array.
	 */
	public function __construct( $manager, $id, $args = array() ) {
		$this->label   = esc_html__( 'Units', 'mateo' );
		$this->type    = 'select';
		$this->choices = mateo_get_units();
		parent::__construct( $manager, $id, $args );
	}
}
