<?php
/**
 * Pseudo control used as a heading for a group of controls.
 *
 * @package Mateo\Customizer
 */

namespace Mateo\Customizer;

use WP_Customize_Control;

/**
 * Class Title_Control
 */
class Title_Pseudo_Control extends WP_Customize_Control {
	/**
	 * The type of control being rendered.
	 *
	 * @var string Custom control type.
	 */
	public $type = 'mateo_title_control';
	/**
	 * Render the control's content.
	 */
	protected function render_content() {
		$input_id       = '_customize-input-' . $this->id;
		$description_id = '_customize-description-' . $this->id;
		?>
		<div class="customize-section-title">
			<h3><?php echo esc_html( $this->label ); ?></h3>
			<input
				id="<?php echo esc_attr( $input_id ); ?>"
				type="hidden"
				<?php echo ( ! empty( $this->description ) ) ? ' aria-describedby="' . esc_attr( $description_id ) . '" ' : ''; ?>
				<?php $this->link(); ?>
			>
		</div>
		<?php
	}
}
