<?php
/**
 * Numeric control for margins, padding, etc...
 *
 * @package Mateo\Customizer
 */

namespace Mateo\Customizer;

use WP_Customize_Control;
use WP_Customize_Manager;

/**
 * Class Space_Control
 *
 * @package Mateo\Customizer
 */
class Space_Control extends WP_Customize_Control {

	/**
	 * Lower limit of the control.
	 * If null it is ignored.
	 *
	 * @var int|null
	 */
	public $min = 0;
	/**
	 * Step for the input number.
	 *
	 * @var float
	 */
	public $step = 0.01;

	/**
	 * Constructor.
	 *
	 * Supplied `$args` override class property defaults.
	 *
	 * If `$args['settings']` is not defined, use the $id as the setting ID.
	 *
	 * @param WP_Customize_Manager $manager Customizer bootstrap instance.
	 * @param string               $id Control ID.
	 * @param array                $args Optional. Array of properties for the new Control object. Default empty array.
	 */
	public function __construct( $manager, $id, $args = array() ) {
		$this->type = 'number';
		parent::__construct( $manager, $id, $args );
		if ( is_numeric( $this->min ) ) {
			$this->input_attrs['min'] = $this->min;
		}
		if ( $this->step ) {
			$this->input_attrs['step'] = $this->step;
		}
	}
}
