<?php
/**
 * Group_Control allows to display a group of controls and have a common label and description.
 * Child controls may have a label but not the description.
 *
 * @package Mateo\Customizer
 */

namespace  Mateo\Customizer;

use WP_Customize_Control;

/**
 * Class Group_Control
 *
 * @package Mateo\Customizer
 */
class Group_Control extends WP_Customize_Control {
	/**
	 * Control's Type.
	 *
	 * @var string
	 */
	public $type = 'mateo_group_control';
	/**
	 * Array of child controls (WP_Customize_Control).
	 *
	 * @var array
	 */
	public $controls = array();

	/**
	 * CSS rules to append to the container of child controls.
	 *
	 * @var string
	 */
	public $css = '';
	/**
	 * List of available CSS rules.
	 *
	 * @var string[]
	 */
	protected $css_rules = array(
		// 2 controls per line, each one takes half of available space.
		// Last odd control will grow to take all available space.
		'mateo-width-50',
		// Each control displayed on 1 line.
		'mateo-width-100',
	);

	/**
	 * Render label, description and child controls.
	 */
	protected function render_content() {
		$input_id       = '_customize-input-' . $this->id;
		$description_id = '_customize-description-' . $this->id;
		if ( ! empty( $this->label ) ) :?>
			<label for="<?php echo esc_attr( $input_id ); ?>" class="customize-control-title">
				<?php echo esc_html( $this->label ); ?>
			</label>
		<?php endif; ?>
		<?php if ( ! empty( $this->description ) ) : ?>
			<span id="<?php echo esc_attr( $description_id ); ?>" class="description customize-control-description">
					<?php echo esc_html( $this->description ); ?>
			</span>
		<?php endif; ?>
			<div class="mateo-group-control <?php echo esc_attr( $this->css ); ?>">
		<?php
		foreach ( $this->controls as $id => $control ) {
			$this->render_control( $control );
		}
		?>
			</div>
		<?php
	}

	/**
	 * Render the child control's content.
	 * Supported types: <select> and <input type="*">
	 *
	 * @param WP_Customize_Control $control Control to output.
	 */
	protected function render_control( $control ) {
		$input_id = '_customize-input-' . $control->id;
		switch ( $control->type ) {
			case 'select':
				if ( empty( $control->choices ) ) {
					return;
				}

				?>
			<span>
				<?php if ( ! empty( $control->label ) ) : ?>
					<label for="<?php echo esc_attr( $input_id ); ?>"><?php echo esc_html( $control->label ); ?></label>
			<?php endif; ?>

				<select id="<?php echo esc_attr( $input_id ); ?>" <?php $control->link(); ?>>
					<?php
					foreach ( $control->choices as $value => $label ) {
						echo '<option value="' . esc_attr( $value ) . '"' . selected( $control->value(), $value, false ) . '>' . esc_html( $label ) . '</option>';
					}
					?>
				</select>
				</span>
				<?php
				break;
			default:
				?>
			<span>
				<?php if ( ! empty( $control->label ) ) : ?>
				<label for="<?php echo esc_attr( $input_id ); ?>"><?php echo esc_html( $control->label ); ?></label>
			<?php endif; ?>

					<input
						id="<?php echo esc_attr( $input_id ); ?>"
						type="<?php echo esc_attr( $control->type ); ?>"
						<?php $control->input_attrs(); ?>
						<?php if ( ! isset( $control->input_attrs['value'] ) ) : ?>
							value="<?php echo esc_attr( $control->value() ); ?>"
						<?php endif; ?>
						<?php $control->link(); ?>
				/>
			</span>
				<?php
				break;
		}
	}
}
