<?php
/**
 * Base class for font size setting.
 *
 * @package Mateo\Customizer
 */

namespace  Mateo\Customizer;

use WP_Customize_Manager;
use WP_Customize_Setting;
use WP_Error;

/**
 * Class Font_Size_Setting
 *
 * @package Mateo\Customizer
 */
class Font_Size_Setting extends WP_Customize_Setting {
	/**
	 * Lower limit for the font-size.
	 *
	 * @var int
	 */
	public $min = 10;
	/**
	 * Type of the setting's value.
	 * By default: integer.
	 *
	 * @var bool
	 */
	public $is_float = false;
	/**
	 * Constructor.
	 *
	 * Any supplied $args override class property defaults.
	 *
	 * @param WP_Customize_Manager $manager Customizer bootstrap instance.
	 * @param string               $id A specific ID of the setting.
	 *                                                    Can be a theme mod or option name.
	 * @param array                $args Optional. Array of properties for the new Setting object. Default empty array.
	 */
	public function __construct( $manager, $id, $args = array() ) {
		$this->default   = 16;
		$this->transport = 'postMessage';

		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Callback wrapper for $this->sanitize_value() method.
	 *
	 * @param string $value Value to be sanitized.
	 * @param static $instance  Current class instance.
	 *
	 * @return float|int Sanitized and cast value.
	 */
	public static function sanitize_callback( $value, $instance ) {
		return $instance->sanitize_value( $value );
	}
	/**
	 * Sanitizes an input.
	 * Used as a callback.
	 *
	 * @param string|array $value The value to sanitize.
	 *
	 * @return float|int Sanitized and cast value.
	 * @since 3.4.0
	 */
	public function sanitize_value( $value ) {
		return $this->is_float ? (float) $value : (int) $value;
	}

	/**
	 * Validates an input.
	 *
	 * @param mixed $value Value to validate.
	 *
	 * @return true|WP_Error True if the input was validated, otherwise WP_Error.
	 */
	public function validate( $value ) {
		if ( $this->sanitize_value( $value ) < $this->min ) {
			/* translators: Font size numeric value. */
			$msg   = sprintf( esc_html__( 'Font size must be equal or bigger then %s', 'mateo' ), $this->min );
			$value = new WP_Error( 'invalid_font_size', $msg );
		}
		return parent::validate( $value );
	}
}
