<?php
/**
 * Class Font_Size_Control.
 *
 * @package Mateo\Customizer
 */

namespace  Mateo\Customizer;

use WP_Customize_Control;
use WP_Customize_Manager;

/**
 * Class Font_Size_Control
 */
class Font_Size_Control extends WP_Customize_Control {
	/**
	 * Lower limit for the font-size.
	 *
	 * @var int
	 */
	public $min = 10;
	/**
	 * Step for the input of a type number.
	 *
	 * @var int
	 */
	public $step = 0;
	/**
	 * Constructor.
	 *
	 * Supplied `$args` override class property defaults.
	 *
	 * If `$args['settings']` is not defined, use the $id as the setting ID.
	 *
	 * @param WP_Customize_Manager $manager Customizer bootstrap instance.
	 * @param string               $id Control ID.
	 * @param array                $args Optional. Array of properties for the new Control object. Default empty array.
	 */
	public function __construct( $manager, $id, $args = array() ) {
		$this->type = 'number';
		parent::__construct( $manager, $id, $args );
		if ( $this->min ) {
			$this->input_attrs['min'] = $this->min;
		}
		if ( $this->step ) {
			$this->input_attrs['step'] = $this->step;
		}
	}
}
