<?php
/**
 * Class Font_Line_Setting
 *
 * @package Mateo\Customizer
 */

namespace Mateo\Customizer;

use WP_Error;
use WP_Customize_Setting;
use WP_Customize_Manager;

/**
 * Base class for the font line setting.
 */
class Font_Line_Setting extends WP_Customize_Setting {
	/**
	 * Lower limit for the font-line.
	 *
	 * @var int
	 */
	public $min = 1;
	/**
	 * Constructor.
	 *
	 * Any supplied $args override class property defaults.
	 *
	 * @param WP_Customize_Manager $manager Customizer bootstrap instance.
	 * @param string               $id A specific ID of the setting.
	 *                                                    Can be a theme mod or option name.
	 * @param array                $args Optional. Array of properties for the new Setting object. Default empty array.
	 */
	public function __construct( $manager, $id, $args = array() ) {
		$this->default   = 1.5;
		$this->transport = 'postMessage';

		parent::__construct( $manager, $id, $args );
	}

	/**
	 * Callback wrapper for $this->sanitize_value() method.
	 *
	 * @param string $value Value to be sanitized.
	 * @param static $instance  Current class instance.
	 *
	 * @return float|int Sanitized and cast value.
	 */
	public static function sanitize_callback( $value, $instance ) {
		return $instance->sanitize_value( $value );
	}

	/**
	 * Sanitizes an input.
	 * Used as a callback.
	 *
	 * @param string $value The value to sanitize.
	 *
	 * @return string|array|null|WP_Error Sanitized value, or `null`/`WP_Error` if invalid.
	 * @since 3.4.0
	 */
	public function sanitize_value( $value ) {
		if ( false !== strpos( $value, ',' ) ) {
			$value = str_replace( ',', '.', $value );
		}
		return floatval( $value );
	}

	/**
	 * Validates an input.
	 *
	 * @param mixed $value Value to validate.
	 *
	 * @return true|WP_Error True if the input was validated, otherwise WP_Error.
	 * @since 4.6.0
	 *
	 * @see WP_REST_Request::has_valid_params()
	 */
	public function validate( $value ) {
		if ( null !== $this->min && $this->sanitize_value( $value ) < $this->min ) {
			/* translators: Font line numeric value. */
			$msg   = sprintf( esc_html__( 'Font line must be equal or bigger then %s.', 'mateo' ), $this->min );
			$error = new WP_Error( 'invalid_font_line', $msg );
			$value = $error;
		}
		return parent::validate( $value );
	}
}
