<?php
/**
 * Class Font_Line_Control
 *
 * @package Mateo\Customizer
 */

namespace  Mateo\Customizer;

use WP_Customize_Control;
use WP_Customize_Manager;

/**
 * Base class for generating a font line control
 */
class Font_Line_Control extends WP_Customize_Control {
	/**
	 * Lower limit for the font-line.
	 * If null it won't be appended to the input.
	 *
	 * @var int
	 */
	public $min = 1;
	/**
	 * Step for the input number.
	 *
	 * @var float
	 */
	public $step = 0.1;

	/**
	 * Constructor.
	 *
	 * Supplied `$args` override class property defaults.
	 *
	 * If `$args['settings']` is not defined, use the $id as the setting ID.
	 *
	 * @param WP_Customize_Manager $manager Customizer bootstrap instance.
	 * @param string               $id Control ID.
	 * @param array                $args Optional. Array of properties for the new Control object. Default empty array.
	 */
	public function __construct( $manager, $id, $args = array() ) {
		$this->type = 'number';

		parent::__construct( $manager, $id, $args );
		if ( is_numeric( $this->min ) ) {
			$this->input_attrs['min'] = $this->min;
		}
		if ( $this->step ) {
			$this->input_attrs['step'] = $this->step;
		}
	}
}
