<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package mateo
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>
<body id="wrapper" <?php body_class(); ?>>
<?php wp_body_open(); ?>
<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'mateo' ); ?></a>
<?php do_action( 'mateo_before_header' ); ?>

<?php get_template_part( 'template-parts/header/site-header' ); ?>

<?php do_action( 'mateo_after_header' ); ?>
<?php if ( mateo_is_show_title_area() ) : ?>
<div class="header-featured<?php echo mateo_has_featured_img() ? ' has-image' : ''; ?>">

	<div class="page-header">

		<?php do_action( 'mateo_before_site_title' ); ?>

		<h1 class="page-title <?php mateo_page_title_classes(); ?>">
			<span>
		<?php if ( is_archive() ) : ?>
			<?php
			the_archive_title();
			?>
		<?php elseif ( is_search() ) : ?>
			<?php esc_html_e( 'Search: ', 'mateo' ); ?><?php echo get_search_query(); ?>
		<?php elseif ( is_404() ) : ?>
			<?php esc_html_e( 'Page not found', 'mateo' ); ?>
		<?php else : ?>
			<?php mateo_header_title(); ?>
		<?php endif; ?>
			</span>
		</h1>

		<?php do_action( 'mateo_after_site_title' ); ?>

	</div>
</div>
<?php endif; ?>

<?php do_action( 'mateo_before_content_container' ); ?>
<div class="content-wrapper">
	<div id="content" class="site-content <?php mateo_site_content_classes(); ?>">
	<?php do_action( 'mateo_before_main_content' ); ?>
