<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package mateo
 */

?>
<?php do_action( 'mateo_after_main_content' ); ?>

<?php
if ( ( ! mateo_is_layout_one_column() && mateo_is_active_sidebar() ) ) :
	?>
		<?php do_action( 'mateo_before_sidebar' ); ?>

		<aside class="widget-area sidebar" role="complementary" aria-label="<?php esc_attr_e( 'Sidebar', 'mateo' ); ?>">

			<?php do_action( 'mateo_in_sidebar_start' ); ?>

			<?php dynamic_sidebar( 'sidebar-1' ); ?>

			<?php do_action( 'mateo_in_sidebar_end' ); ?>

		</aside>

		<?php do_action( 'mateo_after_sidebar' ); ?>

<?php endif; ?>

</div><!-- .#content -->
</div>
<?php do_action( 'mateo_before_footer' ); ?>

<footer id="colophon" class="page-footer ">
	<div class="content-wrapper footer-widget-area">
		<div class=" footer-width">
			<?php get_template_part( 'template-parts/footer/footer', 'widgets' ); ?>
		</div>
	</div>
	<div class="content-wrapper footer-copyright-area">
		<div class="footer-copyright footer-width">
			<span>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a>
			</span>
			|
			<span>
				<a href="<?php echo esc_url( __( 'https://alliancetheme.com/', 'mateo' ) ); ?>">
					<?php esc_html_e( 'Mateo Theme', 'mateo' ); ?>
				</a>
			</span>
			<span>
				<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'mateo' ) ); ?>">
					<?php esc_html_e( 'powered by WordPress', 'mateo' ); ?>
				</a>
			</span>
		</div>
	</div>
</footer>

<?php do_action( 'mateo_after_footer' ); ?>

<div class="fixed-bottom-actions">
	<?php mateo_the_post_edit_button(); ?>
</div>
<?php wp_footer(); ?>
</body>
</html>
