<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package mateo
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
		?>
		<h2 class="comments-title">
			<?php
			$mateo_comment_count = (int) get_comments_number();
			if ( 0 === $mateo_comment_count ) {
				printf(
				/* translators: 1: title. */
					esc_html__( 'One thought on &ldquo;%1$s&rdquo;', 'mateo' ),
					'<span>' . esc_html( get_the_title() ) . '</span>'
				);
			} else {
				printf( // phpcs:ignore
				/* translators: 1: comment count number, 2: title. */
					esc_html( _nx( '%1$s thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', $mateo_comment_count, 'comments title', 'mateo' ) ),
					esc_html( number_format_i18n( $mateo_comment_count ) ),
					'<span>' . esc_html( get_the_title() ) . '</span>'
				);
			}
			?>
		</h2><!-- .comments-title -->

		<?php
		the_comments_navigation(
			array(
				'prev_text' => '<span class="post-nav-arrow material-icons">chevron_left</span><span class="post-nav-title">' . __( 'Older comments', 'mateo' ) . '</span>',
				'next_text' => '<span class="post-nav-title">' . __( 'Newer comments', 'mateo' ) . '</span><span class="post-nav-arrow  material-icons">chevron_right</span>',
			)
		);
		?>
		<ul class="comment-list">
			<?php
			wp_list_comments(
				array(
					'style'       => 'ul',
					'short_ping'  => true,
					'avatar_size' => 60,
					'callback'    => 'mateo_html5_comment',
				)
			);
			?>
		</ul><!-- .comment-list -->

		<?php
		the_comments_navigation(
			array(
				'prev_text' => '<span class="post-nav-arrow material-icons">chevron_left</span><span class="post-nav-title">' . __( 'Older comments', 'mateo' ) . '</span>',
				'next_text' => '<span class="post-nav-title">' . __( 'Newer comments', 'mateo' ) . '</span><span class="post-nav-arrow  material-icons">chevron_right</span>',
			)
		);

		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() ) :
			?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'mateo' ); ?></p>
			<?php
		endif;

	endif; // Check for have_comments().
	mateo_comment_form();
	?>

</div><!-- #comments -->
