(function ($) {
  'use strict';

  $ = $ && Object.prototype.hasOwnProperty.call($, 'default') ? $['default'] : $;

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    subClass.__proto__ = superClass;
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _createForOfIteratorHelperLoose(o, allowArrayLike) {
    var it;

    if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
      if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
        if (it) o = it;
        var i = 0;
        return function () {
          if (i >= o.length) return {
            done: true
          };
          return {
            done: false,
            value: o[i++]
          };
        };
      }

      throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    it = o[Symbol.iterator]();
    return it.next.bind(it);
  }

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v4.5.0): util.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Private TransitionEnd Helpers
   * ------------------------------------------------------------------------
   */

  var TRANSITION_END = 'transitionend';
  var MAX_UID = 1000000;
  var MILLISECONDS_MULTIPLIER = 1000; // Shoutout AngusCroll (https://goo.gl/pxwQGp)

  function toType(obj) {
    if (obj === null || typeof obj === 'undefined') {
      return "" + obj;
    }

    return {}.toString.call(obj).match(/\s([a-z]+)/i)[1].toLowerCase();
  }

  function getSpecialTransitionEndEvent() {
    return {
      bindType: TRANSITION_END,
      delegateType: TRANSITION_END,
      handle: function handle(event) {
        if ($(event.target).is(this)) {
          return event.handleObj.handler.apply(this, arguments); // eslint-disable-line prefer-rest-params
        }

        return undefined;
      }
    };
  }

  function transitionEndEmulator(duration) {
    var _this = this;

    var called = false;
    $(this).one(Util.TRANSITION_END, function () {
      called = true;
    });
    setTimeout(function () {
      if (!called) {
        Util.triggerTransitionEnd(_this);
      }
    }, duration);
    return this;
  }

  function setTransitionEndSupport() {
    $.fn.emulateTransitionEnd = transitionEndEmulator;
    $.event.special[Util.TRANSITION_END] = getSpecialTransitionEndEvent();
  }
  /**
   * --------------------------------------------------------------------------
   * Public Util Api
   * --------------------------------------------------------------------------
   */


  var Util = {
    TRANSITION_END: 'bsTransitionEnd',
    getUID: function getUID(prefix) {
      do {
        // eslint-disable-next-line no-bitwise
        prefix += ~~(Math.random() * MAX_UID); // "~~" acts like a faster Math.floor() here
      } while (document.getElementById(prefix));

      return prefix;
    },
    getSelectorFromElement: function getSelectorFromElement(element) {
      var selector = element.getAttribute('data-target');

      if (!selector || selector === '#') {
        var hrefAttr = element.getAttribute('href');
        selector = hrefAttr && hrefAttr !== '#' ? hrefAttr.trim() : '';
      }

      try {
        return document.querySelector(selector) ? selector : null;
      } catch (err) {
        return null;
      }
    },
    getTransitionDurationFromElement: function getTransitionDurationFromElement(element) {
      if (!element) {
        return 0;
      } // Get transition-duration of the element


      var transitionDuration = $(element).css('transition-duration');
      var transitionDelay = $(element).css('transition-delay');
      var floatTransitionDuration = parseFloat(transitionDuration);
      var floatTransitionDelay = parseFloat(transitionDelay); // Return 0 if element or transition duration is not found

      if (!floatTransitionDuration && !floatTransitionDelay) {
        return 0;
      } // If multiple durations are defined, take the first


      transitionDuration = transitionDuration.split(',')[0];
      transitionDelay = transitionDelay.split(',')[0];
      return (parseFloat(transitionDuration) + parseFloat(transitionDelay)) * MILLISECONDS_MULTIPLIER;
    },
    reflow: function reflow(element) {
      return element.offsetHeight;
    },
    triggerTransitionEnd: function triggerTransitionEnd(element) {
      $(element).trigger(TRANSITION_END);
    },
    // TODO: Remove in v5
    supportsTransitionEnd: function supportsTransitionEnd() {
      return Boolean(TRANSITION_END);
    },
    isElement: function isElement(obj) {
      return (obj[0] || obj).nodeType;
    },
    typeCheckConfig: function typeCheckConfig(componentName, config, configTypes) {
      for (var property in configTypes) {
        if (Object.prototype.hasOwnProperty.call(configTypes, property)) {
          var expectedTypes = configTypes[property];
          var value = config[property];
          var valueType = value && Util.isElement(value) ? 'element' : toType(value);

          if (!new RegExp(expectedTypes).test(valueType)) {
            throw new Error(componentName.toUpperCase() + ": " + ("Option \"" + property + "\" provided type \"" + valueType + "\" ") + ("but expected type \"" + expectedTypes + "\"."));
          }
        }
      }
    },
    findShadowRoot: function findShadowRoot(element) {
      if (!document.documentElement.attachShadow) {
        return null;
      } // Can find the shadow root otherwise it'll return the document


      if (typeof element.getRootNode === 'function') {
        var root = element.getRootNode();
        return root instanceof ShadowRoot ? root : null;
      }

      if (element instanceof ShadowRoot) {
        return element;
      } // when we don't find a shadow root


      if (!element.parentNode) {
        return null;
      }

      return Util.findShadowRoot(element.parentNode);
    },
    jQueryDetection: function jQueryDetection() {
      if (typeof $ === 'undefined') {
        throw new TypeError('Bootstrap\'s JavaScript requires jQuery. jQuery must be included before Bootstrap\'s JavaScript.');
      }

      var version = $.fn.jquery.split(' ')[0].split('.');
      var minMajor = 1;
      var ltMajor = 2;
      var minMinor = 9;
      var minPatch = 1;
      var maxMajor = 4;

      if (version[0] < ltMajor && version[1] < minMinor || version[0] === minMajor && version[1] === minMinor && version[2] < minPatch || version[0] >= maxMajor) {
        throw new Error('Bootstrap\'s JavaScript requires at least jQuery v1.9.1 but less than v4.0.0');
      }
    }
  };
  Util.jQueryDetection();
  setTransitionEndSupport();

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  var NAME = 'carousel';
  var VERSION = '4.5.0';
  var DATA_KEY = 'bs.carousel';
  var EVENT_KEY = "." + DATA_KEY;
  var DATA_API_KEY = '.data-api';
  var JQUERY_NO_CONFLICT = $.fn[NAME];
  var ARROW_LEFT_KEYCODE = 37; // KeyboardEvent.which value for left arrow key

  var ARROW_RIGHT_KEYCODE = 39; // KeyboardEvent.which value for right arrow key

  var TOUCHEVENT_COMPAT_WAIT = 500; // Time for mouse compat events to fire after touch

  var SWIPE_THRESHOLD = 40;
  var Default = {
    interval: 5000,
    keyboard: true,
    slide: false,
    pause: 'hover',
    wrap: true,
    touch: true
  };
  var DefaultType = {
    interval: '(number|boolean)',
    keyboard: 'boolean',
    slide: '(boolean|string)',
    pause: '(string|boolean)',
    wrap: 'boolean',
    touch: 'boolean'
  };
  var DIRECTION_NEXT = 'next';
  var DIRECTION_PREV = 'prev';
  var DIRECTION_LEFT = 'left';
  var DIRECTION_RIGHT = 'right';
  var EVENT_SLIDE = "slide" + EVENT_KEY;
  var EVENT_SLID = "slid" + EVENT_KEY;
  var EVENT_KEYDOWN = "keydown" + EVENT_KEY;
  var EVENT_MOUSEENTER = "mouseenter" + EVENT_KEY;
  var EVENT_MOUSELEAVE = "mouseleave" + EVENT_KEY;
  var EVENT_TOUCHSTART = "touchstart" + EVENT_KEY;
  var EVENT_TOUCHMOVE = "touchmove" + EVENT_KEY;
  var EVENT_TOUCHEND = "touchend" + EVENT_KEY;
  var EVENT_POINTERDOWN = "pointerdown" + EVENT_KEY;
  var EVENT_POINTERUP = "pointerup" + EVENT_KEY;
  var EVENT_DRAG_START = "dragstart" + EVENT_KEY;
  var EVENT_LOAD_DATA_API = "load" + EVENT_KEY + DATA_API_KEY;
  var EVENT_CLICK_DATA_API = "click" + EVENT_KEY + DATA_API_KEY;
  var CLASS_NAME_CAROUSEL = 'carousel';
  var CLASS_NAME_ACTIVE = 'active';
  var CLASS_NAME_SLIDE = 'slide';
  var CLASS_NAME_RIGHT = 'carousel-item-right';
  var CLASS_NAME_LEFT = 'carousel-item-left';
  var CLASS_NAME_NEXT = 'carousel-item-next';
  var CLASS_NAME_PREV = 'carousel-item-prev';
  var CLASS_NAME_POINTER_EVENT = 'pointer-event';
  var SELECTOR_ACTIVE = '.active';
  var SELECTOR_ACTIVE_ITEM = '.active.carousel-item';
  var SELECTOR_ITEM = '.carousel-item';
  var SELECTOR_ITEM_IMG = '.carousel-item img';
  var SELECTOR_NEXT_PREV = '.carousel-item-next, .carousel-item-prev';
  var SELECTOR_INDICATORS = '.carousel-indicators';
  var SELECTOR_DATA_SLIDE = '[data-slide], [data-slide-to]';
  var SELECTOR_DATA_RIDE = '[data-ride="carousel"]';
  var PointerType = {
    TOUCH: 'touch',
    PEN: 'pen'
  };
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  var Carousel = /*#__PURE__*/function () {
    function Carousel(element, config) {
      this._items = null;
      this._interval = null;
      this._activeElement = null;
      this._isPaused = false;
      this._isSliding = false;
      this.touchTimeout = null;
      this.touchStartX = 0;
      this.touchDeltaX = 0;
      this._config = this._getConfig(config);
      this._element = element;
      this._indicatorsElement = this._element.querySelector(SELECTOR_INDICATORS);
      this._touchSupported = 'ontouchstart' in document.documentElement || navigator.maxTouchPoints > 0;
      this._pointerEvent = Boolean(window.PointerEvent || window.MSPointerEvent);

      this._addEventListeners();
    } // Getters


    var _proto = Carousel.prototype;

    // Public
    _proto.next = function next() {
      if (!this._isSliding) {
        this._slide(DIRECTION_NEXT);
      }
    };

    _proto.nextWhenVisible = function nextWhenVisible() {
      // Don't call next when the page isn't visible
      // or the carousel or its parent isn't visible
      if (!document.hidden && $(this._element).is(':visible') && $(this._element).css('visibility') !== 'hidden') {
        this.next();
      }
    };

    _proto.prev = function prev() {
      if (!this._isSliding) {
        this._slide(DIRECTION_PREV);
      }
    };

    _proto.pause = function pause(event) {
      if (!event) {
        this._isPaused = true;
      }

      if (this._element.querySelector(SELECTOR_NEXT_PREV)) {
        Util.triggerTransitionEnd(this._element);
        this.cycle(true);
      }

      clearInterval(this._interval);
      this._interval = null;
    };

    _proto.cycle = function cycle(event) {
      if (!event) {
        this._isPaused = false;
      }

      if (this._interval) {
        clearInterval(this._interval);
        this._interval = null;
      }

      if (this._config.interval && !this._isPaused) {
        this._interval = setInterval((document.visibilityState ? this.nextWhenVisible : this.next).bind(this), this._config.interval);
      }
    };

    _proto.to = function to(index) {
      var _this = this;

      this._activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      var activeIndex = this._getItemIndex(this._activeElement);

      if (index > this._items.length - 1 || index < 0) {
        return;
      }

      if (this._isSliding) {
        $(this._element).one(EVENT_SLID, function () {
          return _this.to(index);
        });
        return;
      }

      if (activeIndex === index) {
        this.pause();
        this.cycle();
        return;
      }

      var direction = index > activeIndex ? DIRECTION_NEXT : DIRECTION_PREV;

      this._slide(direction, this._items[index]);
    };

    _proto.dispose = function dispose() {
      $(this._element).off(EVENT_KEY);
      $.removeData(this._element, DATA_KEY);
      this._items = null;
      this._config = null;
      this._element = null;
      this._interval = null;
      this._isPaused = null;
      this._isSliding = null;
      this._activeElement = null;
      this._indicatorsElement = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _objectSpread2(_objectSpread2({}, Default), config);
      Util.typeCheckConfig(NAME, config, DefaultType);
      return config;
    };

    _proto._handleSwipe = function _handleSwipe() {
      var absDeltax = Math.abs(this.touchDeltaX);

      if (absDeltax <= SWIPE_THRESHOLD) {
        return;
      }

      var direction = absDeltax / this.touchDeltaX;
      this.touchDeltaX = 0; // swipe left

      if (direction > 0) {
        this.prev();
      } // swipe right


      if (direction < 0) {
        this.next();
      }
    };

    _proto._addEventListeners = function _addEventListeners() {
      var _this2 = this;

      if (this._config.keyboard) {
        $(this._element).on(EVENT_KEYDOWN, function (event) {
          return _this2._keydown(event);
        });
      }

      if (this._config.pause === 'hover') {
        $(this._element).on(EVENT_MOUSEENTER, function (event) {
          return _this2.pause(event);
        }).on(EVENT_MOUSELEAVE, function (event) {
          return _this2.cycle(event);
        });
      }

      if (this._config.touch) {
        this._addTouchEventListeners();
      }
    };

    _proto._addTouchEventListeners = function _addTouchEventListeners() {
      var _this3 = this;

      if (!this._touchSupported) {
        return;
      }

      var start = function start(event) {
        if (_this3._pointerEvent && PointerType[event.originalEvent.pointerType.toUpperCase()]) {
          _this3.touchStartX = event.originalEvent.clientX;
        } else if (!_this3._pointerEvent) {
          _this3.touchStartX = event.originalEvent.touches[0].clientX;
        }
      };

      var move = function move(event) {
        // ensure swiping with one touch and not pinching
        if (event.originalEvent.touches && event.originalEvent.touches.length > 1) {
          _this3.touchDeltaX = 0;
        } else {
          _this3.touchDeltaX = event.originalEvent.touches[0].clientX - _this3.touchStartX;
        }
      };

      var end = function end(event) {
        if (_this3._pointerEvent && PointerType[event.originalEvent.pointerType.toUpperCase()]) {
          _this3.touchDeltaX = event.originalEvent.clientX - _this3.touchStartX;
        }

        _this3._handleSwipe();

        if (_this3._config.pause === 'hover') {
          // If it's a touch-enabled device, mouseenter/leave are fired as
          // part of the mouse compatibility events on first tap - the carousel
          // would stop cycling until user tapped out of it;
          // here, we listen for touchend, explicitly pause the carousel
          // (as if it's the second time we tap on it, mouseenter compat event
          // is NOT fired) and after a timeout (to allow for mouse compatibility
          // events to fire) we explicitly restart cycling
          _this3.pause();

          if (_this3.touchTimeout) {
            clearTimeout(_this3.touchTimeout);
          }

          _this3.touchTimeout = setTimeout(function (event) {
            return _this3.cycle(event);
          }, TOUCHEVENT_COMPAT_WAIT + _this3._config.interval);
        }
      };

      $(this._element.querySelectorAll(SELECTOR_ITEM_IMG)).on(EVENT_DRAG_START, function (e) {
        return e.preventDefault();
      });

      if (this._pointerEvent) {
        $(this._element).on(EVENT_POINTERDOWN, function (event) {
          return start(event);
        });
        $(this._element).on(EVENT_POINTERUP, function (event) {
          return end(event);
        });

        this._element.classList.add(CLASS_NAME_POINTER_EVENT);
      } else {
        $(this._element).on(EVENT_TOUCHSTART, function (event) {
          return start(event);
        });
        $(this._element).on(EVENT_TOUCHMOVE, function (event) {
          return move(event);
        });
        $(this._element).on(EVENT_TOUCHEND, function (event) {
          return end(event);
        });
      }
    };

    _proto._keydown = function _keydown(event) {
      if (/input|textarea/i.test(event.target.tagName)) {
        return;
      }

      switch (event.which) {
        case ARROW_LEFT_KEYCODE:
          event.preventDefault();
          this.prev();
          break;

        case ARROW_RIGHT_KEYCODE:
          event.preventDefault();
          this.next();
          break;
      }
    };

    _proto._getItemIndex = function _getItemIndex(element) {
      this._items = element && element.parentNode ? [].slice.call(element.parentNode.querySelectorAll(SELECTOR_ITEM)) : [];
      return this._items.indexOf(element);
    };

    _proto._getItemByDirection = function _getItemByDirection(direction, activeElement) {
      var isNextDirection = direction === DIRECTION_NEXT;
      var isPrevDirection = direction === DIRECTION_PREV;

      var activeIndex = this._getItemIndex(activeElement);

      var lastItemIndex = this._items.length - 1;
      var isGoingToWrap = isPrevDirection && activeIndex === 0 || isNextDirection && activeIndex === lastItemIndex;

      if (isGoingToWrap && !this._config.wrap) {
        return activeElement;
      }

      var delta = direction === DIRECTION_PREV ? -1 : 1;
      var itemIndex = (activeIndex + delta) % this._items.length;
      return itemIndex === -1 ? this._items[this._items.length - 1] : this._items[itemIndex];
    };

    _proto._triggerSlideEvent = function _triggerSlideEvent(relatedTarget, eventDirectionName) {
      var targetIndex = this._getItemIndex(relatedTarget);

      var fromIndex = this._getItemIndex(this._element.querySelector(SELECTOR_ACTIVE_ITEM));

      var slideEvent = $.Event(EVENT_SLIDE, {
        relatedTarget: relatedTarget,
        direction: eventDirectionName,
        from: fromIndex,
        to: targetIndex
      });
      $(this._element).trigger(slideEvent);
      return slideEvent;
    };

    _proto._setActiveIndicatorElement = function _setActiveIndicatorElement(element) {
      if (this._indicatorsElement) {
        var indicators = [].slice.call(this._indicatorsElement.querySelectorAll(SELECTOR_ACTIVE));
        $(indicators).removeClass(CLASS_NAME_ACTIVE);

        var nextIndicator = this._indicatorsElement.children[this._getItemIndex(element)];

        if (nextIndicator) {
          $(nextIndicator).addClass(CLASS_NAME_ACTIVE);
        }
      }
    };

    _proto._slide = function _slide(direction, element) {
      var _this4 = this;

      var activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      var activeElementIndex = this._getItemIndex(activeElement);

      var nextElement = element || activeElement && this._getItemByDirection(direction, activeElement);

      var nextElementIndex = this._getItemIndex(nextElement);

      var isCycling = Boolean(this._interval);
      var directionalClassName;
      var orderClassName;
      var eventDirectionName;

      if (direction === DIRECTION_NEXT) {
        directionalClassName = CLASS_NAME_LEFT;
        orderClassName = CLASS_NAME_NEXT;
        eventDirectionName = DIRECTION_LEFT;
      } else {
        directionalClassName = CLASS_NAME_RIGHT;
        orderClassName = CLASS_NAME_PREV;
        eventDirectionName = DIRECTION_RIGHT;
      }

      if (nextElement && $(nextElement).hasClass(CLASS_NAME_ACTIVE)) {
        this._isSliding = false;
        return;
      }

      var slideEvent = this._triggerSlideEvent(nextElement, eventDirectionName);

      if (slideEvent.isDefaultPrevented()) {
        return;
      }

      if (!activeElement || !nextElement) {
        // Some weirdness is happening, so we bail
        return;
      }

      this._isSliding = true;

      if (isCycling) {
        this.pause();
      }

      this._setActiveIndicatorElement(nextElement);

      var slidEvent = $.Event(EVENT_SLID, {
        relatedTarget: nextElement,
        direction: eventDirectionName,
        from: activeElementIndex,
        to: nextElementIndex
      });

      if ($(this._element).hasClass(CLASS_NAME_SLIDE)) {
        $(nextElement).addClass(orderClassName);
        Util.reflow(nextElement);
        $(activeElement).addClass(directionalClassName);
        $(nextElement).addClass(directionalClassName);
        var nextElementInterval = parseInt(nextElement.getAttribute('data-interval'), 10);

        if (nextElementInterval) {
          this._config.defaultInterval = this._config.defaultInterval || this._config.interval;
          this._config.interval = nextElementInterval;
        } else {
          this._config.interval = this._config.defaultInterval || this._config.interval;
        }

        var transitionDuration = Util.getTransitionDurationFromElement(activeElement);
        $(activeElement).one(Util.TRANSITION_END, function () {
          $(nextElement).removeClass(directionalClassName + " " + orderClassName).addClass(CLASS_NAME_ACTIVE);
          $(activeElement).removeClass(CLASS_NAME_ACTIVE + " " + orderClassName + " " + directionalClassName);
          _this4._isSliding = false;
          setTimeout(function () {
            return $(_this4._element).trigger(slidEvent);
          }, 0);
        }).emulateTransitionEnd(transitionDuration);
      } else {
        $(activeElement).removeClass(CLASS_NAME_ACTIVE);
        $(nextElement).addClass(CLASS_NAME_ACTIVE);
        this._isSliding = false;
        $(this._element).trigger(slidEvent);
      }

      if (isCycling) {
        this.cycle();
      }
    } // Static
    ;

    Carousel._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $(this).data(DATA_KEY);

        var _config = _objectSpread2(_objectSpread2({}, Default), $(this).data());

        if (typeof config === 'object') {
          _config = _objectSpread2(_objectSpread2({}, _config), config);
        }

        var action = typeof config === 'string' ? config : _config.slide;

        if (!data) {
          data = new Carousel(this, _config);
          $(this).data(DATA_KEY, data);
        }

        if (typeof config === 'number') {
          data.to(config);
        } else if (typeof action === 'string') {
          if (typeof data[action] === 'undefined') {
            throw new TypeError("No method named \"" + action + "\"");
          }

          data[action]();
        } else if (_config.interval && _config.ride) {
          data.pause();
          data.cycle();
        }
      });
    };

    Carousel._dataApiClickHandler = function _dataApiClickHandler(event) {
      var selector = Util.getSelectorFromElement(this);

      if (!selector) {
        return;
      }

      var target = $(selector)[0];

      if (!target || !$(target).hasClass(CLASS_NAME_CAROUSEL)) {
        return;
      }

      var config = _objectSpread2(_objectSpread2({}, $(target).data()), $(this).data());

      var slideIndex = this.getAttribute('data-slide-to');

      if (slideIndex) {
        config.interval = false;
      }

      Carousel._jQueryInterface.call($(target), config);

      if (slideIndex) {
        $(target).data(DATA_KEY).to(slideIndex);
      }

      event.preventDefault();
    };

    _createClass(Carousel, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default;
      }
    }]);

    return Carousel;
  }();
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  $(document).on(EVENT_CLICK_DATA_API, SELECTOR_DATA_SLIDE, Carousel._dataApiClickHandler);
  $(window).on(EVENT_LOAD_DATA_API, function () {
    var carousels = [].slice.call(document.querySelectorAll(SELECTOR_DATA_RIDE));

    for (var i = 0, len = carousels.length; i < len; i++) {
      var $carousel = $(carousels[i]);

      Carousel._jQueryInterface.call($carousel, $carousel.data());
    }
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   */

  $.fn[NAME] = Carousel._jQueryInterface;
  $.fn[NAME].Constructor = Carousel;

  $.fn[NAME].noConflict = function () {
    $.fn[NAME] = JQUERY_NO_CONFLICT;
    return Carousel._jQueryInterface;
  };

  var Util$1 = function () {
    /**
     * ------------------------------------------------------------------------
     * Private TransitionEnd Helpers
     * ------------------------------------------------------------------------
     */
    var transitionEnd = false;
    var _transitionEndSelector = "";
    var TransitionEndEvent = {
      WebkitTransition: "webkitTransitionEnd",
      MozTransition: "transitionend",
      OTransition: "oTransitionEnd otransitionend",
      transition: "transitionend"
    };

    function transitionEndTest() {
      if (window.QUnit) {
        return false;
      }

      var el = document.createElement("bmd");

      for (var name in TransitionEndEvent) {
        if (el.style[name] !== undefined) {
          return TransitionEndEvent[name]; // { end: TransitionEndEvent[name] }
        }
      }

      return false;
    }

    function setTransitionEndSupport() {
      transitionEnd = transitionEndTest(); // generate a concatenated transition end event selector

      for (var name in TransitionEndEvent) {
        _transitionEndSelector += " " + TransitionEndEvent[name];
      }
    }
    /**
     * --------------------------------------------------------------------------
     * Public Util Api
     * --------------------------------------------------------------------------
     */


    var Util = {
      transitionEndSupported: function transitionEndSupported() {
        return transitionEnd;
      },
      transitionEndSelector: function transitionEndSelector() {
        return _transitionEndSelector;
      },
      isChar: function isChar(event) {
        if (typeof event.which === "undefined") {
          return true;
        } else if (typeof event.which === "number" && event.which > 0) {
          return !event.ctrlKey && !event.metaKey && !event.altKey && event.which !== 8 && // backspace
          event.which !== 9 && // tab
          event.which !== 13 && // enter
          event.which !== 16 && // shift
          event.which !== 17 && // ctrl
          event.which !== 20 && // caps lock
          event.which !== 27 // escape
          ;
        }

        return false;
      },
      assert: function assert($element, invalidTest, message) {
        if (invalidTest) {
          if (!$element === undefined) {
            $element.css("border", "1px solid red");
          }

          console.error(message, $element); // eslint-disable-line no-console

          throw message;
        }
      },
      describe: function describe($element) {
        if ($element === undefined) {
          return "undefined";
        } else if ($element.length === 0) {
          return "(no matching elements)";
        }

        return $element[0].outerHTML.split(">")[0] + ">";
      }
    };
    setTransitionEndSupport();
    return Util;
  }(jQuery);

  var Base = function ($) {
    var ClassName = {
      BMD_FORM_GROUP: "bmd-form-group",
      IS_FILLED: "is-filled",
      IS_FOCUSED: "is-focused"
    };
    var Selector = {
      BMD_FORM_GROUP: "." + ClassName.BMD_FORM_GROUP
    };
    var Default = {};
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    var Base = /*#__PURE__*/function () {
      /**
       *
       * @param element
       * @param config
       * @param properties - anything that needs to be set as this[key] = value.  Works around the need to call `super` before using `this`
       */
      function Base($element, config, properties) {
        if (properties === void 0) {
          properties = {};
        }

        this.$element = $element;
        this.config = $.extend(true, {}, Default, config); // set properties for use in the constructor initialization

        for (var key in properties) {
          this[key] = properties[key];
        }
      }

      var _proto = Base.prototype;

      _proto.dispose = function dispose(dataKey) {
        this.$element.data(dataKey, null);
        this.$element = null;
        this.config = null;
      } // ------------------------------------------------------------------------
      // protected
      ;

      _proto.addFormGroupFocus = function addFormGroupFocus() {
        if (!this.$element.prop("disabled")) {
          this.$bmdFormGroup.addClass(ClassName.IS_FOCUSED);
        }
      };

      _proto.removeFormGroupFocus = function removeFormGroupFocus() {
        this.$bmdFormGroup.removeClass(ClassName.IS_FOCUSED);
      };

      _proto.removeIsFilled = function removeIsFilled() {
        this.$bmdFormGroup.removeClass(ClassName.IS_FILLED);
      };

      _proto.addIsFilled = function addIsFilled() {
        this.$bmdFormGroup.addClass(ClassName.IS_FILLED);
      } // Find bmd-form-group
      ;

      _proto.findMdbFormGroup = function findMdbFormGroup(raiseError) {
        if (raiseError === void 0) {
          raiseError = true;
        }

        var mfg = this.$element.closest(Selector.BMD_FORM_GROUP);

        if (mfg.length === 0 && raiseError) {
          $.error("Failed to find " + Selector.BMD_FORM_GROUP + " for " + Util$1.describe(this.$element));
        }

        return mfg;
      } // ------------------------------------------------------------------------
      // private
      // ------------------------------------------------------------------------
      // static
      ;

      return Base;
    }();

    return Base;
  }(jQuery);

  var BaseInput = function ($) {
    var ClassName = {
      FORM_GROUP: "form-group",
      BMD_FORM_GROUP: "bmd-form-group",
      BMD_LABEL: "bmd-label",
      BMD_LABEL_STATIC: "bmd-label-static",
      BMD_LABEL_PLACEHOLDER: "bmd-label-placeholder",
      BMD_LABEL_FLOATING: "bmd-label-floating",
      HAS_DANGER: "has-danger",
      IS_FILLED: "is-filled",
      IS_FOCUSED: "is-focused",
      INPUT_GROUP: "input-group"
    };
    var Selector = {
      FORM_GROUP: "." + ClassName.FORM_GROUP,
      BMD_FORM_GROUP: "." + ClassName.BMD_FORM_GROUP,
      BMD_LABEL_WILDCARD: "label[class^='" + ClassName.BMD_LABEL + "'], label[class*=' " + ClassName.BMD_LABEL + "']" // match any label variant if specified

    };
    var Default = {
      validate: false,
      formGroup: {
        required: false
      },
      bmdFormGroup: {
        template: "<span class='" + ClassName.BMD_FORM_GROUP + "'></span>",
        create: true,
        // create a wrapper if form-group not found
        required: true // not recommended to turn this off, only used for inline components

      },
      label: {
        required: false,
        // Prioritized find order for resolving the label to be used as an bmd-label if not specified in the markup
        //  - a function(thisComponent); or
        //  - a string selector used like $bmdFormGroup.find(selector)
        //
        // Note this only runs if $bmdFormGroup.find(Selector.BMD_LABEL_WILDCARD) fails to find a label (as authored in the markup)
        //
        selectors: [".form-control-label", // in the case of horizontal or inline forms, this will be marked
        "> label" // usual case for text inputs, first child.  Deeper would find toggle labels so don't do that.
        ],
        className: ClassName.BMD_LABEL_STATIC
      },
      requiredClasses: [],
      invalidComponentMatches: [],
      convertInputSizeVariations: true
    };
    var FormControlSizeMarkers = {
      "form-control-lg": "bmd-form-group-lg",
      "form-control-sm": "bmd-form-group-sm"
    };
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    var BaseInput = /*#__PURE__*/function (_Base) {
      _inheritsLoose(BaseInput, _Base);

      /**
       *
       * @param element
       * @param config
       * @param properties - anything that needs to be set as this[key] = value.  Works around the need to call `super` before using `this`
       */
      function BaseInput($element, config, properties) {
        var _this;

        if (properties === void 0) {
          properties = {};
        }

        _this = _Base.call(this, $element, $.extend(true, {}, Default, config), properties) || this; // Enforce no overlap between components to prevent side effects

        _this._rejectInvalidComponentMatches(); // Enforce expected structure (if any)


        _this.rejectWithoutRequiredStructure(); // Enforce required classes for a consistent rendering


        _this._rejectWithoutRequiredClasses(); // Resolve the form-group first, it will be used for bmd-form-group if possible
        //   note: different components have different rules


        _this.$formGroup = _this.findFormGroup(_this.config.formGroup.required); // Will add bmd-form-group to form-group or create an bmd-form-group
        //  Performance Note: for those forms that are really performance driven, create the markup with the .bmd-form-group to avoid
        //    rendering changes once added.

        _this.$bmdFormGroup = _this.resolveMdbFormGroup(); // Resolve and mark the bmdLabel if necessary as defined by the config

        _this.$bmdLabel = _this.resolveMdbLabel(); // Signal to the bmd-form-group that a form-control-* variation is being used

        _this.resolveMdbFormGroupSizing();

        _this.addFocusListener();

        _this.addChangeListener();

        if (_this.$element.val() != "") {
          _this.addIsFilled();
        }

        return _this;
      }

      var _proto = BaseInput.prototype;

      _proto.dispose = function dispose(dataKey) {
        _Base.prototype.dispose.call(this, dataKey);

        this.$bmdFormGroup = null;
        this.$formGroup = null;
      } // ------------------------------------------------------------------------
      // protected
      ;

      _proto.rejectWithoutRequiredStructure = function rejectWithoutRequiredStructure() {// implement
      };

      _proto.addFocusListener = function addFocusListener() {
        var _this2 = this;

        this.$element.on("focus", function () {
          _this2.addFormGroupFocus();
        }).on("blur", function () {
          _this2.removeFormGroupFocus();
        });
      };

      _proto.addChangeListener = function addChangeListener() {
        var _this3 = this;

        this.$element.on("keydown paste", function (event) {
          if (Util$1.isChar(event)) {
            _this3.addIsFilled();
          }
        }).on("keyup change", function () {
          // make sure empty is added back when there is a programmatic value change.
          //  NOTE: programmatic changing of value using $.val() must trigger the change event i.e. $.val('x').trigger('change')
          if (_this3.isEmpty()) {
            _this3.removeIsFilled();
          } else {
            _this3.addIsFilled();
          }

          if (_this3.config.validate) {
            // Validation events do not bubble, so they must be attached directly to the text: http://jsfiddle.net/PEpRM/1/
            //  Further, even the bind method is being caught, but since we are already calling #checkValidity here, just alter
            //  the form-group on change.
            //
            // NOTE: I'm not sure we should be intervening regarding validation, this seems better as a README and snippet of code.
            //        BUT, I've left it here for backwards compatibility.
            var isValid = typeof _this3.$element[0].checkValidity === "undefined" || _this3.$element[0].checkValidity();

            if (isValid) {
              _this3.removeHasDanger();
            } else {
              _this3.addHasDanger();
            }
          }
        });
      };

      _proto.addHasDanger = function addHasDanger() {
        this.$bmdFormGroup.addClass(ClassName.HAS_DANGER);
      };

      _proto.removeHasDanger = function removeHasDanger() {
        this.$bmdFormGroup.removeClass(ClassName.HAS_DANGER);
      };

      _proto.isEmpty = function isEmpty() {
        return this.$element.val() === null || this.$element.val() === undefined || this.$element.val() === "";
      } // Will add bmd-form-group to form-group or create a bmd-form-group if necessary
      ;

      _proto.resolveMdbFormGroup = function resolveMdbFormGroup() {
        var mfg = this.findMdbFormGroup(false);

        if (mfg === undefined || mfg.length === 0) {
          if (this.config.bmdFormGroup.create && (this.$formGroup === undefined || this.$formGroup.length === 0)) {
            // If a form-group doesn't exist (not recommended), take a guess and wrap the element (assuming no label).
            //  note: it's possible to make this smarter, but I need to see valid cases before adding any complexity.
            // this may be an input-group, wrap that instead
            if (this.outerElement().parent().hasClass(ClassName.INPUT_GROUP)) {
              this.outerElement().parent().wrap(this.config.bmdFormGroup.template);
            } else {
              this.outerElement().wrap(this.config.bmdFormGroup.template);
            }
          } else {
            // a form-group does exist, add our marker class to it
            this.$formGroup.addClass(ClassName.BMD_FORM_GROUP); // OLD: may want to implement this after all, see how the styling turns out, but using an existing form-group is less manipulation of the dom and therefore preferable
            // A form-group does exist, so add an bmd-form-group wrapping it's internal contents
            //fg.wrapInner(this.config.bmdFormGroup.template)
          }

          mfg = this.findMdbFormGroup(this.config.bmdFormGroup.required);
        }

        return mfg;
      } // Demarcation element (e.g. first child of a form-group)
      //  Subclasses such as file inputs may have different structures
      ;

      _proto.outerElement = function outerElement() {
        return this.$element;
      } // Will add bmd-label to bmd-form-group if not already specified
      ;

      _proto.resolveMdbLabel = function resolveMdbLabel() {
        var label = this.$bmdFormGroup.find(Selector.BMD_LABEL_WILDCARD);

        if (label === undefined || label.length === 0) {
          // we need to find it based on the configured selectors
          label = this.findMdbLabel(this.config.label.required);

          if (label === undefined || label.length === 0) ; else {
            // a candidate label was found, add the configured default class name
            label.addClass(this.config.label.className);
          }
        }

        return label;
      } // Find bmd-label variant based on the config selectors
      ;

      _proto.findMdbLabel = function findMdbLabel(raiseError) {
        if (raiseError === void 0) {
          raiseError = true;
        }

        var label = null; // use the specified selector order

        for (var _iterator = _createForOfIteratorHelperLoose(this.config.label.selectors), _step; !(_step = _iterator()).done;) {
          var selector = _step.value;

          if ($.isFunction(selector)) {
            label = selector(this);
          } else {
            label = this.$bmdFormGroup.find(selector);
          }

          if (label !== undefined && label.length > 0) {
            break;
          }
        }

        if (label.length === 0 && raiseError) {
          $.error("Failed to find " + Selector.BMD_LABEL_WILDCARD + " within form-group for " + Util$1.describe(this.$element));
        }

        return label;
      } // Find bmd-form-group
      ;

      _proto.findFormGroup = function findFormGroup(raiseError) {
        if (raiseError === void 0) {
          raiseError = true;
        }

        var fg = this.$element.closest(Selector.FORM_GROUP);

        if (fg.length === 0 && raiseError) {
          $.error("Failed to find " + Selector.FORM_GROUP + " for " + Util$1.describe(this.$element));
        }

        return fg;
      } // Due to the interconnected nature of labels/inputs/help-blocks, signal the bmd-form-group-* size variation based on
      //  a found form-control-* size
      ;

      _proto.resolveMdbFormGroupSizing = function resolveMdbFormGroupSizing() {
        if (!this.config.convertInputSizeVariations) {
          return;
        } // Modification - Change text-sm/lg to form-group-sm/lg instead (preferred standard and simpler css/less variants)


        for (var inputSize in FormControlSizeMarkers) {
          if (this.$element.hasClass(inputSize)) {
            //this.$element.removeClass(inputSize)
            this.$bmdFormGroup.addClass(FormControlSizeMarkers[inputSize]);
          }
        }
      } // ------------------------------------------------------------------------
      // private
      ;

      _proto._rejectInvalidComponentMatches = function _rejectInvalidComponentMatches() {
        for (var _iterator2 = _createForOfIteratorHelperLoose(this.config.invalidComponentMatches), _step2; !(_step2 = _iterator2()).done;) {
          var otherComponent = _step2.value;
          otherComponent.rejectMatch(this.constructor.name, this.$element);
        }
      };

      _proto._rejectWithoutRequiredClasses = function _rejectWithoutRequiredClasses() {
        for (var _iterator3 = _createForOfIteratorHelperLoose(this.config.requiredClasses), _step3; !(_step3 = _iterator3()).done;) {
          var requiredClass = _step3.value;

          if (requiredClass.indexOf("||") !== -1) {
            var oneOf = requiredClass.split("||");

            for (var _iterator4 = _createForOfIteratorHelperLoose(oneOf), _step4; !(_step4 = _iterator4()).done;) {
              var _requiredClass = _step4.value;

              if (this.$element.hasClass(_requiredClass)) {
                break;
              }
            }
          } else if (this.$element.hasClass(requiredClass)) ;
        }
      } // ------------------------------------------------------------------------
      // static
      ;

      return BaseInput;
    }(Base);

    return BaseInput;
  }(jQuery);

  var BaseFormControl = function ($) {
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */
    var Default = {
      requiredClasses: ["form-control"]
    };
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    var BaseFormControl = /*#__PURE__*/function (_BaseInput) {
      _inheritsLoose(BaseFormControl, _BaseInput);

      function BaseFormControl($element, config) {
        var _this;

        _this = _BaseInput.call(this, $element, $.extend(true, Default, config)) || this; // Initially mark as empty

        if (_this.isEmpty()) {
          _this.removeIsFilled();
        }

        return _this;
      }

      return BaseFormControl;
    }(BaseInput);

    return BaseFormControl;
  }(jQuery);

  var Text = function ($) {
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */
    var NAME = "text";
    var DATA_KEY = "bmd." + NAME;
    var JQUERY_NAME = "bmd" + (NAME.charAt(0).toUpperCase() + NAME.slice(1));
    var JQUERY_NO_CONFLICT = $.fn[JQUERY_NAME];
    var Default = {};
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    var Text = /*#__PURE__*/function (_BaseFormControl) {
      _inheritsLoose(Text, _BaseFormControl);

      function Text($element, config) {
        return _BaseFormControl.call(this, $element, $.extend(true, //{invalidComponentMatches: [Checkbox, File, Radio, Switch, Select, Textarea]},
        Default, config)) || this;
      }

      var _proto = Text.prototype;

      _proto.dispose = function dispose(dataKey) {
        if (dataKey === void 0) {
          dataKey = DATA_KEY;
        }

        _BaseFormControl.prototype.dispose.call(this, dataKey);
      };

      Text.matches = function matches($element) {
        if ($element.attr("type") === "text") {
          return true;
        }

        return false;
      };

      Text.rejectMatch = function rejectMatch(component, $element) {
        Util$1.assert(this.$element, this.matches($element), component + " component element " + Util$1.describe($element) + " is invalid for type='text'.");
      } // ------------------------------------------------------------------------
      // protected
      // ------------------------------------------------------------------------
      // private
      // ------------------------------------------------------------------------
      // static
      ;

      Text._jQueryInterface = function _jQueryInterface(config) {
        return this.each(function () {
          var $element = $(this);
          var data = $element.data(DATA_KEY);

          if (!data) {
            data = new Text($element, config);
            $element.data(DATA_KEY, data);
          }
        });
      };

      return Text;
    }(BaseFormControl);
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     */


    $.fn[JQUERY_NAME] = Text._jQueryInterface;
    $.fn[JQUERY_NAME].Constructor = Text;

    $.fn[JQUERY_NAME].noConflict = function () {
      $.fn[JQUERY_NAME] = JQUERY_NO_CONFLICT;
      return Text._jQueryInterface;
    };

    return Text;
  }(jQuery);

  var Textarea = function ($) {
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */
    var NAME = "textarea";
    var DATA_KEY = "bmd." + NAME;
    var JQUERY_NAME = "bmd" + (NAME.charAt(0).toUpperCase() + NAME.slice(1));
    var JQUERY_NO_CONFLICT = $.fn[JQUERY_NAME];
    var Default = {};
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    var Textarea = /*#__PURE__*/function (_BaseFormControl) {
      _inheritsLoose(Textarea, _BaseFormControl);

      function Textarea($element, config) {
        return _BaseFormControl.call(this, $element, $.extend(true, //{invalidComponentMatches: [Checkbox, File, Radio, Text, Select, Switch]},
        Default, config)) || this;
      }

      var _proto = Textarea.prototype;

      _proto.dispose = function dispose() {
        _BaseFormControl.prototype.dispose.call(this, DATA_KEY);
      };

      Textarea.matches = function matches($element) {
        if ($element.prop("tagName") === "textarea") {
          return true;
        }

        return false;
      };

      Textarea.rejectMatch = function rejectMatch(component, $element) {
        Util$1.assert(this.$element, this.matches($element), component + " component element " + Util$1.describe($element) + " is invalid for <textarea>.");
      } // ------------------------------------------------------------------------
      // protected
      // ------------------------------------------------------------------------
      // private
      // ------------------------------------------------------------------------
      // static
      ;

      Textarea._jQueryInterface = function _jQueryInterface(config) {
        return this.each(function () {
          var $element = $(this);
          var data = $element.data(DATA_KEY);

          if (!data) {
            data = new Textarea($element, config);
            $element.data(DATA_KEY, data);
          }
        });
      };

      return Textarea;
    }(BaseFormControl);
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     */


    $.fn[JQUERY_NAME] = Textarea._jQueryInterface;
    $.fn[JQUERY_NAME].Constructor = Textarea;

    $.fn[JQUERY_NAME].noConflict = function () {
      $.fn[JQUERY_NAME] = JQUERY_NO_CONFLICT;
      return Textarea._jQueryInterface;
    };

    return Textarea;
  }(jQuery);

  var Ripples = function ($) {
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */
    var NAME = "ripples";
    var DATA_KEY = "bmd." + NAME;
    var JQUERY_NAME = "bmd" + (NAME.charAt(0).toUpperCase() + NAME.slice(1));
    var JQUERY_NO_CONFLICT = $.fn[JQUERY_NAME];
    var ClassName = {
      CONTAINER: "ripple-container",
      DECORATOR: "ripple-decorator"
    };
    var Selector = {
      CONTAINER: "." + ClassName.CONTAINER,
      DECORATOR: "." + ClassName.DECORATOR //,

    };
    var Default = {
      container: {
        template: "<div class='" + ClassName.CONTAINER + "'></div>"
      },
      decorator: {
        template: "<div class='" + ClassName.DECORATOR + "'></div>"
      },
      trigger: {
        start: "mousedown touchstart",
        end: "mouseup mouseleave touchend"
      },
      touchUserAgentRegex: /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i,
      duration: 500
    };
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    var Ripples = /*#__PURE__*/function () {
      function Ripples($element, config) {
        var _this = this;

        this.$element = $element; // console.log(`Adding ripples to ${Util.describe(this.$element)}`)  // eslint-disable-line no-console

        this.config = $.extend(true, {}, Default, config); // attach initial listener

        this.$element.on(this.config.trigger.start, function (event) {
          _this._onStartRipple(event);
        });
      }

      var _proto = Ripples.prototype;

      _proto.dispose = function dispose() {
        this.$element.data(DATA_KEY, null);
        this.$element = null;
        this.$container = null;
        this.$decorator = null;
        this.config = null;
      } // ------------------------------------------------------------------------
      // private
      ;

      _proto._onStartRipple = function _onStartRipple(event) {
        var _this2 = this;

        // Verify if the user is just touching on a device and return if so
        if (this._isTouch() && event.type === "mousedown") {
          return;
        } // Find or create the ripple container element


        this._findOrCreateContainer(); // Get relY and relX positions of the container element


        var relY = this._getRelY(event);

        var relX = this._getRelX(event); // If relY and/or relX are false, return the event


        if (!relY && !relX) {
          return;
        } // set the location and color each time (even if element is cached)


        this.$decorator.css({
          left: relX,
          top: relY,
          "background-color": this._getRipplesColor()
        }); // Make sure the ripple has the styles applied (ugly hack but it works)

        this._forceStyleApplication(); // Turn on the ripple animation


        this.rippleOn(); // Call the rippleEnd function when the transition 'on' ends

        setTimeout(function () {
          _this2.rippleEnd();
        }, this.config.duration); // Detect when the user leaves the element to cleanup if not already done?

        this.$element.on(this.config.trigger.end, function () {
          if (_this2.$decorator) {
            // guard against race condition/mouse attack
            _this2.$decorator.data("mousedown", "off");

            if (_this2.$decorator.data("animating") === "off") {
              _this2.rippleOut();
            }
          }
        });
      };

      _proto._findOrCreateContainer = function _findOrCreateContainer() {
        if (!this.$container || !this.$container.length > 0) {
          this.$element.append(this.config.container.template);
          this.$container = this.$element.find(Selector.CONTAINER);
        } // always add the rippleElement, it is always removed


        this.$container.append(this.config.decorator.template);
        this.$decorator = this.$container.find(Selector.DECORATOR);
      } // Make sure the ripple has the styles applied (ugly hack but it works)
      ;

      _proto._forceStyleApplication = function _forceStyleApplication() {
        return window.getComputedStyle(this.$decorator[0]).opacity;
      }
      /**
       * Get the relX
       */
      ;

      _proto._getRelX = function _getRelX(event) {
        var wrapperOffset = this.$container.offset();
        var result = null;

        if (!this._isTouch()) {
          // Get the mouse position relative to the ripple wrapper
          result = event.pageX - wrapperOffset.left;
        } else {
          // Make sure the user is using only one finger and then get the touch
          //  position relative to the ripple wrapper
          event = event.originalEvent;

          if (event.touches.length === 1) {
            result = event.touches[0].pageX - wrapperOffset.left;
          } else {
            result = false;
          }
        }

        return result;
      }
      /**
       * Get the relY
       */
      ;

      _proto._getRelY = function _getRelY(event) {
        var containerOffset = this.$container.offset();
        var result = null;

        if (!this._isTouch()) {
          /**
           * Get the mouse position relative to the ripple wrapper
           */
          result = event.pageY - containerOffset.top;
        } else {
          /**
           * Make sure the user is using only one finger and then get the touch
           * position relative to the ripple wrapper
           */
          event = event.originalEvent;

          if (event.touches.length === 1) {
            result = event.touches[0].pageY - containerOffset.top;
          } else {
            result = false;
          }
        }

        return result;
      }
      /**
       * Get the ripple color
       */
      ;

      _proto._getRipplesColor = function _getRipplesColor() {
        var color = this.$element.data("ripple-color") ? this.$element.data("ripple-color") : window.getComputedStyle(this.$element[0]).color;
        return color;
      }
      /**
       * Verify if the client is using a mobile device
       */
      ;

      _proto._isTouch = function _isTouch() {
        return this.config.touchUserAgentRegex.test(navigator.userAgent);
      }
      /**
       * End the animation of the ripple
       */
      ;

      _proto.rippleEnd = function rippleEnd() {
        if (this.$decorator) {
          // guard against race condition/mouse attack
          this.$decorator.data("animating", "off");

          if (this.$decorator.data("mousedown") === "off") {
            this.rippleOut(this.$decorator);
          }
        }
      }
      /**
       * Turn off the ripple effect
       */
      ;

      _proto.rippleOut = function rippleOut() {
        var _this3 = this;

        this.$decorator.off();

        if (Util$1.transitionEndSupported()) {
          this.$decorator.addClass("ripple-out");
        } else {
          this.$decorator.animate({
            opacity: 0
          }, 100, function () {
            _this3.$decorator.trigger("transitionend");
          });
        }

        this.$decorator.on(Util$1.transitionEndSelector(), function () {
          if (_this3.$decorator) {
            _this3.$decorator.remove();

            _this3.$decorator = null;
          }
        });
      }
      /**
       * Turn on the ripple effect
       */
      ;

      _proto.rippleOn = function rippleOn() {
        var _this4 = this;

        var size = this._getNewSize();

        if (Util$1.transitionEndSupported()) {
          this.$decorator.css({
            "-ms-transform": "scale(" + size + ")",
            "-moz-transform": "scale(" + size + ")",
            "-webkit-transform": "scale(" + size + ")",
            transform: "scale(" + size + ")"
          }).addClass("ripple-on").data("animating", "on").data("mousedown", "on");
        } else {
          this.$decorator.animate({
            width: Math.max(this.$element.outerWidth(), this.$element.outerHeight()) * 2,
            height: Math.max(this.$element.outerWidth(), this.$element.outerHeight()) * 2,
            "margin-left": Math.max(this.$element.outerWidth(), this.$element.outerHeight()) * -1,
            "margin-top": Math.max(this.$element.outerWidth(), this.$element.outerHeight()) * -1,
            opacity: 0.2
          }, this.config.duration, function () {
            _this4.$decorator.trigger("transitionend");
          });
        }
      }
      /**
       * Get the new size based on the element height/width and the ripple width
       */
      ;

      _proto._getNewSize = function _getNewSize() {
        return Math.max(this.$element.outerWidth(), this.$element.outerHeight()) / this.$decorator.outerWidth() * 2.5;
      } // ------------------------------------------------------------------------
      // static
      ;

      Ripples._jQueryInterface = function _jQueryInterface(config) {
        return this.each(function () {
          var $element = $(this);
          var data = $element.data(DATA_KEY);

          if (!data) {
            data = new Ripples($element, config);
            $element.data(DATA_KEY, data);
          }
        });
      };

      return Ripples;
    }();
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     */


    $.fn[JQUERY_NAME] = Ripples._jQueryInterface;
    $.fn[JQUERY_NAME].Constructor = Ripples;

    $.fn[JQUERY_NAME].noConflict = function () {
      $.fn[JQUERY_NAME] = JQUERY_NO_CONFLICT;
      return Ripples._jQueryInterface;
    };

    return Ripples;
  }(jQuery);

  /**
   * $.bootstrapMaterialDesign(config) is a macro class to configure the classes generally
   *  used in Material Design for Bootstrap.  You may pass overrides to the configurations
   *  which will be passed into each component, or you may omit use of this class and
   *  configure each component separately.
   */

  var BootstrapMaterialDesign = function ($) {
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */
    var NAME = "bootstrapMaterialDesign";
    var DATA_KEY = "bmd." + NAME;
    var JQUERY_NAME = NAME; // retain this full name since it is long enough not to conflict

    var JQUERY_NO_CONFLICT = $.fn[JQUERY_NAME];
    /**
     * Global configuration:
     *  The global configuration hash will be mixed in to each classes' config.
     *    e.g. calling $.bootstrapMaterialDesign({global: { validate: true } }) would pass `validate:true` to every component
     *
     *
     * Component configuration:
     *  - selector: may be a string or an array.  Any array will be joined with a comma to generate the selector
     *  - disable any component by defining it as false with an override. e.g. $.bootstrapMaterialDesign({ autofill: false })
     *
     *  @see each individual component for more configuration settings.
     */

    var Default = {
      global: {
        validate: false,
        label: {
          className: "bmd-label-static" // default style of label to be used if not specified in the html markup

        }
      },
      autofill: {
        selector: "body"
      },
      checkbox: {
        selector: ".checkbox > label > input[type=checkbox]"
      },
      checkboxInline: {
        selector: "label.checkbox-inline > input[type=checkbox]"
      },
      collapseInline: {
        selector: '.bmd-collapse-inline [data-toggle="collapse"]'
      },
      drawer: {
        selector: ".bmd-layout-drawer"
      },
      file: {
        selector: "input[type=file]"
      },
      radio: {
        selector: ".radio > label > input[type=radio]"
      },
      radioInline: {
        selector: "label.radio-inline > input[type=radio]"
      },
      ripples: {
        //selector: ['.btn:not(.btn-link):not(.ripple-none)'] // testing only
        selector: [".btn:not(.btn-link):not(.ripple-none)", ".card-image:not(.ripple-none)", ".navbar a:not(.ripple-none)", ".dropdown-menu a:not(.ripple-none)", ".nav-tabs a:not(.ripple-none)", ".pagination li:not(.active):not(.disabled) a:not(.ripple-none)", ".ripple" // generic marker class to add ripple to elements
        ]
      },
      select: {
        selector: ["select"]
      },
      switch: {
        selector: ".switch > label > input[type=checkbox]"
      },
      text: {
        // omit inputs we have specialized classes to handle - we need to match text, email, etc.  The easiest way to do this appears to be just omit the ones we don't want to match and let the rest fall through to this.
        selector: ["input:not([type=hidden]):not([type=checkbox]):not([type=radio]):not([type=file]):not([type=button]):not([type=submit]):not([type=reset])"]
      },
      textarea: {
        selector: ["textarea"]
      },
      arrive: true,
      // create an ordered component list for instantiation
      instantiation: ["ripples", // "checkbox",
      // "checkboxInline",
      // "collapseInline",
      // "drawer",
      //'file',
      // "radio",
      // "radioInline",
      // "switch",
      "text", "textarea" // "select",
      // "autofill"
      ]
    };
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    var BootstrapMaterialDesign = /*#__PURE__*/function () {
      function BootstrapMaterialDesign($element, config) {
        var _this = this;

        this.$element = $element;
        this.config = $.extend(true, {}, Default, config);
        var $document = $(document);

        var _loop = function _loop() {
          var component = _step.value;
          // the component's config fragment is passed in directly, allowing users to override
          var componentConfig = _this.config[component]; // check to make sure component config is enabled (not `false`)

          if (componentConfig) {
            // assemble the selector as it may be an array
            var selector = _this._resolveSelector(componentConfig); // mix in global options


            componentConfig = $.extend(true, {}, _this.config.global, componentConfig); // create the jquery fn name e.g. 'bmdText' for 'text'

            var componentName = "" + (component.charAt(0).toUpperCase() + component.slice(1));
            var jqueryFn = "bmd" + componentName;

            try {
              // safely instantiate component on selector elements with config, report errors and move on.
              // console.debug(`instantiating: $('${selector}')[${jqueryFn}](${componentConfig})`) // eslint-disable-line no-console
              $(selector)[jqueryFn](componentConfig); // add to arrive if present and enabled

              if (document.arrive && _this.config.arrive) {
                $document.arrive(selector, function () {
                  // eslint-disable-line no-loop-func
                  $(this)[jqueryFn](componentConfig);
                });
              }
            } catch (e) {
              var message = "Failed to instantiate component: $('" + selector + "')[" + jqueryFn + "](" + componentConfig + ")";
              console.error(message, e, "\nSelected elements: ", $(selector)); // eslint-disable-line no-console

              throw e;
            }
          }
        };

        for (var _iterator = _createForOfIteratorHelperLoose(this.config.instantiation), _step; !(_step = _iterator()).done;) {
          _loop();
        }
      }

      var _proto = BootstrapMaterialDesign.prototype;

      _proto.dispose = function dispose() {
        this.$element.data(DATA_KEY, null);
        this.$element = null;
        this.config = null;
      } // ------------------------------------------------------------------------
      // private
      ;

      _proto._resolveSelector = function _resolveSelector(componentConfig) {
        var selector = componentConfig.selector;

        if (Array.isArray(selector)) {
          selector = selector.join(", ");
        }

        return selector;
      } // ------------------------------------------------------------------------
      // static
      ;

      BootstrapMaterialDesign._jQueryInterface = function _jQueryInterface(config) {
        return this.each(function () {
          var $element = $(this);
          var data = $element.data(DATA_KEY);

          if (!data) {
            data = new BootstrapMaterialDesign($element, config);
            $element.data(DATA_KEY, data);
          }
        });
      };

      return BootstrapMaterialDesign;
    }();
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     */


    $.fn[JQUERY_NAME] = BootstrapMaterialDesign._jQueryInterface;
    $.fn[JQUERY_NAME].Constructor = BootstrapMaterialDesign;

    $.fn[JQUERY_NAME].noConflict = function () {
      $.fn[JQUERY_NAME] = JQUERY_NO_CONFLICT;
      return BootstrapMaterialDesign._jQueryInterface;
    };

    return BootstrapMaterialDesign;
  }($);

  var Menu = function () {
    var NAME = "menu";
    var DATA_KEY = "mateo." + NAME;
    var JQUERY_NAME = "" + NAME;
    var JQUERY_NO_CONFLICT = $.fn[JQUERY_NAME];
    var Default = {
      button: '',
      btn: '.menu-trigger',
      submenu: '.sub-menu',
      container: 'li.menu-item-has-children',
      minWidth: 'auto',
      maxWidth: 'auto',
      adjustMinWidth: false,
      adjustMaxWidth: false,
      css: {
        show: 'menu-show',
        hide: 'menu-hide',
        topTrigger: {
          selector: '',
          toggleClass: ''
        }
      },
      animation: {
        show: 'menuAnimIn',
        hide: 'menuAnimOut'
      },
      labels: {
        show: "Show menu",
        hide: "Hide menu",
        showParent: "Show parent menu"
      },
      selector: {
        // Selector for the item of the list which is not hidden for the display.
        focusOnOpenItem: ' > li:not(.d-lg-none) > a'
      }
    };

    var Menu = /*#__PURE__*/function () {
      function Menu($element, config) {
        this.$element = $element;
        this.config = $.extend(true, {}, Default, config);
        /*
         * currently opened menu
         */

        this.opened = null;
        /*
         * Menu to hide
         * used internally for animated hiding
         */

        this.toHide = null;
        /*
         * Menu to open
         * used internally for animated hiding
         */

        this.toOpen = null;
        /*
         * Reference to top level button
         * Used as identifier for all children menus
         */

        this.scope = {
          current: null,
          trigger: null,
          minWidth: '',
          maxWidth: ''
        };
        /*
         * Generate a unique namespace per Menu instance to avoid events collision between multiple menus
         */

        this.namespace = 'menu' + $.guid++; // scopechange,
        //   menuopened
        //   menuclosed

        this.eventsQueue = {};
        this.event = null;
        this.init();
      }

      var _proto = Menu.prototype;

      _proto.init = function init() {
        var _this = this;

        if (this.config.button !== "") {
          var trigger = $(this.config.button);
          var subMenu = this.$element;

          if (subMenu.length && trigger.length) {
            trigger.on('click', {
              instance: this
            }, Menu.toggleTopTrigger);
            this.initTriggerSubmenu(trigger, subMenu);
          }
        } else {
          var topLevel = this.$element.children(this.config.container);

          if (topLevel.length) {
            topLevel.toArray().forEach(function (item) {
              _this.initSubTree($(item), null);
            });
          }
        }

        this.on('scopeChange', this.handleScopeChange);
        this.on('scopeChange', function (previous, current) {
          if (current.trigger) {
            _this.setAria(current.trigger, _this.config.labels.hide, true);
          }

          if (previous.trigger) {
            _this.setAria(previous.trigger, _this.config.labels.show, false);
          }
        });
        this.on('menuOpen', function (menu) {
          var hasParent = _this.getParentMenu(menu);

          _this.setAria(_this.scope.trigger, hasParent ? _this.config.labels.showParent : _this.config.labels.hide, true);
        });
      }
      /**
       * Toggle arrow (up|down) display on scope change
       * @param {object} previous
       * @param {object} current
       */
      ;

      _proto.handleScopeChange = function handleScopeChange(previous, current) {
        if (current.current) {
          this.animateTopTrigger(current);
        }

        if (previous.current) {
          this.animateTopTrigger(previous);
        }
      };

      _proto.animateTopTrigger = function animateTopTrigger(scope) {
        if (!this.config.css.topTrigger.toggleClass) {
          return;
        }

        scope.trigger.find(this.config.css.topTrigger.selector).toggleClass(this.config.css.topTrigger.toggleClass);
      };

      _proto.initSubTree = function initSubTree(container, parentMenu) {
        var trigger = container.children(this.config.btn);
        var subMenu = container.children(this.config.submenu);

        if (subMenu.length && trigger.length) {
          if (parentMenu) {
            subMenu = this.setParentMenu(subMenu, parentMenu);
            trigger.on('click', {
              instance: this
            }, Menu.toggleMenuEventHandler);
          } else {
            trigger.on('click', {
              instance: this
            }, Menu.toggleTopTrigger);
          }

          this.initTriggerSubmenu(trigger, subMenu);
        }
      };

      _proto.initTriggerSubmenu = function initTriggerSubmenu(button, subMenu) {
        var _this2 = this;

        button.data('menu', subMenu);

        if (this.animateHide()) {
          subMenu.on('animationend', {
            instance: this
          }, Menu.animationEnd);
        }

        var containers = subMenu.children(this.config.container);

        if (containers.length) {
          containers.each(function (idx, container) {
            _this2.initSubTree($(container), subMenu);
          });
        }
      }
      /**
       * Menu instance is passed thru event's data
       * @param instance  Menu instance
       * @param menu  submenu to show or hide
       */
      ;

      Menu.toggleMenu = function toggleMenu(instance, menu) {
        if (instance.isShown(menu)) {
          instance.hide(menu);
          instance.detachOuterClickHandler();
          instance.setScope(null, null, null, null);
        } else if (instance.animateHide() && instance.opened !== null) {
          instance.showMenuStart(menu, instance.opened);
        } else {
          instance.show(menu);
          instance.attachOuterClickHandler();
        }
      };

      Menu.closeEventHandler = function closeEventHandler(event) {
        var instance = event.data.instance;

        if (instance.opened) {
          var target = $(event.target);

          if (instance.config.button) {
            if (target.closest(instance.config.button).length) {
              return;
            }

            if (target.closest(instance.$element).length) {
              return;
            }

            Menu.toggleMenu(instance, instance.opened);
          } else if (!target.closest(instance.config.container).length) {
            Menu.toggleMenu(instance, instance.opened);
          }
        }
      };

      /**
       * This method handles opening of submenus only
       * @param event
       */
      Menu.toggleMenuEventHandler = function toggleMenuEventHandler(event) {
        // prevent updating browser url with #
        event.preventDefault();

        if (event.data.instance) {
          Menu.toggleMenu(event.data.instance, $(this).data('menu'));
        }
      }
      /**
       * Check if events comes from the current scope.
       * If yes choose the menu to apply action to (show parent menu, close current, etc...).
       * If not switch the scope.
       * @param event jQuery Event object
       */
      ;

      Menu.toggleTopTrigger = function toggleTopTrigger(event) {
        // prevent updating browser url with #
        event.preventDefault();
        var instance = event.data.instance;
        var mToToggle = $(this).data('menu');

        if ($(this).is(instance.scope.current)) {
          // if some child menu is shown: go up one level and display parent menu
          var parentMenu;

          if (instance.opened && (parentMenu = instance.getParentMenu(instance.opened))) {
            mToToggle = parentMenu;
          }
        } else {
          // another top level button is clicked: switch the scope
          // If some menu from previous scope is opened it'll be closed
          // by "hide" action
          instance.setScope($(this), $(this), instance.getMenuMinWidth(mToToggle), instance.getMenuMaxWidth(mToToggle));
        }

        Menu.toggleMenu(instance, mToToggle);
      };

      _proto.toggle = function toggle(menu, event) {
        if (this.isShown(menu)) {
          this.setScope(null, null, null, null);
          this.hide(menu);
          this.detachOuterClickHandler();
        } else if (this.animateHide() && this.opened !== null) {
          this.showMenuStart(menu, this.opened);
        } else {
          this.show(menu);
          this.attachOuterClickHandler();
        }
      };

      Menu.animationEnd = function animationEnd(event) {
        var instance = event.data.instance;

        if (event.originalEvent.animationName === instance.config.animation.hide) {
          instance.showMenuEnd();
        }
      }
      /**
       * Menu is considered as shown if it has '.show' class
       *
       * @param jqElem jQuery element
       * @returns {boolean}
       */
      ;

      _proto.isShown = function isShown(jqElem) {
        return jqElem.hasClass(this.config.css.show);
      }
      /**
       * Get desired min width for displayed sub menu.
       * Min width for the sub menu is a width of the top menu
       *
       * @param menu
       * @returns {number}
       */
      ;

      _proto.getMenuMinWidth = function getMenuMinWidth(menu) {
        if (!this.config.adjustMinWidth) {
          return 0;
        }

        if (this.config.minWidth !== 'auto') {
          return this.config.minWidth;
        }

        return Math.floor(menu.closest(this.config.container).width());
      }
      /**
       * Get desired max width for displayed sub menu.
       *
       * @param menu
       * @returns {number}
       */
      ;

      _proto.getMenuMaxWidth = function getMenuMaxWidth(menu) {
        if (!this.config.adjustMaxWidth) {
          return 0;
        }

        if (this.config.maxWidth !== 'auto') {
          return this.config.maxWidth;
        } // menu parent container


        var c = menu.closest(this.config.container)[0].getBoundingClientRect(); // main menu container

        var m = this.$element[0].getBoundingClientRect();
        var maxWith = Math.floor(m.right - c.left);
        return maxWith === Math.floor(c.width) ? 0 : maxWith;
      };

      _proto.setParentMenu = function setParentMenu(menu, parent) {
        menu.data('menuParent', parent);
        return menu;
      };

      _proto.getParentMenu = function getParentMenu(menu) {
        return menu.data('menuParent');
      };

      _proto.attachOuterClickHandler = function attachOuterClickHandler() {
        var events = "click." + this.namespace + " focusin." + this.namespace;
        $('body').on(events, {
          instance: this
        }, Menu.closeEventHandler);
      };

      _proto.detachOuterClickHandler = function detachOuterClickHandler() {
        var events = "click." + this.namespace + " focusin." + this.namespace;
        $('body').off(events, Menu.closeEventHandler);
      }
      /**
       *
       * @param mShow menu to display
       * @param mHide menu to hide
       */
      ;

      _proto.showMenuStart = function showMenuStart(mShow, mHide) {
        this.toHide = mHide; // the parent menu

        this.toOpen = mShow;
        this.hide(this.toHide);
      };

      _proto.showMenuEnd = function showMenuEnd() {
        if (this.toHide) {
          this.toHide.removeClass(this.config.css.hide);
          this.toHide = null;
        }

        if (this.toOpen) {
          this.show(this.toOpen);
          this.toOpen = null;
        }
      }
      /**
       * Aria requirement: place the focus on a first link of the opened menu.
       * @param menu Currently opened menu
       */
      ;

      _proto.focusOnOpen = function focusOnOpen(menu) {
        if (this.config.selector.focusOnOpenItem) {
          menu.find(this.config.selector.focusOnOpenItem).first().focus();
          return;
        } // default behaviour


        menu.find('a').first().focus();
      }
      /**
       *
       * @param menu
       */
      ;

      _proto.show = function show(menu) {
        if (this.scope.minWidth) {
          menu.css('min-width', this.scope.minWidth);
        }

        if (this.scope.maxWidth) {
          menu.css('max-width', this.scope.maxWidth);
        }

        menu.removeClass(this.config.css.hide).addClass(this.config.css.show); // aria requirement: place the focus on a first link

        this.focusOnOpen(menu);
        this.opened = menu;
        this.trigger('menuOpen', [menu]);
      }
      /**
       *
       * @param menu
       */
      ;

      _proto.hide = function hide(menu) {
        if (this.animateHide()) {
          this.toHide = this.opened;
          menu.removeClass(this.config.css.show).addClass(this.config.css.hide);
        } else {
          menu.removeClass(this.config.css.show);
        }

        this.opened = null;
        this.trigger('menuClose', [menu]);
      };

      _proto.animateHide = function animateHide() {
        return this.config.animation.hide !== '';
      };

      _proto.setScope = function setScope(id, trigger, minWidth, maxWidth) {
        var previous = $.extend({}, this.scope);
        this.scope.current = id;
        this.scope.trigger = trigger;
        this.scope.minWidth = minWidth ? minWidth + 'px' : '';
        this.scope.maxWidth = maxWidth ? maxWidth + 'px' : '';
        this.trigger('scopeChange', [previous, this.scope]);
      }
      /**
       * Set aria attributes
       * @param elem
       * @param {string} label  Aria label
       * @param {boolean} expanded  Aria expaned value
       */
      ;

      _proto.setAria = function setAria(elem, label, expanded) {
        if (expanded !== null) {
          $(elem).attr('aria-expanded', expanded);
        }

        if (label !== null) {
          $(elem).attr('aria-label', label);
        }
      }
      /**
       * Attach event handler
       * @param {string} name Event's name
       * @param {function} handler Handler function
       */
      ;

      _proto.on = function on(name, handler) {
        if (typeof handler !== 'function') {
          return;
        }

        name = name.toLowerCase();

        if (!this.eventsQueue.hasOwnProperty(name)) {
          this.eventsQueue[name] = [];
        }

        this.eventsQueue[name].push(handler);
      }
      /**
       * Executes event handlers
       * @param {string} name Event name
       * @param {array} $params Handler arguments
       */
      ;

      _proto.trigger = function trigger(name, $params) {
        var _this3 = this;

        name = name.toLowerCase();

        if (this.eventsQueue.hasOwnProperty(name) && this.eventsQueue[name].length > 0) {
          this.eventsQueue[name].forEach(function (fn) {
            return fn.apply(_this3, $params);
          });
        }
      }
      /**
       *
       * @param config
       * @returns {*}
       */
      ;

      Menu.jQueryInterface = function jQueryInterface(config) {
        return this.each(function () {
          var $element = $(this);
          var data = $element.data(DATA_KEY);

          if (!data) {
            data = new Menu($element, config);
            $element.data(DATA_KEY, data);
          }
        });
      };

      return Menu;
    }();

    $.fn[JQUERY_NAME] = Menu.jQueryInterface;
    $.fn[JQUERY_NAME].Constructor = Menu;

    $.fn[JQUERY_NAME].noConflict = function () {
      $.fn[JQUERY_NAME] = JQUERY_NO_CONFLICT;
      return Menu.jQueryInterface;
    };

    return Menu;
  }();

  //import $ from 'jquery';
  var Widget_Gallery_Carousel = function ($) {
    // Rearrange elements to fit bootstrap carousel structure.
    var NAME = 'widget_gallery_carousel';
    var DATA_KEY = 'mateo.gallery-carousel';
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Default = {
      // Css classes for carousel effects.
      effects: 'slide carousel-fade',
      // Buttons labels.
      previous: 'Previous',
      next: 'Next'
    };

    var Widget_Gallery_Carousel = /*#__PURE__*/function () {
      function Widget_Gallery_Carousel(element, config) {
        this.config = $.extend(true, {}, Default, config || {});
        this.transform(element);
      }
      /**
       * Transforms wordpress media widget into bootstrap carousel component.
       * @param container
       */


      var _proto = Widget_Gallery_Carousel.prototype;

      _proto.transform = function transform(container) {
        var gallery = container.find(".gallery"); // not a gallery

        if (gallery.length === 0) {
          return;
        }

        gallery.detach();
        var base = $('<div class="carousel-base"></div>').appendTo(container);
        var icons = gallery.find(".gallery-icon"); // Append next/previous button only if there are many images.

        if (icons.length > 1) {
          icons.append("<a class=\"carousel-control-prev\" href=\"#" + container.prop('id') + "\" role=\"button\" data-slide=\"prev\">\n        <span class=\"carousel-control-prev-icon\" aria-hidden=\"true\"></span>\n        <span class=\"screen-reader-text\">" + this.config.previous + "</span>\n        </a>\n        <a class=\"carousel-control-next\" href=\"#" + container.prop('id') + "\" role=\"button\" data-slide=\"next\">\n        <span class=\"carousel-control-next-icon\" aria-hidden=\"true\"></span>\n        <span class=\"screen-reader-text\">" + this.config.next + "</span>\n        </a>");
        }

        gallery.addClass("carousel-inner").find(".gallery-item").addClass("carousel-item").first().addClass("active");
        base.append(gallery);
        container.addClass("carousel " + this.config.effects);
      }
      /**
       * @returns {*}
       */
      ;

      Widget_Gallery_Carousel.jQueryInterface = function jQueryInterface() {
        return this.each(function () {
          var $element = $(this);
          var data = $element.data(DATA_KEY);

          if (!data) {
            data = new Widget_Gallery_Carousel($element);
            $element.data(DATA_KEY, data);
          }
        });
      };

      return Widget_Gallery_Carousel;
    }();
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     */


    $.fn[NAME] = Widget_Gallery_Carousel.jQueryInterface;
    $.fn[NAME].Constructor = Widget_Gallery_Carousel;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return Widget_Gallery_Carousel.jQueryInterface;
    };

    return Widget_Gallery_Carousel;
  }(jQuery);

  /**
   * Manages display of menu items in main menu (horizontal) and small menu (vertical)
   * @type {Menu_Hortical_Manager}
   */

  var Menu_Hortical_Manager = function () {
    var mainMenu = $(".main-menu");
    var mainContainer = $(".main-menu-container");
    var smallMenu = $(".s-main-menu");
    var toggler = $(".navbar-toggler");
    var mainChildren = mainMenu.children();
    var smallChildren = smallMenu.children();
    var threshold = null;
    var thresholdNext = null; // Flag saying if submenu has hidden items

    var hasHiddenItems = false;

    var showButton = function showButton() {
      toggler.show();
    };

    var hideButton = function hideButton() {
      toggler.css('display', '');
    };

    var canShrink = function canShrink(availableWidth) {
      if (!threshold) {
        return true;
      } // The width of displays items is bigger then available width.


      return threshold && threshold > availableWidth;
    };

    var canGrow = function canGrow(availableWidth) {
      if (!thresholdNext) {
        return false;
      }

      return thresholdNext < availableWidth;
    };
    /**
     * Show/hide menu items in main and small menus.
     * @param availableWidth
     */


    var process = function process(availableWidth) {
      var total = 0;
      threshold = null;
      thresholdNext = null; // Hide overflown menu items in primary menu.

      $.each(mainChildren, function (i, el) {
        var elem = $(el);
        var ew = elem.width();
        total += ew;

        if (total > availableWidth) {
          if (thresholdNext === null) {
            thresholdNext = total;
          } // Hide in primary menu.


          elem.hide(); // Display in small menu.

          $(smallChildren[i]).removeClass("d-lg-none");
        } else {
          threshold = total; // Display in primary menu

          elem.css("display", "inline-block"); // Hide in small menu

          $(smallChildren[i]).addClass("d-lg-none");
        }
      });
      hasHiddenItems = smallMenu.find(".d-lg-none").length !== 0;
    };
    /**
     * Resets the visibility of menus' items (main and small).
     */


    var resetVisibility = function resetVisibility() {
      $.each(mainChildren, function (i, el) {
        // Display in primary menu
        $(el).css("display", "inline-block");
        $(smallChildren[i]).removeClass("d-lg-none");
      });
      hasHiddenItems = false;
      threshold = null;
      thresholdNext = null;
    };
    /**
     * Shrinks main menu, shows items in small menu and displays the button.
     * @param availableWidth
     */


    var shrink = function shrink(availableWidth) {
      process(availableWidth); // Show button if there are items to display in small menu.

      if (thresholdNext) {
        showButton();
      }
    };
    /**
     * Show items in main menu and hides the button if all items of main menu are displayed.
     * @param availableWidth
     */


    var grow = function grow(availableWidth) {
      process(availableWidth); // Hide button if there are no more items to display

      if (!thresholdNext) {
        hideButton();
      }
    };
    /**
     * Checks if there is something to manage.
      * @returns {boolean}
     */


    var canManage = function canManage() {
      if (mainContainer.length !== 0 && mainMenu.length !== 0 && mainMenu[0].scrollWidth !== 0) {
        return true;
      } // menu does not exist or it's hidden on small screen (xs small size)


      if (hasHiddenItems) {
        resetVisibility();
      }

      return false;
    };

    var Menu_Hortical_Manager = /*#__PURE__*/function () {
      function Menu_Hortical_Manager() {}

      Menu_Hortical_Manager.manage = function manage() {
        if (!canManage()) {
          return;
        }

        var availableWidth = mainContainer.width(); // For IE11 we can get the menu width only with ".scrollWidth" property.

        var menuWidth = mainMenu[0].scrollWidth;

        if (menuWidth > availableWidth && canShrink(availableWidth)) {
          shrink(availableWidth);
        } else if (menuWidth < availableWidth && canGrow(availableWidth)) {
          grow(availableWidth);
        }
      };

      return Menu_Hortical_Manager;
    }();

    return Menu_Hortical_Manager;
  }();

  //import $ from 'jquery';
  var headerSearch = (function ($) {
    return function () {
      var topSearchBtn = $(".top-search-btn");

      if (topSearchBtn.length > 0) {
        var searchForm = $(".top-search-form");
        var searchInput = searchForm.find("input[type=search]");
        var cancelSearchBtn = searchForm.find(".search-cancel"); // Trigger search form display

        topSearchBtn.on("click", function () {
          searchForm.addClass("show");
          searchInput.focus();
        }); // Close search form

        cancelSearchBtn.on('click', function () {
          searchForm.removeClass("show");
          topSearchBtn.focus();
        });
      }
    };
  })(jQuery);

  ((function ($) {
    $(document).ready(function () {
      $('.preload').addClass('loaded');
      Menu_Hortical_Manager.manage();
      $(".main-menu-container").removeClass("hide-overflow");
      $('body').bootstrapMaterialDesign({
        collapseInline: false,
        drawer: false,
        file: false,
        select: false,
        ripples: {
          selector: [".comment-action a:not(.ripple-none)", "input[type='submit']:not(.ripple-none)", "input[type='search']:not(.ripple-none)", "input[type='button']:not(.ripple-none)", "button:not(.ripple-none)", ".btn:not(.btn-link):not(.ripple-none)", ".card-image:not(.ripple-none)", ".navbar-components a:not(.ripple-none)", ".dropdown-menu a:not(.ripple-none)", ".nav-tabs a:not(.ripple-none)", ".pagination li:not(.active):not(.disabled) a:not(.ripple-none)", ".s-main-menu li a:not(.ripple-none)", ".wp-block-button__link", ".wp-block-file__button", ".ripple" // generic marker class to add ripple to elements
          ]
        }
      });

      if (!window.Mateo) {
        window.Mateo = {
          // menu aria labels
          labels: {
            show: "Show menu",
            hide: "Hide menu",
            showParent: "Show parent menu",
            previous: "Previous",
            next: "Next"
          }
        };
      }

      $('#primary-menu').menu({
        adjustMinWidth: true,
        css: {
          topTrigger: {
            selector: 'i',
            toggleClass: 'menu-arrow-down menu-arrow-up'
          }
        },
        labels: Mateo.labels
      });
      $('#s-primary-menu').menu({
        button: '.navbar-toggler',
        css: {
          topTrigger: {
            selector: 'i',
            toggleClass: 'menu-burger menu-arrow-up'
          }
        },
        labels: Mateo.labels
      }); // Render radio/checkbox inputs

      $(".content-area [type=radio], .content-area [type=checkbox]").each(function (i, elem) {
        var e = $(elem);
        var id = e.prop('id');

        if (!id) {
          // check if enclosed in label
          var label = e.closest('label');

          if (label.length !== 0) {
            // inject pseudo label to render the input
            e.after("<span class=\"label\">&nbsp;</span>");
            return;
          } // generate id


          id = "input__" + ++$.guid;
          e.prop('id', id);
        } else {
          if ($("[for=" + id + "]").length > 0) {
            // has a label: nothing to do
            return;
          }
        } // create and append label


        e.after("<label for=\"" + id + "\">&nbsp;</label>");
      });
      headerSearch();
      $(".widget_media_gallery").widget_gallery_carousel(Mateo.labels);
      $(window).on("resize", Menu_Hortical_Manager.manage);
    });
  })(jQuery));

}(jQuery));
