(function () {
  'use strict';

  (function ($) {
    /** Current theme layout for one or two column layout.
     * @type {number} Values: 1|2. Default: 1.
     */
    var MateoThemeLayout = parseInt(window.Mateo && window.Mateo.Layout || 1);
    var mateoPostLayout = parseInt(window.Mateo && window.Mateo.ItemLayout || 1);
    var EditorWrapper = '.editor-styles-wrapper';
    var LayoutCssClassName = 'layout-1';
    var EditorManagedClassName = 'editor-managed';
    var MustApplyOneColumn = MateoThemeLayout === 1 || mateoPostLayout === 1;
    var oneColumnAppliedOnLoad = false; // Flag saying if header image is enabled.

    var hasHeaderImg = parseInt(window.Mateo && window.Mateo.HasHeaderImg) === 1; // Feature to display featured image in header is enabled?

    var featuredImgHeader = parseInt(window.Mateo && window.Mateo.FeaturedImgHeader) === 1; // Post has featured image?

    var hasFeaturedImg = parseInt(window.Mateo && window.Mateo.HasFeaturedImg) === 1;
    /**
     *
     * @returns {boolean}
     */

    var hasImageInHeader = function hasImageInHeader() {
      return hasHeaderImg || featuredImgHeader && hasFeaturedImg;
    };
    /** Content wrapper selector.
     * @returns {jQuery} */


    var getWrapper = function getWrapper() {
      var elem = document.querySelector(".block-editor-block-list__layout");
      return elem ? $(elem) : null;
    };
    /**
     * Enabled/disables top and bottom spacing for the post content.
     *
     * @param status TRUE to enable FALSE to disable.
     */


    var setEditorManaged = function setEditorManaged(status) {
      var wrapper = getWrapper();

      if (wrapper) {
        if (status) {
          wrapper.addClass(EditorManagedClassName);
        } else {
          wrapper.removeClass(EditorManagedClassName);
        }
      }
    };
    /** Apply one column css name to editor inner container. So blocks can be rendered in wide and full modes.
     * @returns {boolean} TRUE if element found FALSE if not.
     */


    var applyOneColumnLayout = function applyOneColumnLayout() {
      var status = false;
      var wrapper = getWrapper();

      if (wrapper) {
        wrapper.addClass(LayoutCssClassName);
        status = true;
      }

      return status;
    };
    /** Removed one column css name from editor inner container.
     * @returns {boolean} TRUE if element found FALSE if not.
     */


    var removeOneColumnLayout = function removeOneColumnLayout() {
      var status = false;
      var wrapper = getWrapper();

      if (wrapper) {
        wrapper.removeClass(LayoutCssClassName);
        status = true;
      }

      return status;
    };
    /**
     * Set post's layout: 1 or 2 column.
     * Executed only once on editor loading.
     */


    var setLayoutOnLoad = function setLayoutOnLoad() {
      if (MustApplyOneColumn && !oneColumnAppliedOnLoad) {
        applyOneColumnLayout();
        oneColumnAppliedOnLoad = true;
        mateoPostLayout = 1;
      }
    };
    /**
     * Sets the css variable for the page background.
     * @param color Hex color or null
     */


    var applyPostBackgroundColor = function applyPostBackgroundColor(color) {
      var wrapper = document.querySelector(EditorWrapper);

      if (!wrapper) {
        return;
      }

      if (!color) {
        color = 'unset';
      }

      wrapper.style.setProperty('--mateo-custom-page-bgr', color);
    };

    var isColumnInjected = false;
    /**
     * Append a column to the editor so we can preview a page and content background  colors.
     */

    var injectColumn = function injectColumn() {
      if (!isColumnInjected) {
        var wrapper = getWrapper();

        if (wrapper) {
          wrapper.append('<div class="mateo-column "></div>');
          isColumnInjected = true;
        }
      }
    };
    /**
     *
     * @returns {boolean} FALSE if post title element is not found (not loaded yet.)
     */


    var applyTitleCSS = function applyTitleCSS() {
      var titleBlock = document.querySelector('.block-editor__typewriter');

      if (!titleBlock) {
        // Block not loaded est.
        return false;
      }

      if (hasImageInHeader()) {
        titleBlock.classList.add('mateo-header-has-image');
      } else {
        titleBlock.classList.remove('mateo-header-has-image');
      }

      return true;
    };

    var applyTitleCSSOnLoad = function applyTitleCSSOnLoad() {
      if (!hasImageInHeader()) {
        return;
      }

      applyTitleCSS();
    };

    var Body = $('body');
    /**
     * Force one column layout for the post (page, etc...) in case of 2 column layout (ex. sidebar has elements)
     */

    Body.on('change', '[name=_mateo_column_layout]', function (event) {
      var checkbox = $(event.target);
      checkbox.prop('checked') ? applyOneColumnLayout() : removeOneColumnLayout();
    });
    /**
     * Apply user selected color to the page background.
     */

    Body.on('input', '[name=_mateo_page_bgr]', function (event) {
      var input = $(event.target);
      var color = input.val() || null;
      applyPostBackgroundColor(color);
      var defaultColorIndicator = $('#mateo_page_bgr_indicator');
      var customColorIndicator = $('#mateo_page_bgr_preview');

      if (color === null) {
        defaultColorIndicator.show();
        customColorIndicator.hide();
      } else {
        defaultColorIndicator.hide();
        customColorIndicator.css('background-color', color);
        customColorIndicator.show();
      }
    }); // Apply CSS according to _mateo_disable_header status

    Body.on('change', '#_mateo_disable_header', function (event) {
      var checkbox = $(event.target);
      setEditorManaged(checkbox.prop('checked'));
    });
    var mediaId = 0;

    var watchFeaturedImageChange = function watchFeaturedImageChange() {
      var featuredImg;

      try {
        featuredImg = wp.data.select('core/editor').getEditedPostAttribute('featured_media');
      } catch (e) {
        return;
      }

      if (typeof featuredImg === "undefined") {
        // API not loaded yet.
        return;
      }

      if (featuredImg === mediaId) {
        return;
      }

      mediaId = featuredImg;
      hasFeaturedImg = mediaId > 0;
      applyTitleCSS();
    };
    /**
     *
     * @type {boolean}
     */


    var editorInitialized = false;
    /**
     * Execute only once when block editor is fully initialized.
     */

    var runOnEditorInitialized = function runOnEditorInitialized() {
      if (editorInitialized) {
        return;
      }

      if (!document.querySelector(EditorWrapper)) {
        return;
      }

      editorInitialized = true;
      setLayoutOnLoad();
      injectColumn();
      applyTitleCSSOnLoad();
      setEditorManaged($('#_mateo_disable_header').prop('checked'));
      var contentContainer = getWrapper();

      if (contentContainer) {
        // Fix for WP <= 5.4
        if (!contentContainer.hasClass('is-root-container')) {
          contentContainer.addClass('is-root-container');
        }
      }
    };

    wp.data.subscribe(function (param) {
      runOnEditorInitialized();
      watchFeaturedImageChange();
    });
    $(document).ready(function () {
      // Following controls are initialized with meta boxes so they are available on body load.
      $('.mateo_pagebgr_control').each(function () {
        var mateoPageBgrInput = $(this);
        mateoPageBgrInput.wpColorPicker({
          width: 240,
          change: function change(event, ui) {
            var color = ui.color.toString(); // Set color and trigger input event so we can handle the changes from manual and automatic input.

            mateoPageBgrInput.val(color);
            mateoPageBgrInput.trigger("input");
          },
          clear: function clear(event) {
            mateoPageBgrInput.trigger("input");
          }
        });
      });
    });
  })(jQuery);

}());
