(function () {
  'use strict';

  //import $ from 'jquery';
  var Widget_Gallery_Carousel = function ($) {
    // Rearrange elements to fit bootstrap carousel structure.
    var NAME = 'widget_gallery_carousel';
    var DATA_KEY = 'mateo.gallery-carousel';
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Default = {
      // Css classes for carousel effects.
      effects: 'slide carousel-fade',
      // Buttons labels.
      previous: 'Previous',
      next: 'Next'
    };

    var Widget_Gallery_Carousel = /*#__PURE__*/function () {
      function Widget_Gallery_Carousel(element, config) {
        this.config = $.extend(true, {}, Default, config || {});
        this.transform(element);
      }
      /**
       * Transforms wordpress media widget into bootstrap carousel component.
       * @param container
       */


      var _proto = Widget_Gallery_Carousel.prototype;

      _proto.transform = function transform(container) {
        var gallery = container.find(".gallery"); // not a gallery

        if (gallery.length === 0) {
          return;
        }

        gallery.detach();
        var base = $('<div class="carousel-base"></div>').appendTo(container);
        var icons = gallery.find(".gallery-icon"); // Append next/previous button only if there are many images.

        if (icons.length > 1) {
          icons.append("<a class=\"carousel-control-prev\" href=\"#" + container.prop('id') + "\" role=\"button\" data-slide=\"prev\">\n        <span class=\"carousel-control-prev-icon\" aria-hidden=\"true\"></span>\n        <span class=\"screen-reader-text\">" + this.config.previous + "</span>\n        </a>\n        <a class=\"carousel-control-next\" href=\"#" + container.prop('id') + "\" role=\"button\" data-slide=\"next\">\n        <span class=\"carousel-control-next-icon\" aria-hidden=\"true\"></span>\n        <span class=\"screen-reader-text\">" + this.config.next + "</span>\n        </a>");
        }

        gallery.addClass("carousel-inner").find(".gallery-item").addClass("carousel-item").first().addClass("active");
        base.append(gallery);
        container.addClass("carousel " + this.config.effects);
      }
      /**
       * @returns {*}
       */
      ;

      Widget_Gallery_Carousel.jQueryInterface = function jQueryInterface() {
        return this.each(function () {
          var $element = $(this);
          var data = $element.data(DATA_KEY);

          if (!data) {
            data = new Widget_Gallery_Carousel($element);
            $element.data(DATA_KEY, data);
          }
        });
      };

      return Widget_Gallery_Carousel;
    }();
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     */


    $.fn[NAME] = Widget_Gallery_Carousel.jQueryInterface;
    $.fn[NAME].Constructor = Widget_Gallery_Carousel;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return Widget_Gallery_Carousel.jQueryInterface;
    };

    return Widget_Gallery_Carousel;
  }(jQuery);

  //import $ from 'jquery';
  var headerSearch = (function ($) {
    return function () {
      var topSearchBtn = $(".top-search-btn");

      if (topSearchBtn.length > 0) {
        var searchForm = $(".top-search-form");
        var searchInput = searchForm.find("input[type=search]");
        var cancelSearchBtn = searchForm.find(".search-cancel"); // Trigger search form display

        topSearchBtn.on("click", function () {
          searchForm.addClass("show");
          searchInput.focus();
        }); // Close search form

        cancelSearchBtn.on('click', function () {
          searchForm.removeClass("show");
          topSearchBtn.focus();
        });
      }
    };
  })(jQuery);

  /**
   * Live-update changed settings in real time in the Customizer preview.
   */

  (function (api, $) {
    /**
     *
     * @param id  ID name (without starting '#').
     * @returns {{length}|jQuery} JQuery instance of the element.
     */
    var getHeaderStyleTagRef = function getHeaderStyleTagRef(id) {
      var styleRef = $("#" + id);

      if (!styleRef.length) {
        styleRef = $('head').append("<style id=\"" + id + "\"></style>").find("#" + id);
      }

      return styleRef;
    };
    /**
     * Sets the value of a CSS variable.
     * @param key
     * @param value
     */


    var setVarValue = function setVarValue(key, value) {
      document.documentElement.style.setProperty(key, value);
    };

    var colorSchemeStyleRef = getHeaderStyleTagRef('mateo-style-color-scheme-css');
    var layoutStyleRef = getHeaderStyleTagRef('mateo-style-layout-css');
    var fontsStyleRef = getHeaderStyleTagRef('mateo-style-fonts-css');
    var fontsLinkRef = $('#mateo-fonts-css'); // Site title.

    api('blogname', function (value) {
      value.bind(function (to) {
        $('.site-title a').text(to);
      });
    }); // Sidebar position.

    api('sidebar-position', function (value) {
      value.bind(function (to) {
        if (to === 'reverse' && $('.sidebar-default').length > 0) {
          $('.sidebar-default').removeClass('sidebar-default').addClass('sidebar-reverse');
        } else if (to === 'default' && $('.sidebar-reverse').length > 0) {
          $('.sidebar-reverse').removeClass('sidebar-reverse').addClass('sidebar-default');
        }
      });
    });
    /**
     * Trigger window resize to fit menu items into available width.
     */

    api('header-width', function (setting) {
      setting.bind(function (to) {
        $(window).trigger('resize');
      });
    });
    /**
     * Apply rounded logo setting to the preview.
     */

    api('logo-round', function (setting) {
      setting.bind(function (to) {
        $('.custom-logo').css('border-radius', to + 'px');
      });
    });
    api('titleBgrDisable', function (setting) {
      setting.bind(function (value) {
        var title = document.querySelector('.page-title');

        if (!title) {
          return;
        }

        if (value) {
          title.classList.add('bgr-alpha-0');
        } else {
          title.classList.remove('bgr-alpha-0');
        }
      });
    }); //  Custom events.

    api.bind('preview-ready', function () {
      // Re-load carousel initialisation script.
      api.selectiveRefresh.bind('partial-content-rendered', function (placement) {
        if (placement.addedContent && placement.partial.widgetIdParts && placement.partial.widgetIdParts.idBase === "media_gallery") {
          var gallery = $('#' + placement.partial.widgetId);

          if (gallery.length > 0) {
            new Widget_Gallery_Carousel(gallery);
          }
        } // Re-inialize search header block if it was added (placement has some content).


        if (placement.partial.id === "header-search-box" && placement.addedContent.length > 10) {
          headerSearch();
        }
      }); // Update Color Scheme CSS in preview when it's updated in customizer.

      api.preview.bind('update-color-scheme-css', function (css) {
        return colorSchemeStyleRef.html(css);
      }); // update layout in preview when it's updated in customizer.

      api.preview.bind('update-mateo-layout-css', function (css) {
        return layoutStyleRef.html(css);
      });
      api.preview.bind('update-mateo-fonts-css', function (css) {
        return fontsStyleRef.html(css);
      });
      api.preview.bind('update-mateo-fonts-link', function (fontsURI) {
        return fontsLinkRef.prop('href', fontsURI);
      });
      api.preview.bind('update-css-var', function (data) {
        setVarValue(data.key, data.value);
      });
    });
  })(wp.customize, jQuery);

}());
