(function () {
  'use strict';

  var rangeSlider = function ($) {
    return function () {
      var slider = $('.range-slider'),
          range = $('.range-slider__range'),
          value = $('.range-slider__value');
      slider.each(function () {
        value.each(function () {
          var value = $(this).prev().attr('value');
          $(this).html(value + 'px');
        });
        var ie11 = window.navigator.userAgent.indexOf('Trident/7.0');
        var eventType = ie11 > 0 ? 'change' : 'input';
        range.on(eventType, function () {
          $(this).next('.range-slider__value').html(this.value + 'px');
        });
      });
    };
  }(jQuery);

  /* global mateoColorScheme, Color */

  /**
   * Add listener to the Color Scheme control to update other color controls to new values/defaults.
   * Also trigger an update of the Color Scheme CSS when a color is changed.
   */
  ((function (api) {
    var cssTemplate = wp.template('mateo-color-scheme'),
        colorSettings = ['primary', 'primaryLight', 'primaryDark', 'textOnPrimary', 'link', 'textBody', 'title', 'titleBgr', 'titleNoHeader', 'contentBgr', 'pageBgr'];
    api.controlConstructor.select = api.Control.extend({
      ready: function ready() {
        if ('color_scheme' === this.id) {
          this.setting.bind('change', function (value) {
            var colors = mateoColorScheme[value].colors;

            _.each(colors, function (color, settingId) {
              api(settingId).set(color);
              api.control(settingId).container.find('.color-picker-hex').data('data-default-color', color).wpColorPicker('defaultColor', color);
            });
          });
        }
      }
    }); // Generate the CSS for the current Color Scheme.

    function updateCSS() {
      var scheme = api('color_scheme')(),
          colors = _.object(colorSettings, mateoColorScheme[scheme].colors); // Merge in color scheme overrides.


      _.each(colorSettings, function (setting) {
        colors[setting] = api(setting)();
      }); // Add derived colors.


      colors['primarySubmenuBgr'] = Color(colors['primary']).toCSS('rgba', 0.9);
      colors['switchCheckedBgr'] = Color(colors['primary']).lighten(28).desaturate(32).toString();
      colors['currentMenuItem'] = Color(colors['textOnPrimary']).toCSS('rgba', 0.2);
      colors['menuItemHover'] = colors['currentMenuItem'];
      colors['bmdLabelOnPrimary'] = colors['textOnPrimary'];
      colors['bmdLabelFooter'] = Color(colors['textOnPrimary']).toCSS('rgba', 0.8);
      colors['footerInputInvalid'] = Color(colors['textOnPrimary']).toCSS('rgba', 0.26);
      colors['preBgr'] = Color(colors['textBody']).toCSS('rgba', 0.01);
      colors['lightTextBody'] = Color(colors['textBody']).toCSS('rgba', 0.8);
      colors['varyLightTextBody'] = Color(colors['textBody']).toCSS('rgba', 0.1);
      api.previewer.send('update-color-scheme-css', cssTemplate(colors));
    } // Update the CSS whenever a color setting is changed.


    _.each(colorSettings, function (setting) {
      api(setting, function (setting) {
        setting.bind(updateCSS);
      });
    });

    api('titleBgrDisable', function (setting) {
      setting.bind(function (value) {
        value ? api.control('titleBgr').deactivate() : api.control('titleBgr').activate();
      });
    }); // header_textcolor is a shortcut for textOnPrimary.

    api('textOnPrimary', function (setting) {
      setting.bind(function () {
        api('header_textcolor').set(setting.get());
      });
    });
    api('header_textcolor', function (setting) {
      setting.bind(function () {
        api('textOnPrimary').set(setting.get());
      });
    });
  })(wp.customize));

  /* global wp */

  /**
   * Add a listener to width controls to update the peview to new values/defaults.
   */
  ((function (api) {
    var cssLayoutTemplate = wp.template('mateo-layout-css');
    /**
     * Generates data for the js template and sends it to the preview.
     */

    function updateLayoutCss() {
      var data = {
        'contentWidth': api('content-width').get(),
        'titleWidth': api('title-width').get(),
        'headerWidth': api('header-width').get(),
        'footerWidth': api('footer-width').get()
      };
      api.previewer.send('update-mateo-layout-css', cssLayoutTemplate(data));
    }

    _.each(['content-width', 'title-width', 'header-width', 'footer-width'], function (setting) {
      api(setting, function (setting) {
        setting.bind(updateLayoutCss);
      });
    });
  })(wp.customize));

  /**
   * Generates a font-family parameter for the Google Fonts API request.
   * Uses global variables:
   * - mateoFonts : List of google fonts
   * - mateoFontsDefaults : Default settings for the CSS.
   */
  ((function (wp, $) {
    var cssTemplate = wp.template('mateo-fonts-css');
    var api = wp.customize;
    var familyVariantDependency = {
      'font-family': 'font-variant',
      'font-family-headers': 'font-variant-headers',
      'font-family-title': 'font-variant-title',
      'font-family-monospace': 'font-variant-monospace'
    };
    /**
     * Default font variants used by Mateo theme.
     * @type {string[]}
     */

    var defaultVariants = ['300', '400', 'regular', '700'];
    /**
     * Gets font configuration from global variable.
     * @param fontKey
     * @returns {object|null}
     */

    var getFontConfig = function getFontConfig(fontKey) {
      return mateoFonts[fontKey] || null;
    };
    /**
     *  Hides not available variants and presets a 'regular' font variant in settings.
     * @param fontKey
     * @param variantSettingName
     */


    var updateFontVariantsOptions = function updateFontVariantsOptions(fontKey, variantSettingName) {
      var fontConfig = getFontConfig(fontKey); // Loop through variants options and display only those declared in font's settings.
      // If fontConfig does not exist choose 'default' option andhide others.

      var selector = "[data-customize-setting-link=\"" + variantSettingName + "\"] option";
      $(selector).map(function () {
        if (this.value !== '') {
          var option = $(this);

          if (fontConfig) {
            fontConfig.variants.indexOf(this.value) === -1 ? option.hide() : option.show();
          } else {
            option.hide();
          }
        }
      });
    };
    /**
     * Gets font family and font category from fonts configuration.
     * @param fontKey
     * @returns {{}|null}
     */


    var getFontFamily = function getFontFamily(fontKey) {
      if (!fontKey) {
        return null;
      }

      var result = {};
      var fontConfig = getFontConfig(fontKey);

      if (!fontConfig) {
        return null;
      }

      result['fontFamily'] = fontConfig.name;
      result['fontCategory'] = fontConfig.category;
      return result;
    };
    /**
     * Parses variant value and extracts 'font-style' and 'font-weight' CSS settings from it.
     * @param value
     * @returns {{fontStyle: string, fontWeight: number}|null}
     */


    var getVariationCSS = function getVariationCSS(value) {
      if (!value) {
        return null;
      }

      var result = {
        fontStyle: 'normal',
        fontWeight: 400
      };

      if (value !== '' && value !== 'regular') {
        if (value.indexOf('ital') !== -1) {
          result['fontStyle'] = 'italic';
        }

        var fontWeight = parseInt(value);

        if (!isNaN(fontWeight)) {
          result['fontWeight'] = fontWeight;
        }
      }

      return result;
    };
    /**
     * Return data related to some font used in Google Font API call.
     * @param {string} fontKey Font family key.
     * @param {string} variant Related font variant.
     * @returns {{}|null}
     */


    var getFontsToLoad = function getFontsToLoad(fontKey, variant) {
      var result = {};
      var fontConfig = getFontConfig(fontKey);

      if (!fontConfig) {
        return null;
      }

      result['fontFamily'] = fontConfig.name;

      if (!variant) {
        result['variant'] = fontConfig.variants.filter(function (item) {
          return defaultVariants.indexOf(item) !== -1;
        });
      } else {
        result['variant'] = [variant];
      }

      return result;
    };
    /**
     * Builds unique URL with all required fonts and its variants and triggers their loading in a preview.
     */


    var getGoogleApiURI = function getGoogleApiURI() {
      var result = {};

      _.mapObject(familyVariantDependency, function (variant, font) {
        var fontKey = api(font)();

        if (fontKey) {
          result[fontKey] = getFontsToLoad(fontKey, api(variant)());
        }
      });

      var familyLoad = ['Material Icons'];

      _.each(result, function (data) {
        return familyLoad.push(data.fontFamily + ":" + data.variant.join(","));
      });

      var link = "https://fonts.googleapis.com/css?family=" + familyLoad.join('|');
      api.previewer.send('update-mateo-fonts-link', link);
    };
    /**
     * Grabs settings values and triggers CSS update in a preview.
     */


    var updateFontsCSS = function updateFontsCSS() {
      var nameMapping = {
        fontSize: 'font-size',
        lineHeight: 'font-line-height',
        fontSizeHeaders: 'font-size-headers',
        lineHeightHeaders: 'font-line-height-headers',
        fontSizeTitle: 'font-size-title',
        lineHeightTitle: 'font-line-height-title',
        fontSizeMonospace: 'font-size-monospace',
        lineHeightMonospace: 'font-line-height-monospace'
      };

      var data = _.assign({}, mateoFontsDefaults);

      var fontFamilyData = getFontFamily(api('font-family')());

      if (fontFamilyData) {
        data.fontFamily = fontFamilyData.fontFamily;
        data.fontCategory = fontFamilyData.fontCategory;
      }

      var fontVariantData = getVariationCSS(api('font-variant')());

      if (fontVariantData) {
        data = _.assign(data, fontVariantData);
      }

      fontFamilyData = getFontFamily(api('font-family-headers')());

      if (fontFamilyData) {
        data.fontFamilyHeaders = fontFamilyData.fontFamily + ", " + fontFamilyData.fontCategory;
      }

      fontVariantData = getVariationCSS(api('font-variant-headers')());

      if (fontVariantData) {
        data.fontStyleHeaders = fontVariantData.fontStyle;
        data.fontWeightHeaders = fontVariantData.fontWeight;
      }

      for (var item in nameMapping) {
        data[item] = api(nameMapping[item])();
      }

      if (!data.lineHeightTitle || data.lineHeightTitle === '0') {
        // Inherits from headers line height if not set.
        data.lineHeightTitle = data.lineHeightHeaders;
      }

      fontFamilyData = getFontFamily(api('font-family-title')());

      if (fontFamilyData) {
        data.fontFamilyTitle = fontFamilyData.fontFamily + ", " + fontFamilyData.fontCategory;
      } else {
        data.fontFamilyTitle = data.fontFamilyHeaders;
      }

      fontVariantData = getVariationCSS(api('font-variant-title')());

      if (fontVariantData) {
        data.fontStyleTitle = fontVariantData.fontStyle;
        data.fontWeightTitle = fontVariantData.fontWeight;
      }

      fontFamilyData = getFontFamily(api('font-family-monospace')());

      if (fontFamilyData) {
        data.fontFamilyMonospace = fontFamilyData.fontFamily + ", " + fontFamilyData.fontCategory;
      }

      fontVariantData = getVariationCSS(api('font-variant-monospace')());

      if (fontVariantData) {
        data.fontStyleMonospace = fontVariantData.fontStyle;
        data.fontWeightMonospace = fontVariantData.fontWeight;
      }

      api.previewer.send('update-mateo-fonts-css', cssTemplate(data));
    };
    /**
     * Manages dependency between font family and its variations.
     * Triggers an update of font variants in case of a font change.
     *
     * @param fontControlId   Font family control ID.
     * @param variantControlId  Font variant control ID
     * @returns {boolean} TRUE if a variant's value has been reset FALSE if not.
     */


    var manageFontVariationDependency = function manageFontVariationDependency(fontControlId, variantControlId) {
      var variantValue = api(variantControlId).get();
      updateFontVariantsOptions(api(fontControlId).get(), variantControlId);

      if (variantValue !== '') {
        // Reset font variants. This will trigger fonts reloading.
        api(variantControlId).set('');
        return true;
      }

      return false;
    };
    /**
     * Handler for font family or font variant changes.
     *
     * @param {string} controlId
     */


    var manageFontChange = function manageFontChange(controlId) {
      if (Object.keys(familyVariantDependency).indexOf(controlId) !== -1) {
        var isVariantReset = manageFontVariationDependency(controlId, familyVariantDependency[controlId]);

        if (isVariantReset) {
          // Font variants has been reset so there is no need to continue cause this triggers a fonts update.
          return;
        }
      }

      getGoogleApiURI();
      updateFontsCSS();
    }; // Do when customize is loaded.


    api.bind('ready', function () {
      // Update font variant options for currently selected font families.
      updateFontVariantsOptions(api('font-family').get(), 'font-variant');
      updateFontVariantsOptions(api('font-family-headers').get(), 'font-variant-headers');
      updateFontVariantsOptions(api('font-family-title').get(), 'font-variant-title');
      updateFontVariantsOptions(api('font-family-monospace').get(), 'font-variant-monospace');
    });

    _.each(['font-size', 'font-line-height', 'font-size-headers', 'font-line-height-headers', 'font-size-title', 'font-line-height-title', 'font-size-monospace', 'font-line-height-monospace'], function (settingName) {
      return api(settingName, function (setting) {
        return setting.bind(updateFontsCSS);
      });
    });

    _.each(['font-family', 'font-variant', 'font-family-headers', 'font-variant-headers', 'font-family-title', 'font-variant-title', 'font-family-monospace', 'font-variant-monospace'], function (settingName) {
      return api(settingName, function (setting) {
        setting.bind(function () {
          return manageFontChange(settingName);
        });
      });
    });
  })(wp, jQuery));

  (function (api) {
    /**
     * Passes CSS variable to the preview.
     * @param cssVarName
     * @param value
     */


    var triggerVarPreview = function triggerVarPreview(cssVarName, value) {
      var data = {
        key: cssVarName,
        value: value
      };
      api.previewer.send('update-css-var', data);
    };
    /**
     *
     * @param mapping Collection of setting ids and CSS variables .
     * @param suffix  Suffix to add to the value.
     */


    var triggerBulkVarPreviewConcat = function triggerBulkVarPreviewConcat(mapping, suffix) {
      Object.keys(mapping).forEach(function (settingId) {
        return triggerVarPreview(mapping[settingId], "" + api(settingId).get() + suffix);
      });
    }; // Footer font management.
    /**
     *
     * @param {string|number} value
     * @param {string} settingId Setting Id.
     * @param {Object} collection
     */


    var previewValueWithUnit = function previewValueWithUnit(value, settingId, collection) {
      if (collection.inProgress) {
        // Padding value update is in progress.
        return;
      }

      var cssValue = "" + value + api(collection.unitControlId).get();
      triggerVarPreview(collection.props[settingId], cssValue);
    }; // Watch for custom logo changes and enbale/disable a "Round logo" control


    api('custom_logo', function (setting) {
      setting.bind(function (value) {
        if (!value) {
          api.control('logo-round').deactivate();
        } else {
          api.control('logo-round').activate();
        }
      });
    });
    /**
     * Map with settings IDs and corresponding CSS variables names.
     * These settings do not require value validation before the preview (bad values are simply ignored by browsers).
     * @type {Object}
     */

    var settingsMapSimple = {
      'footer-widgets': '--mateo-primary-footer-widgets-lg',
      'footer-alignment': '--mateo-primary-footer-align',
      'footer-widget-alignment': '--mateo-primary-footer-widget-align',
      'footer-widget-title-transform': '--mateo-primary-footer-widget-title-transform',
      'footer2-widgets': '--mateo-second-footer-widgets-lg',
      'footer2-alignment': '--mateo-second-footer-align',
      'footer2-widget-alignment': '--mateo-second-footer-widget-align',
      'footer2-widget-title-transform': '--mateo-second-footer-widget-title-transform',
      'mateo-sidebar-widget-alignment': '--mateo-sidebar-widget-align',
      'mateo-sidebar-title-transform': '--mateo-sidebar-widget-title-transform',
      'mateo-title-alignment': '--mateo-page-title-alignment',
      'mateo-title-transform': '--mateo-page-title-transform'
    };
    var unitDependant = {
      sitePadding: {
        props: {
          'mateo-content-pad-top': '--mateo-site-pad-top',
          'mateo-content-pad-right': '--mateo-site-pad-right',
          'mateo-content-pad-bottom': '--mateo-site-pad-bottom',
          'mateo-content-pad-left': '--mateo-site-pad-left'
        },
        unitControlId: 'mateo-content-pad-unit',
        inProgress: false
      },
      siteRadius: {
        props: {
          'mateo-content-radius-top-left': '--mateo-site-radius-top-left',
          'mateo-content-radius-top-right': '--mateo-site-radius-top-right',
          'mateo-content-radius-bottom-left': '--mateo-site-radius-bottom-left',
          'mateo-content-radius-bottom-right': '--mateo-site-radius-bottom-right'
        },
        unitControlId: 'mateo-content-radius-unit',
        inProgress: false
      },
      siteMargin: {
        props: {
          'mateo-content-margin-top': '--mateo-site-margin-top',
          'mateo-content-margin-bottom': '--mateo-site-margin-bottom'
        },
        unitControlId: 'mateo-content-margin-unit',
        inProgress: false
      },
      sidebarFontSize: {
        props: {
          'mateo-sidebar-font-size': '--mateo-sidebar-font-size'
        },
        unitControlId: 'mateo-sidebar-font-unit',
        inProgress: false
      },
      sidebarPadding: {
        props: {
          'mateo-sidebar-widget-pad-top': '--mateo-sidebar-widget-pad-top',
          'mateo-sidebar-widget-pad-right': '--mateo-sidebar-widget-pad-right',
          'mateo-sidebar-widget-pad-bottom': '--mateo-sidebar-widget-pad-bottom',
          'mateo-sidebar-widget-pad-left': '--mateo-sidebar-widget-pad-left'
        },
        unitControlId: 'mateo-sidebar-widget-pad-unit',
        inProgress: false
      },
      footerPrimaryFontSize: {
        props: {
          'footer-font-size': '--mateo-primary-footer-font-size'
        },
        unitControlId: 'footer-font-unit',
        inProgress: false
      },
      footerPrimaryPadding: {
        props: {
          'footer-widget-pad-top': '--mateo-primary-footer-widget-pad-top',
          'footer-widget-pad-right': '--mateo-primary-footer-widget-pad-right',
          'footer-widget-pad-bottom': '--mateo-primary-footer-widget-pad-bottom',
          'footer-widget-pad-left': '--mateo-primary-footer-widget-pad-left'
        },
        unitControlId: 'footer-widget-pad-unit',
        inProgress: false
      },
      footerSecondaryFontSize: {
        props: {
          'footer2-font-size': '--mateo-second-footer-font-size'
        },
        unitControlId: 'footer2-font-unit',
        inProgress: false
      },
      footerSecondaryPadding: {
        props: {
          'footer2-widget-pad-top': '--mateo-second-footer-widget-pad-top',
          'footer2-widget-pad-right': '--mateo-second-footer-widget-pad-right',
          'footer2-widget-pad-bottom': '--mateo-second-footer-widget-pad-bottom',
          'footer2-widget-pad-left': '--mateo-second-footer-widget-pad-left'
        },
        unitControlId: 'footer2-widget-pad-unit',
        inProgress: false
      }
    };
    Object.keys(settingsMapSimple).forEach(function (settingId) {
      api(settingId, function (setting) {
        setting.bind(function (value) {
          return triggerVarPreview(settingsMapSimple[settingId], value);
        });
      });
    });
    api('mateo-breadcrumb', function (setting) {
      setting.bind(function (value) {
        if (value) {
          api.control('mateo-breadcrumb-home-disable').activate();
          api.control('mateo-breadcrumb-page-disable').activate();
        } else {
          api.control('mateo-breadcrumb-home-disable').deactivate();
          api.control('mateo-breadcrumb-page-disable').deactivate();
        }
      });
    });
    api.bind('ready', function () {
      _.each(unitDependant, function (item, key) {
        // Trigger related settings preview.
        api(item.unitControlId, function (setting) {
          setting.bind(function (unit) {
            return triggerBulkVarPreviewConcat(unitDependant[key]['props'], unit);
          });
        }); // Trigger settings preview.

        _.each(Object.keys(unitDependant[key]['props']), function (id) {
          api(id, function (setting) {
            return setting.bind(function (value) {
              previewValueWithUnit(value, id, unitDependant[key]);
            });
          });
        });
      });
    });
  })(wp.customize);

  (function ($) {
    $(document).ready(function () {
      rangeSlider();
    });
  })(jQuery);

}());
