<?php
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  Tr 1.0.0
 * @access public
 */
final class Tr_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since Tr 1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since Tr 1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since Tr 1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since Tr 1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		require_once (  get_template_directory()  . '/inc/customizer/pro/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Tr_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Tr_Customize_Section_Pro(
				$manager,
				'marte',
				array(
					'title'    => esc_html__( 'Support and Donation
','marte' ),
					'pro_text' => esc_html__( 'Click here
','marte' ),
					'pro_url'  => esc_url( 'https://www.miguelsantiago.com.br/support/' )
				)
			)
		);
	}
	

	
	

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since Tr 1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'marte-go-pro-customize-controls', trailingslashit( get_template_directory_uri() ) . 'inc/customizer/pro/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'marte-go-pro-customize-controls', trailingslashit( get_template_directory_uri() ) . 'inc/customizer/pro/customize-controls.css' );
	}
}

// Doing this customizer thang!
Tr_Customize::get_instance();
