<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Marsh Blog
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="post-item">
		<?php if ( has_post_thumbnail() ) : ?>
            <div class="featured-image">
                <a href="<?php the_permalink();?>"><?php the_post_thumbnail(); ?></a>
            </div><!-- .featured-image -->
        <?php endif; ?>

        <div class="entry-container">
			<div class="entry-meta">    
				<?php marsh_blog_entry_meta(); ?>  
			</div><!-- .entry-meta -->
				                      
			<header class="entry-header">
				<?php
				if ( is_single() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif; ?>
			</header><!-- .entry-header -->

			<div class="entry-content">
	            <?php the_excerpt(); ?>
	        </div><!-- .entry-content -->

	        <?php $readmore_text = marsh_blog_get_option( 'readmore_text' );?>
	        <?php if (!empty($readmore_text) ) :?>
	            <div class="read-more">
	                <a href="<?php the_permalink();?>"><?php echo esc_html($readmore_text);?></a>
					<?php marsh_blog_posted_on() ?>
	            </div><!-- .read-more -->
	        <?php endif; ?>
	    </div><!-- .entry-container -->
	</div><!-- .post-item -->
</article><!-- #post-## -->