
( function( $, api ) {
	/* === Repeater Text Control === */
	api.controlConstructor['marsh-blog-repeater-text'] = api.Control.extend({

		ready: function() {

			'use strict';

			var control = this;

			control.initCustomControl();
		},

		initCustomControl: function() {

			'use strict';

			var control = this;

			control.populate(control);

			control.container.on( 'click', '.btn-add-field', control, function(event) {
				control.add(event);
			} );
			control.container.on( 'change', '.repeater-text-single-field', control, function() {
				control.updateValue();
			} );
			control.container.on( 'click', '.btn-remove-field', control, function(event) {
				control.remove(event);
				control.updateValue();
			} );
		},

		populate: function() {

			'use strict';

			var wrapper = this.selector;
			var multi_saved_value = jQuery(wrapper).find( '.repeater-text-value' ).val();
			if ( multi_saved_value.length > 0 ) {
				var multi_saved_values = multi_saved_value.split( '|' );
				jQuery(wrapper).find( '.repeater-text-fields' ).empty();
				jQuery.each(multi_saved_values, function( i, value ) {
					jQuery(wrapper).find( '.repeater-text-fields' ).append( '<div class="set"><input type="text" value="' + value + '" class="repeater-text-single-field" /><span class="btn-remove-field"><span class="dashicons dashicons-no-alt"></span></span></div>' );
				});
			}
		},

		add: function(event) {
			'use strict';

			event.preventDefault();
			jQuery(event.target).parent('.repeater-text-input').find('.repeater-text-fields').append( '<div class="set"><input type="text" value="" class="repeater-text-single-field" /><span class="btn-remove-field"><span class="dashicons dashicons-no-alt"></span></span></div>' );
		},

		remove: function(event) {
			'use strict';

			event.preventDefault();
			jQuery(event.target).parent().parent().remove();
		},

		updateValue: function() {
			'use strict';

			var values = '';
			var wrapper = this.selector;
			jQuery(wrapper).find( '.repeater-text-fields .repeater-text-single-field' ).each(function() {
				values += jQuery(this).val() + '|';
			});

			jQuery(wrapper).find( '.repeater-text-value' ).val( values.slice( 0, -1 ) ).change();
		}

	});

    // upsell 
    api.sectionConstructor['marsh-blog-upsell'] = api.Section.extend( {
        // No events for this type of section.
        attachEvents: function () {},
        // Always make the section active.
        isContextuallyActive: function () {
            return true;
        }
    } );
} )( jQuery, wp.customize );
/**
* Custom Js for image select in customizer
*
* @package marsh_blog
*/

jQuery(document).ready(function($) {

    $('#marsh-blog-img-container img').click(function() {      
        var item_id = $(this).parent().parent().parent().parent().attr('id');

        $('#' + item_id).find('li').each(function() {
            $('#' + item_id).find('img').removeClass('marsh-blog-radio-img-selected') ;
        });

        $(this).addClass('marsh-blog-radio-img-selected') ;
    });

    $('body').prepend('<div id="icons-list-wrapper"><div class="icons-list"><ul><li><i class="fab fa-500px"></i></li><li><i class="fab fa-accessible-icon"></i></li><li><i class="fab fa-accusoft"></i></li><li><i class="fab fa-acquisitions-incorporated"></i></li><li><i class="fas fa-address-book"></i></li><li><i class="fas fa-address-card"></i></li><li><i class="fas fa-adjust"></i></li><li><i class="fab fa-adn"></i></li><li><i class="fab fa-adversal"></i></li><li><i class="fab fa-affiliatetheme"></i></li><li><i class="fas fa-air-freshener"></i></li><li><i class="fab fa-airbnb"></i></li><li><i class="fab fa-algolia"></i></li><li><i class="fas fa-align-center"></i></li><li><i class="fas fa-align-justify"></i></li><li><i class="fas fa-align-left"></i></li><li><i class="fas fa-align-right"></i></li><li><i class="fab fa-alipay"></i></li><li><i class="fas fa-allergies"></i></li><li><i class="fab fa-amazon"></i></li><li><i class="fab fa-amazon-pay"></i></li><li><i class="fas fa-ambulance"></i></li><li><i class="fas fa-american-sign-language-interpreting"></i></li><li><i class="fab fa-amilia"></i></li><li><i class="fas fa-anchor"></i></li><li><i class="fab fa-android"></i></li><li><i class="fab fa-angellist"></i></li><li><i class="fas fa-angle-double-down"></i></li><li><i class="fas fa-angle-double-left"></i></li><li><i class="fas fa-angle-double-right"></i></li><li><i class="fas fa-angle-double-up"></i></li><li><i class="fas fa-angle-down"></i></li><li><i class="fas fa-angle-left"></i></li><li><i class="fas fa-angle-right"></i></li><li><i class="fas fa-angle-up"></i></li><li><i class="fas fa-angry"></i></li><li><i class="fab fa-angrycreative"></i></li><li><i class="fab fa-angular"></i></li><li><i class="fas fa-ankh"></i></li><li><i class="fab fa-app-store"></i></li><li><i class="fab fa-app-store-ios"></i></li><li><i class="fab fa-apper"></i></li><li><i class="fab fa-apple"></i></li><li><i class="fas fa-apple-alt"></i></li><li><i class="fab fa-apple-pay"></i></li><li><i class="fas fa-archive"></i></li><li><i class="fas fa-archway"></i></li><li><i class="fas fa-arrow-alt-circle-down"></i></li><li><i class="fas fa-arrow-alt-circle-left"></i></li><li><i class="fas fa-arrow-alt-circle-right"></i></li><li><i class="fas fa-arrow-alt-circle-up"></i></li><li><i class="fas fa-arrow-circle-down"></i></li><li><i class="fas fa-arrow-circle-left"></i></li><li><i class="fas fa-arrow-circle-right"></i></li><li><i class="fas fa-arrow-circle-up"></i></li><li><i class="fas fa-arrow-down"></i></li><li><i class="fas fa-arrow-left"></i></li><li><i class="fas fa-arrow-right"></i></li><li><i class="fas fa-arrow-up"></i></li><li><i class="fas fa-arrows-alt"></i></li><li><i class="fas fa-arrows-alt-h"></i></li><li><i class="fas fa-arrows-alt-v"></i></li><li><i class="fab fa-artstation"></i></li><li><i class="fas fa-assistive-listening-systems"></i></li><li><i class="fas fa-asterisk"></i></li><li><i class="fab fa-asymmetrik"></i></li><li><i class="fas fa-at"></i></li><li><i class="fas fa-atlas"></i></li><li><i class="fab fa-atlassian"></i></li><li><i class="fas fa-atom"></i></li><li><i class="fab fa-audible"></i></li><li><i class="fas fa-audio-description"></i></li><li><i class="fab fa-autoprefixer"></i></li><li><i class="fab fa-avianex"></i></li><li><i class="fab fa-aviato"></i></li><li><i class="fas fa-award"></i></li><li><i class="fab fa-aws"></i></li><li><i class="fas fa-baby"></i></li><li><i class="fas fa-baby-carriage"></i></li><li><i class="fas fa-backspace"></i></li><li><i class="fas fa-backward"></i></li><li><i class="fas fa-bacon"></i></li><li><i class="fas fa-balance-scale"></i></li><li><i class="fas fa-balance-scale-left"></i></li><li><i class="fas fa-balance-scale-right"></i></li><li><i class="fas fa-ban"></i></li><li><i class="fas fa-band-aid"></i></li><li><i class="fab fa-bandcamp"></i></li><li><i class="fas fa-barcode"></i></li><li><i class="fas fa-bars"></i></li><li><i class="fas fa-baseball-ball"></i></li><li><i class="fas fa-basketball-ball"></i></li><li><i class="fas fa-bath"></i></li><li><i class="fas fa-battery-empty"></i></li><li><i class="fas fa-battery-full"></i></li><li><i class="fas fa-battery-half"></i></li><li><i class="fas fa-battery-quarter"></i></li><li><i class="fas fa-battery-three-quarters"></i></li><li><i class="fab fa-battle-net"></i></li><li><i class="fas fa-bed"></i></li><li><i class="fas fa-beer"></i></li><li><i class="fab fa-behance"></i></li><li><i class="fab fa-behance-square"></i></li><li><i class="fas fa-bell"></i></li><li><i class="fas fa-bell-slash"></i></li><li><i class="fas fa-bezier-curve"></i></li><li><i class="fas fa-bible"></i></li><li><i class="fas fa-bicycle"></i></li><li><i class="fas fa-biking"></i></li><li><i class="fab fa-bimobject"></i></li><li><i class="fas fa-binoculars"></i></li><li><i class="fas fa-biohazard"></i></li><li><i class="fas fa-birthday-cake"></i></li><li><i class="fab fa-bitbucket"></i></li><li><i class="fab fa-bitcoin"></i></li><li><i class="fab fa-bity"></i></li><li><i class="fab fa-black-tie"></i></li><li><i class="fab fa-blackberry"></i></li><li><i class="fas fa-blender"></i></li><li><i class="fas fa-blender-phone"></i></li><li><i class="fas fa-blind"></i></li><li><i class="fas fa-blog"></i></li><li><i class="fab fa-blogger"></i></li><li><i class="fab fa-blogger-b"></i></li><li><i class="fab fa-bluetooth"></i></li><li><i class="fab fa-bluetooth-b"></i></li><li><i class="fas fa-bold"></i></li><li><i class="fas fa-bolt"></i></li><li><i class="fas fa-bomb"></i></li><li><i class="fas fa-bone"></i></li><li><i class="fas fa-bong"></i></li><li><i class="fas fa-book"></i></li><li><i class="fas fa-book-dead"></i></li><li><i class="fas fa-book-medical"></i></li><li><i class="fas fa-book-open"></i></li><li><i class="fas fa-book-reader"></i></li><li><i class="fas fa-bookmark"></i></li><li><i class="fab fa-bootstrap"></i></li><li><i class="fas fa-border-all"></i></li><li><i class="fas fa-border-none"></i></li><li><i class="fas fa-border-style"></i></li><li><i class="fas fa-bowling-ball"></i></li><li><i class="fas fa-box"></i></li><li><i class="fas fa-box-open"></i></li><li><i class="fas fa-boxes"></i></li><li><i class="fas fa-braille"></i></li><li><i class="fas fa-brain"></i></li><li><i class="fas fa-bread-slice"></i></li><li><i class="fas fa-briefcase"></i></li><li><i class="fas fa-briefcase-medical"></i></li><li><i class="fas fa-broadcast-tower"></i></li><li><i class="fas fa-broom"></i></li><li><i class="fas fa-brush"></i></li><li><i class="fab fa-btc"></i></li><li><i class="fab fa-buffer"></i></li><li><i class="fas fa-bug"></i></li><li><i class="fas fa-building"></i></li><li><i class="fas fa-bullhorn"></i></li><li><i class="fas fa-bullseye"></i></li><li><i class="fas fa-burn"></i></li><li><i class="fab fa-buromobelexperte"></i></li><li><i class="fas fa-bus"></i></li><li><i class="fas fa-bus-alt"></i></li><li><i class="fas fa-business-time"></i></li><li><i class="fab fa-buysellads"></i></li><li><i class="fas fa-calculator"></i></li><li><i class="fas fa-calendar"></i></li><li><i class="fas fa-calendar-alt"></i></li><li><i class="fas fa-calendar-check"></i></li><li><i class="fas fa-calendar-day"></i></li><li><i class="fas fa-calendar-minus"></i></li><li><i class="fas fa-calendar-plus"></i></li><li><i class="fas fa-calendar-times"></i></li><li><i class="fas fa-calendar-week"></i></li><li><i class="fas fa-camera"></i></li><li><i class="fas fa-camera-retro"></i></li><li><i class="fas fa-campground"></i></li><li><i class="fab fa-canadian-maple-leaf"></i></li><li><i class="fas fa-candy-cane"></i></li><li><i class="fas fa-cannabis"></i></li><li><i class="fas fa-capsules"></i></li><li><i class="fas fa-car"></i></li><li><i class="fas fa-car-alt"></i></li><li><i class="fas fa-car-battery"></i></li><li><i class="fas fa-car-crash"></i></li><li><i class="fas fa-car-side"></i></li><li><i class="fas fa-caret-down"></i></li><li><i class="fas fa-caret-left"></i></li><li><i class="fas fa-caret-right"></i></li><li><i class="fas fa-caret-square-down"></i></li><li><i class="fas fa-caret-square-left"></i></li><li><i class="fas fa-caret-square-right"></i></li><li><i class="fas fa-caret-square-up"></i></li><li><i class="fas fa-caret-up"></i></li><li><i class="fas fa-carrot"></i></li><li><i class="fas fa-cart-arrow-down"></i></li><li><i class="fas fa-cart-plus"></i></li><li><i class="fas fa-cash-register"></i></li><li><i class="fas fa-cat"></i></li><li><i class="fab fa-cc-amazon-pay"></i></li><li><i class="fab fa-cc-amex"></i></li><li><i class="fab fa-cc-apple-pay"></i></li><li><i class="fab fa-cc-diners-club"></i></li><li><i class="fab fa-cc-discover"></i></li><li><i class="fab fa-cc-jcb"></i></li><li><i class="fab fa-cc-mastercard"></i></li><li><i class="fab fa-cc-paypal"></i></li><li><i class="fab fa-cc-stripe"></i></li><li><i class="fab fa-cc-visa"></i></li><li><i class="fab fa-centercode"></i></li><li><i class="fab fa-centos"></i></li><li><i class="fas fa-certificate"></i></li><li><i class="fas fa-chair"></i></li><li><i class="fas fa-chalkboard"></i></li><li><i class="fas fa-chalkboard-teacher"></i></li><li><i class="fas fa-charging-station"></i></li><li><i class="fas fa-chart-area"></i></li><li><i class="fas fa-chart-bar"></i></li><li><i class="fas fa-chart-line"></i></li><li><i class="fas fa-chart-pie"></i></li><li><i class="fas fa-check"></i></li><li><i class="fas fa-check-circle"></i></li><li><i class="fas fa-check-double"></i></li><li><i class="fas fa-check-square"></i></li><li><i class="fas fa-cheese"></i></li><li><i class="fas fa-chess"></i></li><li><i class="fas fa-chess-bishop"></i></li><li><i class="fas fa-chess-board"></i></li><li><i class="fas fa-chess-king"></i></li><li><i class="fas fa-chess-knight"></i></li><li><i class="fas fa-chess-pawn"></i></li><li><i class="fas fa-chess-queen"></i></li><li><i class="fas fa-chess-rook"></i></li><li><i class="fas fa-chevron-circle-down"></i></li><li><i class="fas fa-chevron-circle-left"></i></li><li><i class="fas fa-chevron-circle-right"></i></li><li><i class="fas fa-chevron-circle-up"></i></li><li><i class="fas fa-chevron-down"></i></li><li><i class="fas fa-chevron-left"></i></li><li><i class="fas fa-chevron-right"></i></li><li><i class="fas fa-chevron-up"></i></li><li><i class="fas fa-child"></i></li><li><i class="fab fa-chrome"></i></li><li><i class="fab fa-chromecast"></i></li><li><i class="fas fa-church"></i></li><li><i class="fas fa-circle"></i></li><li><i class="fas fa-circle-notch"></i></li><li><i class="fas fa-city"></i></li><li><i class="fas fa-clinic-medical"></i></li><li><i class="fas fa-clipboard"></i></li><li><i class="fas fa-clipboard-check"></i></li><li><i class="fas fa-clipboard-list"></i></li><li><i class="fas fa-clock"></i></li><li><i class="fas fa-clone"></i></li><li><i class="fas fa-closed-captioning"></i></li><li><i class="fas fa-cloud"></i></li><li><i class="fas fa-cloud-download-alt"></i></li><li><i class="fas fa-cloud-meatball"></i></li><li><i class="fas fa-cloud-moon"></i></li><li><i class="fas fa-cloud-moon-rain"></i></li><li><i class="fas fa-cloud-rain"></i></li><li><i class="fas fa-cloud-showers-heavy"></i></li><li><i class="fas fa-cloud-sun"></i></li><li><i class="fas fa-cloud-sun-rain"></i></li><li><i class="fas fa-cloud-upload-alt"></i></li><li><i class="fab fa-cloudscale"></i></li><li><i class="fab fa-cloudsmith"></i></li><li><i class="fab fa-cloudversify"></i></li><li><i class="fas fa-cocktail"></i></li><li><i class="fas fa-code"></i></li><li><i class="fas fa-code-branch"></i></li><li><i class="fab fa-codepen"></i></li><li><i class="fab fa-codiepie"></i></li><li><i class="fas fa-coffee"></i></li><li><i class="fas fa-cog"></i></li><li><i class="fas fa-cogs"></i></li><li><i class="fas fa-coins"></i></li><li><i class="fas fa-columns"></i></li><li><i class="fas fa-comment"></i></li><li><i class="fas fa-comment-alt"></i></li><li><i class="fas fa-comment-dollar"></i></li><li><i class="fas fa-comment-dots"></i></li><li><i class="fas fa-comment-medical"></i></li><li><i class="fas fa-comment-slash"></i></li><li><i class="fas fa-comments"></i></li><li><i class="fas fa-comments-dollar"></i></li><li><i class="fas fa-compact-disc"></i></li><li><i class="fas fa-compass"></i></li><li><i class="fas fa-compress"></i></li><li><i class="fas fa-compress-arrows-alt"></i></li><li><i class="fas fa-concierge-bell"></i></li><li><i class="fab fa-confluence"></i></li><li><i class="fab fa-connectdevelop"></i></li><li><i class="fab fa-contao"></i></li><li><i class="fas fa-cookie"></i></li><li><i class="fas fa-cookie-bite"></i></li><li><i class="fas fa-copy"></i></li><li><i class="fas fa-copyright"></i></li><li><i class="fas fa-couch"></i></li><li><i class="fab fa-cpanel"></i></li><li><i class="fab fa-creative-commons"></i></li><li><i class="fab fa-creative-commons-by"></i></li><li><i class="fab fa-creative-commons-nc"></i></li><li><i class="fab fa-creative-commons-nc-eu"></i></li><li><i class="fab fa-creative-commons-nc-jp"></i></li><li><i class="fab fa-creative-commons-nd"></i></li><li><i class="fab fa-creative-commons-pd"></i></li><li><i class="fab fa-creative-commons-pd-alt"></i></li><li><i class="fab fa-creative-commons-remix"></i></li><li><i class="fab fa-creative-commons-sa"></i></li><li><i class="fab fa-creative-commons-sampling"></i></li><li><i class="fab fa-creative-commons-sampling-plus"></i></li><li><i class="fab fa-creative-commons-share"></i></li><li><i class="fab fa-creative-commons-zero"></i></li><li><i class="fas fa-credit-card"></i></li><li><i class="fab fa-critical-role"></i></li><li><i class="fas fa-crop"></i></li><li><i class="fas fa-crop-alt"></i></li><li><i class="fas fa-cross"></i></li><li><i class="fas fa-crosshairs"></i></li><li><i class="fas fa-crow"></i></li><li><i class="fas fa-crown"></i></li><li><i class="fas fa-crutch"></i></li><li><i class="fab fa-css3"></i></li><li><i class="fab fa-css3-alt"></i></li><li><i class="fas fa-cube"></i></li><li><i class="fas fa-cubes"></i></li><li><i class="fas fa-cut"></i></li><li><i class="fab fa-cuttlefish"></i></li><li><i class="fab fa-d-and-d"></i></li><li><i class="fab fa-d-and-d-beyond"></i></li><li><i class="fab fa-dashcube"></i></li><li><i class="fas fa-database"></i></li><li><i class="fas fa-deaf"></i></li><li><i class="fab fa-delicious"></i></li><li><i class="fas fa-democrat"></i></li><li><i class="fab fa-deploydog"></i></li><li><i class="fab fa-deskpro"></i></li><li><i class="fas fa-desktop"></i></li><li><i class="fab fa-dev"></i></li><li><i class="fab fa-deviantart"></i></li><li><i class="fas fa-dharmachakra"></i></li><li><i class="fab fa-dhl"></i></li><li><i class="fas fa-diagnoses"></i></li><li><i class="fab fa-diaspora"></i></li><li><i class="fas fa-dice"></i></li><li><i class="fas fa-dice-d20"></i></li><li><i class="fas fa-dice-d6"></i></li><li><i class="fas fa-dice-five"></i></li><li><i class="fas fa-dice-four"></i></li><li><i class="fas fa-dice-one"></i></li><li><i class="fas fa-dice-six"></i></li><li><i class="fas fa-dice-three"></i></li><li><i class="fas fa-dice-two"></i></li><li><i class="fab fa-digg"></i></li><li><i class="fab fa-digital-ocean"></i></li><li><i class="fas fa-digital-tachograph"></i></li><li><i class="fas fa-directions"></i></li><li><i class="fab fa-discord"></i></li><li><i class="fab fa-discourse"></i></li><li><i class="fas fa-divide"></i></li><li><i class="fas fa-dizzy"></i></li><li><i class="fas fa-dna"></i></li><li><i class="fab fa-dochub"></i></li><li><i class="fab fa-docker"></i></li><li><i class="fas fa-dog"></i></li><li><i class="fas fa-dollar-sign"></i></li><li><i class="fas fa-dolly"></i></li><li><i class="fas fa-dolly-flatbed"></i></li><li><i class="fas fa-donate"></i></li><li><i class="fas fa-door-closed"></i></li><li><i class="fas fa-door-open"></i></li><li><i class="fas fa-dot-circle"></i></li><li><i class="fas fa-dove"></i></li><li><i class="fas fa-download"></i></li><li><i class="fab fa-draft2digital"></i></li><li><i class="fas fa-drafting-compass"></i></li><li><i class="fas fa-dragon"></i></li><li><i class="fas fa-draw-polygon"></i></li><li><i class="fab fa-dribbble"></i></li><li><i class="fab fa-dribbble-square"></i></li><li><i class="fab fa-dropbox"></i></li><li><i class="fas fa-drum"></i></li><li><i class="fas fa-drum-steelpan"></i></li><li><i class="fas fa-drumstick-bite"></i></li><li><i class="fab fa-drupal"></i></li><li><i class="fas fa-dumbbell"></i></li><li><i class="fas fa-dumpster"></i></li><li><i class="fas fa-dumpster-fire"></i></li><li><i class="fas fa-dungeon"></i></li><li><i class="fab fa-dyalog"></i></li><li><i class="fab fa-earlybirds"></i></li><li><i class="fab fa-ebay"></i></li><li><i class="fab fa-edge"></i></li><li><i class="fas fa-edit"></i></li><li><i class="fas fa-egg"></i></li><li><i class="fas fa-eject"></i></li><li><i class="fab fa-elementor"></i></li><li><i class="fas fa-ellipsis-h"></i></li><li><i class="fas fa-ellipsis-v"></i></li><li><i class="fab fa-ello"></i></li><li><i class="fab fa-ember"></i></li><li><i class="fab fa-empire"></i></li><li><i class="fas fa-envelope"></i></li><li><i class="fas fa-envelope-open"></i></li><li><i class="fas fa-envelope-open-text"></i></li><li><i class="fas fa-envelope-square"></i></li><li><i class="fab fa-envira"></i></li><li><i class="fas fa-equals"></i></li><li><i class="fas fa-eraser"></i></li><li><i class="fab fa-erlang"></i></li><li><i class="fab fa-ethereum"></i></li><li><i class="fas fa-ethernet"></i></li><li><i class="fab fa-etsy"></i></li><li><i class="fas fa-euro-sign"></i></li><li><i class="fab fa-evernote"></i></li><li><i class="fas fa-exchange-alt"></i></li><li><i class="fas fa-exclamation"></i></li><li><i class="fas fa-exclamation-circle"></i></li><li><i class="fas fa-exclamation-triangle"></i></li><li><i class="fas fa-expand"></i></li><li><i class="fas fa-expand-arrows-alt"></i></li><li><i class="fab fa-expeditedssl"></i></li><li><i class="fas fa-external-link-alt"></i></li><li><i class="fas fa-external-link-square-alt"></i></li><li><i class="fas fa-eye"></i></li><li><i class="fas fa-eye-dropper"></i></li><li><i class="fas fa-eye-slash"></i></li><li><i class="fab fa-facebook"></i></li><li><i class="fab fa-facebook-f"></i></li><li><i class="fab fa-facebook-messenger"></i></li><li><i class="fab fa-facebook-square"></i></li><li><i class="fas fa-fan"></i></li><li><i class="fab fa-fantasy-flight-games"></i></li><li><i class="fas fa-fast-backward"></i></li><li><i class="fas fa-fast-forward"></i></li><li><i class="fas fa-fax"></i></li><li><i class="fas fa-feather"></i></li><li><i class="fas fa-feather-alt"></i></li><li><i class="fab fa-fedex"></i></li><li><i class="fab fa-fedora"></i></li><li><i class="fas fa-female"></i></li><li><i class="fas fa-fighter-jet"></i></li><li><i class="fab fa-figma"></i></li><li><i class="fas fa-file"></i></li><li><i class="fas fa-file-alt"></i></li><li><i class="fas fa-file-archive"></i></li><li><i class="fas fa-file-audio"></i></li><li><i class="fas fa-file-code"></i></li><li><i class="fas fa-file-contract"></i></li><li><i class="fas fa-file-csv"></i></li><li><i class="fas fa-file-download"></i></li><li><i class="fas fa-file-excel"></i></li><li><i class="fas fa-file-export"></i></li><li><i class="fas fa-file-image"></i></li><li><i class="fas fa-file-import"></i></li><li><i class="fas fa-file-invoice"></i></li><li><i class="fas fa-file-invoice-dollar"></i></li><li><i class="fas fa-file-medical"></i></li><li><i class="fas fa-file-medical-alt"></i></li><li><i class="fas fa-file-pdf"></i></li><li><i class="fas fa-file-powerpoint"></i></li><li><i class="fas fa-file-prescription"></i></li><li><i class="fas fa-file-signature"></i></li><li><i class="fas fa-file-upload"></i></li><li><i class="fas fa-file-video"></i></li><li><i class="fas fa-file-word"></i></li><li><i class="fas fa-fill"></i></li><li><i class="fas fa-fill-drip"></i></li><li><i class="fas fa-film"></i></li><li><i class="fas fa-filter"></i></li><li><i class="fas fa-fingerprint"></i></li><li><i class="fas fa-fire"></i></li><li><i class="fas fa-fire-alt"></i></li><li><i class="fas fa-fire-extinguisher"></i></li><li><i class="fab fa-firefox"></i></li><li><i class="fas fa-first-aid"></i></li><li><i class="fab fa-first-order"></i></li><li><i class="fab fa-first-order-alt"></i></li><li><i class="fab fa-firstdraft"></i></li><li><i class="fas fa-fish"></i></li><li><i class="fas fa-fist-raised"></i></li><li><i class="fas fa-flag"></i></li><li><i class="fas fa-flag-checkered"></i></li><li><i class="fas fa-flag-usa"></i></li><li><i class="fas fa-flask"></i></li><li><i class="fab fa-flickr"></i></li><li><i class="fab fa-flipboard"></i></li><li><i class="fas fa-flushed"></i></li><li><i class="fab fa-fly"></i></li><li><i class="fas fa-folder"></i></li><li><i class="fas fa-folder-minus"></i></li><li><i class="fas fa-folder-open"></i></li><li><i class="fas fa-folder-plus"></i></li><li><i class="fas fa-font"></i></li><li><i class="fab fa-font-awesome"></i></li><li><i class="fab fa-font-awesome-alt"></i></li><li><i class="fab fa-font-awesome-flag"></i></li><li><i class="fab fa-fonticons"></i></li><li><i class="fab fa-fonticons-fi"></i></li><li><i class="fas fa-football-ball"></i></li><li><i class="fab fa-fort-awesome"></i></li><li><i class="fab fa-fort-awesome-alt"></i></li><li><i class="fab fa-forumbee"></i></li><li><i class="fas fa-forward"></i></li><li><i class="fab fa-foursquare"></i></li><li><i class="fab fa-free-code-camp"></i></li><li><i class="fab fa-freebsd"></i></li><li><i class="fas fa-frog"></i></li><li><i class="fas fa-frown"></i></li><li><i class="fas fa-frown-open"></i></li><li><i class="fab fa-fulcrum"></i></li><li><i class="fas fa-funnel-dollar"></i></li><li><i class="fas fa-futbol"></i></li><li><i class="fab fa-galactic-republic"></i></li><li><i class="fab fa-galactic-senate"></i></li><li><i class="fas fa-gamepad"></i></li><li><i class="fas fa-gas-pump"></i></li><li><i class="fas fa-gavel"></i></li><li><i class="fas fa-gem"></i></li><li><i class="fas fa-genderless"></i></li><li><i class="fab fa-get-pocket"></i></li><li><i class="fab fa-gg"></i></li><li><i class="fab fa-gg-circle"></i></li><li><i class="fas fa-ghost"></i></li><li><i class="fas fa-gift"></i></li><li><i class="fas fa-gifts"></i></li><li><i class="fab fa-git"></i></li><li><i class="fab fa-git-alt"></i></li><li><i class="fab fa-git-square"></i></li><li><i class="fab fa-github"></i></li><li><i class="fab fa-github-alt"></i></li><li><i class="fab fa-github-square"></i></li><li><i class="fab fa-gitkraken"></i></li><li><i class="fab fa-gitlab"></i></li><li><i class="fab fa-gitter"></i></li><li><i class="fas fa-glass-cheers"></i></li><li><i class="fas fa-glass-martini"></i></li><li><i class="fas fa-glass-martini-alt"></i></li><li><i class="fas fa-glass-whiskey"></i></li><li><i class="fas fa-glasses"></i></li><li><i class="fab fa-glide"></i></li><li><i class="fab fa-glide-g"></i></li><li><i class="fas fa-globe"></i></li><li><i class="fas fa-globe-africa"></i></li><li><i class="fas fa-globe-americas"></i></li><li><i class="fas fa-globe-asia"></i></li><li><i class="fas fa-globe-europe"></i></li><li><i class="fab fa-gofore"></i></li><li><i class="fas fa-golf-ball"></i></li><li><i class="fab fa-goodreads"></i></li><li><i class="fab fa-goodreads-g"></i></li><li><i class="fab fa-google"></i></li><li><i class="fab fa-google-drive"></i></li><li><i class="fab fa-google-play"></i></li><li><i class="fab fa-google-plus"></i></li><li><i class="fab fa-google-plus-g"></i></li><li><i class="fab fa-google-plus-square"></i></li><li><i class="fab fa-google-wallet"></i></li><li><i class="fas fa-gopuram"></i></li><li><i class="fas fa-graduation-cap"></i></li><li><i class="fab fa-gratipay"></i></li><li><i class="fab fa-grav"></i></li><li><i class="fas fa-greater-than"></i></li><li><i class="fas fa-greater-than-equal"></i></li><li><i class="fas fa-grimace"></i></li><li><i class="fas fa-grin"></i></li><li><i class="fas fa-grin-alt"></i></li><li><i class="fas fa-grin-beam"></i></li><li><i class="fas fa-grin-beam-sweat"></i></li><li><i class="fas fa-grin-hearts"></i></li><li><i class="fas fa-grin-squint"></i></li><li><i class="fas fa-grin-squint-tears"></i></li><li><i class="fas fa-grin-stars"></i></li><li><i class="fas fa-grin-tears"></i></li><li><i class="fas fa-grin-tongue"></i></li><li><i class="fas fa-grin-tongue-squint"></i></li><li><i class="fas fa-grin-tongue-wink"></i></li><li><i class="fas fa-grin-wink"></i></li><li><i class="fas fa-grip-horizontal"></i></li><li><i class="fas fa-grip-lines"></i></li><li><i class="fas fa-grip-lines-vertical"></i></li><li><i class="fas fa-grip-vertical"></i></li><li><i class="fab fa-gripfire"></i></li><li><i class="fab fa-grunt"></i></li><li><i class="fas fa-guitar"></i></li><li><i class="fab fa-gulp"></i></li><li><i class="fas fa-h-square"></i></li><li><i class="fab fa-hacker-news"></i></li><li><i class="fab fa-hacker-news-square"></i></li><li><i class="fab fa-hackerrank"></i></li><li><i class="fas fa-hamburger"></i></li><li><i class="fas fa-hammer"></i></li><li><i class="fas fa-hamsa"></i></li><li><i class="fas fa-hand-holding"></i></li><li><i class="fas fa-hand-holding-heart"></i></li><li><i class="fas fa-hand-holding-usd"></i></li><li><i class="fas fa-hand-lizard"></i></li><li><i class="fas fa-hand-middle-finger"></i></li><li><i class="fas fa-hand-paper"></i></li><li><i class="fas fa-hand-peace"></i></li><li><i class="fas fa-hand-point-down"></i></li><li><i class="fas fa-hand-point-left"></i></li><li><i class="fas fa-hand-point-right"></i></li><li><i class="fas fa-hand-point-up"></i></li><li><i class="fas fa-hand-pointer"></i></li><li><i class="fas fa-hand-rock"></i></li><li><i class="fas fa-hand-scissors"></i></li><li><i class="fas fa-hand-spock"></i></li><li><i class="fas fa-hands"></i></li><li><i class="fas fa-hands-helping"></i></li><li><i class="fas fa-handshake"></i></li><li><i class="fas fa-hanukiah"></i></li><li><i class="fas fa-hard-hat"></i></li><li><i class="fas fa-hashtag"></i></li><li><i class="fas fa-hat-wizard"></i></li><li><i class="fas fa-haykal"></i></li><li><i class="fas fa-hdd"></i></li><li><i class="fas fa-heading"></i></li><li><i class="fas fa-headphones"></i></li><li><i class="fas fa-headphones-alt"></i></li><li><i class="fas fa-headset"></i></li><li><i class="fas fa-heart"></i></li><li><i class="fas fa-heart-broken"></i></li><li><i class="fas fa-heartbeat"></i></li><li><i class="fas fa-helicopter"></i></li><li><i class="fas fa-highlighter"></i></li><li><i class="fas fa-hiking"></i></li><li><i class="fas fa-hippo"></i></li><li><i class="fab fa-hips"></i></li><li><i class="fab fa-hire-a-helper"></i></li><li><i class="fas fa-history"></i></li><li><i class="fas fa-hockey-puck"></i></li><li><i class="fas fa-holly-berry"></i></li><li><i class="fas fa-home"></i></li><li><i class="fab fa-hooli"></i></li><li><i class="fab fa-hornbill"></i></li><li><i class="fas fa-horse"></i></li><li><i class="fas fa-horse-head"></i></li><li><i class="fas fa-hospital"></i></li><li><i class="fas fa-hospital-alt"></i></li><li><i class="fas fa-hospital-symbol"></i></li><li><i class="fas fa-hot-tub"></i></li><li><i class="fas fa-hotdog"></i></li><li><i class="fas fa-hotel"></i></li><li><i class="fab fa-hotjar"></i></li><li><i class="fas fa-hourglass"></i></li><li><i class="fas fa-hourglass-end"></i></li><li><i class="fas fa-hourglass-half"></i></li><li><i class="fas fa-hourglass-start"></i></li><li><i class="fas fa-house-damage"></i></li><li><i class="fab fa-houzz"></i></li><li><i class="fas fa-hryvnia"></i></li><li><i class="fab fa-html5"></i></li><li><i class="fab fa-hubspot"></i></li><li><i class="fas fa-i-cursor"></i></li><li><i class="fas fa-ice-cream"></i></li><li><i class="fas fa-icicles"></i></li><li><i class="fas fa-icons"></i></li><li><i class="fas fa-id-badge"></i></li><li><i class="fas fa-id-card"></i></li><li><i class="fas fa-id-card-alt"></i></li><li><i class="fas fa-igloo"></i></li><li><i class="fas fa-image"></i></li><li><i class="fas fa-images"></i></li><li><i class="fab fa-imdb"></i></li><li><i class="fas fa-inbox"></i></li><li><i class="fas fa-indent"></i></li><li><i class="fas fa-industry"></i></li><li><i class="fas fa-infinity"></i></li><li><i class="fas fa-info"></i></li><li><i class="fas fa-info-circle"></i></li><li><i class="fab fa-instagram"></i></li><li><i class="fab fa-intercom"></i></li><li><i class="fab fa-internet-explorer"></i></li><li><i class="fab fa-invision"></i></li><li><i class="fab fa-ioxhost"></i></li><li><i class="fas fa-italic"></i></li><li><i class="fab fa-itch-io"></i></li><li><i class="fab fa-itunes"></i></li><li><i class="fab fa-itunes-note"></i></li><li><i class="fab fa-java"></i></li><li><i class="fas fa-jedi"></i></li><li><i class="fab fa-jedi-order"></i></li><li><i class="fab fa-jenkins"></i></li><li><i class="fab fa-jira"></i></li><li><i class="fab fa-joget"></i></li><li><i class="fas fa-joint"></i></li><li><i class="fab fa-joomla"></i></li><li><i class="fas fa-journal-whills"></i></li><li><i class="fab fa-js"></i></li><li><i class="fab fa-js-square"></i></li><li><i class="fab fa-jsfiddle"></i></li><li><i class="fas fa-kaaba"></i></li><li><i class="fab fa-kaggle"></i></li><li><i class="fas fa-key"></i></li><li><i class="fab fa-keybase"></i></li><li><i class="fas fa-keyboard"></i></li><li><i class="fab fa-keycdn"></i></li><li><i class="fas fa-khanda"></i></li><li><i class="fab fa-kickstarter"></i></li><li><i class="fab fa-kickstarter-k"></i></li><li><i class="fas fa-kiss"></i></li><li><i class="fas fa-kiss-beam"></i></li><li><i class="fas fa-kiss-wink-heart"></i></li><li><i class="fas fa-kiwi-bird"></i></li><li><i class="fab fa-korvue"></i></li><li><i class="fas fa-landmark"></i></li><li><i class="fas fa-language"></i></li><li><i class="fas fa-laptop"></i></li><li><i class="fas fa-laptop-code"></i></li><li><i class="fas fa-laptop-medical"></i></li><li><i class="fab fa-laravel"></i></li><li><i class="fab fa-lastfm"></i></li><li><i class="fab fa-lastfm-square"></i></li><li><i class="fas fa-laugh"></i></li><li><i class="fas fa-laugh-beam"></i></li><li><i class="fas fa-laugh-squint"></i></li><li><i class="fas fa-laugh-wink"></i></li><li><i class="fas fa-layer-group"></i></li><li><i class="fas fa-leaf"></i></li><li><i class="fab fa-leanpub"></i></li><li><i class="fas fa-lemon"></i></li><li><i class="fab fa-less"></i></li><li><i class="fas fa-less-than"></i></li><li><i class="fas fa-less-than-equal"></i></li><li><i class="fas fa-level-down-alt"></i></li><li><i class="fas fa-level-up-alt"></i></li><li><i class="fas fa-life-ring"></i></li><li><i class="fas fa-lightbulb"></i></li><li><i class="fab fa-line"></i></li><li><i class="fas fa-link"></i></li><li><i class="fab fa-linkedin"></i></li><li><i class="fab fa-linkedin-in"></i></li><li><i class="fab fa-linode"></i></li><li><i class="fab fa-linux"></i></li><li><i class="fas fa-lira-sign"></i></li><li><i class="fas fa-list"></i></li><li><i class="fas fa-list-alt"></i></li><li><i class="fas fa-list-ol"></i></li><li><i class="fas fa-list-ul"></i></li><li><i class="fas fa-location-arrow"></i></li><li><i class="fas fa-lock"></i></li><li><i class="fas fa-lock-open"></i></li><li><i class="fas fa-long-arrow-alt-down"></i></li><li><i class="fas fa-long-arrow-alt-left"></i></li><li><i class="fas fa-long-arrow-alt-right"></i></li><li><i class="fas fa-long-arrow-alt-up"></i></li><li><i class="fas fa-low-vision"></i></li><li><i class="fas fa-luggage-cart"></i></li><li><i class="fab fa-lyft"></i></li><li><i class="fab fa-magento"></i></li><li><i class="fas fa-magic"></i></li><li><i class="fas fa-magnet"></i></li><li><i class="fas fa-mail-bulk"></i></li><li><i class="fab fa-mailchimp"></i></li><li><i class="fas fa-male"></i></li><li><i class="fab fa-mandalorian"></i></li><li><i class="fas fa-map"></i></li><li><i class="fas fa-map-marked"></i></li><li><i class="fas fa-map-marked-alt"></i></li><li><i class="fas fa-map-marker"></i></li><li><i class="fas fa-map-marker-alt"></i></li><li><i class="fas fa-map-pin"></i></li><li><i class="fas fa-map-signs"></i></li><li><i class="fab fa-markdown"></i></li><li><i class="fas fa-marker"></i></li><li><i class="fas fa-mars"></i></li><li><i class="fas fa-mars-double"></i></li><li><i class="fas fa-mars-stroke"></i></li><li><i class="fas fa-mars-stroke-h"></i></li><li><i class="fas fa-mars-stroke-v"></i></li><li><i class="fas fa-mask"></i></li><li><i class="fab fa-mastodon"></i></li><li><i class="fab fa-maxcdn"></i></li><li><i class="fas fa-medal"></i></li><li><i class="fab fa-medapps"></i></li><li><i class="fab fa-medium"></i></li><li><i class="fab fa-medium-m"></i></li><li><i class="fas fa-medkit"></i></li><li><i class="fab fa-medrt"></i></li><li><i class="fab fa-meetup"></i></li><li><i class="fab fa-megaport"></i></li><li><i class="fas fa-meh"></i></li><li><i class="fas fa-meh-blank"></i></li><li><i class="fas fa-meh-rolling-eyes"></i></li><li><i class="fas fa-memory"></i></li><li><i class="fab fa-mendeley"></i></li><li><i class="fas fa-menorah"></i></li><li><i class="fas fa-mercury"></i></li><li><i class="fas fa-meteor"></i></li><li><i class="fas fa-microchip"></i></li><li><i class="fas fa-microphone"></i></li><li><i class="fas fa-microphone-alt"></i></li><li><i class="fas fa-microphone-alt-slash"></i></li><li><i class="fas fa-microphone-slash"></i></li><li><i class="fas fa-microscope"></i></li><li><i class="fab fa-microsoft"></i></li><li><i class="fas fa-minus"></i></li><li><i class="fas fa-minus-circle"></i></li><li><i class="fas fa-minus-square"></i></li><li><i class="fas fa-mitten"></i></li><li><i class="fab fa-mix"></i></li><li><i class="fab fa-mixcloud"></i></li><li><i class="fab fa-mizuni"></i></li><li><i class="fas fa-mobile"></i></li><li><i class="fas fa-mobile-alt"></i></li><li><i class="fab fa-modx"></i></li><li><i class="fab fa-monero"></i></li><li><i class="fas fa-money-bill"></i></li><li><i class="fas fa-money-bill-alt"></i></li><li><i class="fas fa-money-bill-wave"></i></li><li><i class="fas fa-money-bill-wave-alt"></i></li><li><i class="fas fa-money-check"></i></li><li><i class="fas fa-money-check-alt"></i></li><li><i class="fas fa-monument"></i></li><li><i class="fas fa-moon"></i></li><li><i class="fas fa-mortar-pestle"></i></li><li><i class="fas fa-mosque"></i></li><li><i class="fas fa-motorcycle"></i></li><li><i class="fas fa-mountain"></i></li><li><i class="fas fa-mouse-pointer"></i></li><li><i class="fas fa-mug-hot"></i></li><li><i class="fas fa-music"></i></li><li><i class="fab fa-napster"></i></li><li><i class="fab fa-neos"></i></li><li><i class="fas fa-network-wired"></i></li><li><i class="fas fa-neuter"></i></li><li><i class="fas fa-newspaper"></i></li><li><i class="fab fa-nimblr"></i></li><li><i class="fab fa-node"></i></li><li><i class="fab fa-node-js"></i></li><li><i class="fas fa-not-equal"></i></li><li><i class="fas fa-notes-medical"></i></li><li><i class="fab fa-npm"></i></li><li><i class="fab fa-ns8"></i></li><li><i class="fab fa-nutritionix"></i></li><li><i class="fas fa-object-group"></i></li><li><i class="fas fa-object-ungroup"></i></li><li><i class="fab fa-odnoklassniki"></i></li><li><i class="fab fa-odnoklassniki-square"></i></li><li><i class="fas fa-oil-can"></i></li><li><i class="fab fa-old-republic"></i></li><li><i class="fas fa-om"></i></li><li><i class="fab fa-opencart"></i></li><li><i class="fab fa-openid"></i></li><li><i class="fab fa-opera"></i></li><li><i class="fab fa-optin-monster"></i></li><li><i class="fab fa-osi"></i></li><li><i class="fas fa-otter"></i></li><li><i class="fas fa-outdent"></i></li><li><i class="fab fa-page4"></i></li><li><i class="fab fa-pagelines"></i></li><li><i class="fas fa-pager"></i></li><li><i class="fas fa-paint-brush"></i></li><li><i class="fas fa-paint-roller"></i></li><li><i class="fas fa-palette"></i></li><li><i class="fab fa-palfed"></i></li><li><i class="fas fa-pallet"></i></li><li><i class="fas fa-paper-plane"></i></li><li><i class="fas fa-paperclip"></i></li><li><i class="fas fa-parachute-box"></i></li><li><i class="fas fa-paragraph"></i></li><li><i class="fas fa-parking"></i></li><li><i class="fas fa-passport"></i></li><li><i class="fas fa-pastafarianism"></i></li><li><i class="fas fa-paste"></i></li><li><i class="fab fa-patreon"></i></li><li><i class="fas fa-pause"></i></li><li><i class="fas fa-pause-circle"></i></li><li><i class="fas fa-paw"></i></li><li><i class="fab fa-paypal"></i></li><li><i class="fas fa-peace"></i></li><li><i class="fas fa-pen"></i></li><li><i class="fas fa-pen-alt"></i></li><li><i class="fas fa-pen-fancy"></i></li><li><i class="fas fa-pen-nib"></i></li><li><i class="fas fa-pen-square"></i></li><li><i class="fas fa-pencil-alt"></i></li><li><i class="fas fa-pencil-ruler"></i></li><li><i class="fab fa-penny-arcade"></i></li><li><i class="fas fa-people-carry"></i></li><li><i class="fas fa-pepper-hot"></i></li><li><i class="fas fa-percent"></i></li><li><i class="fas fa-percentage"></i></li><li><i class="fab fa-periscope"></i></li><li><i class="fas fa-person-booth"></i></li><li><i class="fab fa-phabricator"></i></li><li><i class="fab fa-phoenix-framework"></i></li><li><i class="fab fa-phoenix-squadron"></i></li><li><i class="fas fa-phone"></i></li><li><i class="fas fa-phone-alt"></i></li><li><i class="fas fa-phone-slash"></i></li><li><i class="fas fa-phone-square"></i></li><li><i class="fas fa-phone-square-alt"></i></li><li><i class="fas fa-phone-volume"></i></li><li><i class="fas fa-photo-video"></i></li><li><i class="fab fa-php"></i></li><li><i class="fab fa-pied-piper"></i></li><li><i class="fab fa-pied-piper-alt"></i></li><li><i class="fab fa-pied-piper-hat"></i></li><li><i class="fab fa-pied-piper-pp"></i></li><li><i class="fas fa-piggy-bank"></i></li><li><i class="fas fa-pills"></i></li><li><i class="fab fa-pinterest"></i></li><li><i class="fab fa-pinterest-p"></i></li><li><i class="fab fa-pinterest-square"></i></li><li><i class="fas fa-pizza-slice"></i></li><li><i class="fas fa-place-of-worship"></i></li><li><i class="fas fa-plane"></i></li><li><i class="fas fa-plane-arrival"></i></li><li><i class="fas fa-plane-departure"></i></li><li><i class="fas fa-play"></i></li><li><i class="fas fa-play-circle"></i></li><li><i class="fab fa-playstation"></i></li><li><i class="fas fa-plug"></i></li><li><i class="fas fa-plus"></i></li><li><i class="fas fa-plus-circle"></i></li><li><i class="fas fa-plus-square"></i></li><li><i class="fas fa-podcast"></i></li><li><i class="fas fa-poll"></i></li><li><i class="fas fa-poll-h"></i></li><li><i class="fas fa-poo"></i></li><li><i class="fas fa-poo-storm"></i></li><li><i class="fas fa-poop"></i></li><li><i class="fas fa-portrait"></i></li><li><i class="fas fa-pound-sign"></i></li><li><i class="fas fa-power-off"></i></li><li><i class="fas fa-pray"></i></li><li><i class="fas fa-praying-hands"></i></li><li><i class="fas fa-prescription"></i></li><li><i class="fas fa-prescription-bottle"></i></li><li><i class="fas fa-prescription-bottle-alt"></i></li><li><i class="fas fa-print"></i></li><li><i class="fas fa-procedures"></i></li><li><i class="fab fa-product-hunt"></i></li><li><i class="fas fa-project-diagram"></i></li><li><i class="fab fa-pushed"></i></li><li><i class="fas fa-puzzle-piece"></i></li><li><i class="fab fa-python"></i></li><li><i class="fab fa-qq"></i></li><li><i class="fas fa-qrcode"></i></li><li><i class="fas fa-question"></i></li><li><i class="fas fa-question-circle"></i></li><li><i class="fas fa-quidditch"></i></li><li><i class="fab fa-quinscape"></i></li><li><i class="fab fa-quora"></i></li><li><i class="fas fa-quote-left"></i></li><li><i class="fas fa-quote-right"></i></li><li><i class="fas fa-quran"></i></li><li><i class="fab fa-r-project"></i></li><li><i class="fas fa-radiation"></i></li><li><i class="fas fa-radiation-alt"></i></li><li><i class="fas fa-rainbow"></i></li><li><i class="fas fa-random"></i></li><li><i class="fab fa-raspberry-pi"></i></li><li><i class="fab fa-ravelry"></i></li><li><i class="fab fa-react"></i></li><li><i class="fab fa-reacteurope"></i></li><li><i class="fab fa-readme"></i></li><li><i class="fab fa-rebel"></i></li><li><i class="fas fa-receipt"></i></li><li><i class="fas fa-recycle"></i></li><li><i class="fab fa-red-river"></i></li><li><i class="fab fa-reddit"></i></li><li><i class="fab fa-reddit-alien"></i></li><li><i class="fab fa-reddit-square"></i></li><li><i class="fab fa-redhat"></i></li><li><i class="fas fa-redo"></i></li><li><i class="fas fa-redo-alt"></i></li><li><i class="fas fa-registered"></i></li><li><i class="fas fa-remove-format"></i></li><li><i class="fab fa-renren"></i></li><li><i class="fas fa-reply"></i></li><li><i class="fas fa-reply-all"></i></li><li><i class="fab fa-replyd"></i></li><li><i class="fas fa-republican"></i></li><li><i class="fab fa-researchgate"></i></li><li><i class="fab fa-resolving"></i></li><li><i class="fas fa-restroom"></i></li><li><i class="fas fa-retweet"></i></li><li><i class="fab fa-rev"></i></li><li><i class="fas fa-ribbon"></i></li><li><i class="fas fa-ring"></i></li><li><i class="fas fa-road"></i></li><li><i class="fas fa-robot"></i></li><li><i class="fas fa-rocket"></i></li><li><i class="fab fa-rocketchat"></i></li><li><i class="fab fa-rockrms"></i></li><li><i class="fas fa-route"></i></li><li><i class="fas fa-rss"></i></li><li><i class="fas fa-rss-square"></i></li><li><i class="fas fa-ruble-sign"></i></li><li><i class="fas fa-ruler"></i></li><li><i class="fas fa-ruler-combined"></i></li><li><i class="fas fa-ruler-horizontal"></i></li><li><i class="fas fa-ruler-vertical"></i></li><li><i class="fas fa-running"></i></li><li><i class="fas fa-rupee-sign"></i></li><li><i class="fas fa-sad-cry"></i></li><li><i class="fas fa-sad-tear"></i></li><li><i class="fab fa-safari"></i></li><li><i class="fab fa-salesforce"></i></li><li><i class="fab fa-sass"></i></li><li><i class="fas fa-satellite"></i></li><li><i class="fas fa-satellite-dish"></i></li><li><i class="fas fa-save"></i></li><li><i class="fab fa-schlix"></i></li><li><i class="fas fa-school"></i></li><li><i class="fas fa-screwdriver"></i></li><li><i class="fab fa-scribd"></i></li><li><i class="fas fa-scroll"></i></li><li><i class="fas fa-sd-card"></i></li><li><i class="fas fa-search"></i></li><li><i class="fas fa-search-dollar"></i></li><li><i class="fas fa-search-location"></i></li><li><i class="fas fa-search-minus"></i></li><li><i class="fas fa-search-plus"></i></li><li><i class="fab fa-searchengin"></i></li><li><i class="fas fa-seedling"></i></li><li><i class="fab fa-sellcast"></i></li><li><i class="fab fa-sellsy"></i></li><li><i class="fas fa-server"></i></li><li><i class="fab fa-servicestack"></i></li><li><i class="fas fa-shapes"></i></li><li><i class="fas fa-share"></i></li><li><i class="fas fa-share-alt"></i></li><li><i class="fas fa-share-alt-square"></i></li><li><i class="fas fa-share-square"></i></li><li><i class="fas fa-shekel-sign"></i></li><li><i class="fas fa-shield-alt"></i></li><li><i class="fas fa-ship"></i></li><li><i class="fas fa-shipping-fast"></i></li><li><i class="fab fa-shirtsinbulk"></i></li><li><i class="fas fa-shoe-prints"></i></li><li><i class="fas fa-shopping-bag"></i></li><li><i class="fas fa-shopping-basket"></i></li><li><i class="fas fa-shopping-cart"></i></li><li><i class="fab fa-shopware"></i></li><li><i class="fas fa-shower"></i></li><li><i class="fas fa-shuttle-van"></i></li><li><i class="fas fa-sign"></i></li><li><i class="fas fa-sign-in-alt"></i></li><li><i class="fas fa-sign-language"></i></li><li><i class="fas fa-sign-out-alt"></i></li><li><i class="fas fa-signal"></i></li><li><i class="fas fa-signature"></i></li><li><i class="fas fa-sim-card"></i></li><li><i class="fab fa-simplybuilt"></i></li><li><i class="fab fa-sistrix"></i></li><li><i class="fas fa-sitemap"></i></li><li><i class="fab fa-sith"></i></li><li><i class="fas fa-skating"></i></li><li><i class="fab fa-sketch"></i></li><li><i class="fas fa-skiing"></i></li><li><i class="fas fa-skiing-nordic"></i></li><li><i class="fas fa-skull"></i></li><li><i class="fas fa-skull-crossbones"></i></li><li><i class="fab fa-skyatlas"></i></li><li><i class="fab fa-skype"></i></li><li><i class="fab fa-slack"></i></li><li><i class="fab fa-slack-hash"></i></li><li><i class="fas fa-slash"></i></li><li><i class="fas fa-sleigh"></i></li><li><i class="fas fa-sliders-h"></i></li><li><i class="fab fa-slideshare"></i></li><li><i class="fas fa-smile"></i></li><li><i class="fas fa-smile-beam"></i></li><li><i class="fas fa-smile-wink"></i></li><li><i class="fas fa-smog"></i></li><li><i class="fas fa-smoking"></i></li><li><i class="fas fa-smoking-ban"></i></li><li><i class="fas fa-sms"></i></li><li><i class="fab fa-snapchat"></i></li><li><i class="fab fa-snapchat-ghost"></i></li><li><i class="fab fa-snapchat-square"></i></li><li><i class="fas fa-snowboarding"></i></li><li><i class="fas fa-snowflake"></i></li><li><i class="fas fa-snowman"></i></li><li><i class="fas fa-snowplow"></i></li><li><i class="fas fa-socks"></i></li><li><i class="fas fa-solar-panel"></i></li><li><i class="fas fa-sort"></i></li><li><i class="fas fa-sort-alpha-down"></i></li><li><i class="fas fa-sort-alpha-down-alt"></i></li><li><i class="fas fa-sort-alpha-up"></i></li><li><i class="fas fa-sort-alpha-up-alt"></i></li><li><i class="fas fa-sort-amount-down"></i></li><li><i class="fas fa-sort-amount-down-alt"></i></li><li><i class="fas fa-sort-amount-up"></i></li><li><i class="fas fa-sort-amount-up-alt"></i></li><li><i class="fas fa-sort-down"></i></li><li><i class="fas fa-sort-numeric-down"></i></li><li><i class="fas fa-sort-numeric-down-alt"></i></li><li><i class="fas fa-sort-numeric-up"></i></li><li><i class="fas fa-sort-numeric-up-alt"></i></li><li><i class="fas fa-sort-up"></i></li><li><i class="fab fa-soundcloud"></i></li><li><i class="fab fa-sourcetree"></i></li><li><i class="fas fa-spa"></i></li><li><i class="fas fa-space-shuttle"></i></li><li><i class="fab fa-speakap"></i></li><li><i class="fab fa-speaker-deck"></i></li><li><i class="fas fa-spell-check"></i></li><li><i class="fas fa-spider"></i></li><li><i class="fas fa-spinner"></i></li><li><i class="fas fa-splotch"></i></li><li><i class="fab fa-spotify"></i></li><li><i class="fas fa-spray-can"></i></li><li><i class="fas fa-square"></i></li><li><i class="fas fa-square-full"></i></li><li><i class="fas fa-square-root-alt"></i></li><li><i class="fab fa-squarespace"></i></li><li><i class="fab fa-stack-exchange"></i></li><li><i class="fab fa-stack-overflow"></i></li><li><i class="fab fa-stackpath"></i></li><li><i class="fas fa-stamp"></i></li><li><i class="fas fa-star"></i></li><li><i class="fas fa-star-and-crescent"></i></li><li><i class="fas fa-star-half"></i></li><li><i class="fas fa-star-half-alt"></i></li><li><i class="fas fa-star-of-david"></i></li><li><i class="fas fa-star-of-life"></i></li><li><i class="fab fa-staylinked"></i></li><li><i class="fab fa-steam"></i></li><li><i class="fab fa-steam-square"></i></li><li><i class="fab fa-steam-symbol"></i></li><li><i class="fas fa-step-backward"></i></li><li><i class="fas fa-step-forward"></i></li><li><i class="fas fa-stethoscope"></i></li><li><i class="fab fa-sticker-mule"></i></li><li><i class="fas fa-sticky-note"></i></li><li><i class="fas fa-stop"></i></li><li><i class="fas fa-stop-circle"></i></li><li><i class="fas fa-stopwatch"></i></li><li><i class="fas fa-store"></i></li><li><i class="fas fa-store-alt"></i></li><li><i class="fab fa-strava"></i></li><li><i class="fas fa-stream"></i></li><li><i class="fas fa-street-view"></i></li><li><i class="fas fa-strikethrough"></i></li><li><i class="fab fa-stripe"></i></li><li><i class="fab fa-stripe-s"></i></li><li><i class="fas fa-stroopwafel"></i></li><li><i class="fab fa-studiovinari"></i></li><li><i class="fab fa-stumbleupon"></i></li><li><i class="fab fa-stumbleupon-circle"></i></li><li><i class="fas fa-subscript"></i></li><li><i class="fas fa-subway"></i></li><li><i class="fas fa-suitcase"></i></li><li><i class="fas fa-suitcase-rolling"></i></li><li><i class="fas fa-sun"></i></li><li><i class="fab fa-superpowers"></i></li><li><i class="fas fa-superscript"></i></li><li><i class="fab fa-supple"></i></li><li><i class="fas fa-surprise"></i></li><li><i class="fab fa-suse"></i></li><li><i class="fas fa-swatchbook"></i></li><li><i class="fas fa-swimmer"></i></li><li><i class="fas fa-swimming-pool"></i></li><li><i class="fab fa-symfony"></i></li><li><i class="fas fa-synagogue"></i></li><li><i class="fas fa-sync"></i></li><li><i class="fas fa-sync-alt"></i></li><li><i class="fas fa-syringe"></i></li><li><i class="fas fa-table"></i></li><li><i class="fas fa-table-tennis"></i></li><li><i class="fas fa-tablet"></i></li><li><i class="fas fa-tablet-alt"></i></li><li><i class="fas fa-tablets"></i></li><li><i class="fas fa-tachometer-alt"></i></li><li><i class="fas fa-tag"></i></li><li><i class="fas fa-tags"></i></li><li><i class="fas fa-tape"></i></li><li><i class="fas fa-tasks"></i></li><li><i class="fas fa-taxi"></i></li><li><i class="fab fa-teamspeak"></i></li><li><i class="fas fa-teeth"></i></li><li><i class="fas fa-teeth-open"></i></li><li><i class="fab fa-telegram"></i></li><li><i class="fab fa-telegram-plane"></i></li><li><i class="fas fa-temperature-high"></i></li><li><i class="fas fa-temperature-low"></i></li><li><i class="fab fa-tencent-weibo"></i></li><li><i class="fas fa-tenge"></i></li><li><i class="fas fa-terminal"></i></li><li><i class="fas fa-text-height"></i></li><li><i class="fas fa-text-width"></i></li><li><i class="fas fa-th"></i></li><li><i class="fas fa-th-large"></i></li><li><i class="fas fa-th-list"></i></li><li><i class="fab fa-the-red-yeti"></i></li><li><i class="fas fa-theater-masks"></i></li><li><i class="fab fa-themeco"></i></li><li><i class="fab fa-themeisle"></i></li><li><i class="fas fa-thermometer"></i></li><li><i class="fas fa-thermometer-empty"></i></li><li><i class="fas fa-thermometer-full"></i></li><li><i class="fas fa-thermometer-half"></i></li><li><i class="fas fa-thermometer-quarter"></i></li><li><i class="fas fa-thermometer-three-quarters"></i></li><li><i class="fab fa-think-peaks"></i></li><li><i class="fas fa-thumbs-down"></i></li><li><i class="fas fa-thumbs-up"></i></li><li><i class="fas fa-thumbtack"></i></li><li><i class="fas fa-ticket-alt"></i></li><li><i class="fas fa-times"></i></li><li><i class="fas fa-times-circle"></i></li><li><i class="fas fa-tint"></i></li><li><i class="fas fa-tint-slash"></i></li><li><i class="fas fa-tired"></i></li><li><i class="fas fa-toggle-off"></i></li><li><i class="fas fa-toggle-on"></i></li><li><i class="fas fa-toilet"></i></li><li><i class="fas fa-toilet-paper"></i></li><li><i class="fas fa-toolbox"></i></li><li><i class="fas fa-tools"></i></li><li><i class="fas fa-tooth"></i></li><li><i class="fas fa-torah"></i></li><li><i class="fas fa-torii-gate"></i></li><li><i class="fas fa-tractor"></i></li><li><i class="fab fa-trade-federation"></i></li><li><i class="fas fa-trademark"></i></li><li><i class="fas fa-traffic-light"></i></li><li><i class="fas fa-train"></i></li><li><i class="fas fa-tram"></i></li><li><i class="fas fa-transgender"></i></li><li><i class="fas fa-transgender-alt"></i></li><li><i class="fas fa-trash"></i></li><li><i class="fas fa-trash-alt"></i></li><li><i class="fas fa-trash-restore"></i></li><li><i class="fas fa-trash-restore-alt"></i></li><li><i class="fas fa-tree"></i></li><li><i class="fab fa-trello"></i></li><li><i class="fab fa-tripadvisor"></i></li><li><i class="fas fa-trophy"></i></li><li><i class="fas fa-truck"></i></li><li><i class="fas fa-truck-loading"></i></li><li><i class="fas fa-truck-monster"></i></li><li><i class="fas fa-truck-moving"></i></li><li><i class="fas fa-truck-pickup"></i></li><li><i class="fas fa-tshirt"></i></li><li><i class="fas fa-tty"></i></li><li><i class="fab fa-tumblr"></i></li><li><i class="fab fa-tumblr-square"></i></li><li><i class="fas fa-tv"></i></li><li><i class="fab fa-twitch"></i></li><li><i class="fab fa-twitter"></i></li><li><i class="fab fa-twitter-square"></i></li><li><i class="fab fa-typo3"></i></li><li><i class="fab fa-uber"></i></li><li><i class="fab fa-ubuntu"></i></li><li><i class="fab fa-uikit"></i></li><li><i class="fas fa-umbrella"></i></li><li><i class="fas fa-umbrella-beach"></i></li><li><i class="fas fa-underline"></i></li><li><i class="fas fa-undo"></i></li><li><i class="fas fa-undo-alt"></i></li><li><i class="fab fa-uniregistry"></i></li><li><i class="fas fa-universal-access"></i></li><li><i class="fas fa-university"></i></li><li><i class="fas fa-unlink"></i></li><li><i class="fas fa-unlock"></i></li><li><i class="fas fa-unlock-alt"></i></li><li><i class="fab fa-untappd"></i></li><li><i class="fas fa-upload"></i></li><li><i class="fab fa-ups"></i></li><li><i class="fab fa-usb"></i></li><li><i class="fas fa-user"></i></li><li><i class="fas fa-user-alt"></i></li><li><i class="fas fa-user-alt-slash"></i></li><li><i class="fas fa-user-astronaut"></i></li><li><i class="fas fa-user-check"></i></li><li><i class="fas fa-user-circle"></i></li><li><i class="fas fa-user-clock"></i></li><li><i class="fas fa-user-cog"></i></li><li><i class="fas fa-user-edit"></i></li><li><i class="fas fa-user-friends"></i></li><li><i class="fas fa-user-graduate"></i></li><li><i class="fas fa-user-injured"></i></li><li><i class="fas fa-user-lock"></i></li><li><i class="fas fa-user-md"></i></li><li><i class="fas fa-user-minus"></i></li><li><i class="fas fa-user-ninja"></i></li><li><i class="fas fa-user-nurse"></i></li><li><i class="fas fa-user-plus"></i></li><li><i class="fas fa-user-secret"></i></li><li><i class="fas fa-user-shield"></i></li><li><i class="fas fa-user-slash"></i></li><li><i class="fas fa-user-tag"></i></li><li><i class="fas fa-user-tie"></i></li><li><i class="fas fa-user-times"></i></li><li><i class="fas fa-users"></i></li><li><i class="fas fa-users-cog"></i></li><li><i class="fab fa-usps"></i></li><li><i class="fab fa-ussunnah"></i></li><li><i class="fas fa-utensil-spoon"></i></li><li><i class="fas fa-utensils"></i></li><li><i class="fab fa-vaadin"></i></li><li><i class="fas fa-vector-square"></i></li><li><i class="fas fa-venus"></i></li><li><i class="fas fa-venus-double"></i></li><li><i class="fas fa-venus-mars"></i></li><li><i class="fab fa-viacoin"></i></li><li><i class="fab fa-viadeo"></i></li><li><i class="fab fa-viadeo-square"></i></li><li><i class="fas fa-vial"></i></li><li><i class="fas fa-vials"></i></li><li><i class="fab fa-viber"></i></li><li><i class="fas fa-video"></i></li><li><i class="fas fa-video-slash"></i></li><li><i class="fas fa-vihara"></i></li><li><i class="fab fa-vimeo"></i></li><li><i class="fab fa-vimeo-square"></i></li><li><i class="fab fa-vimeo-v"></i></li><li><i class="fab fa-vine"></i></li><li><i class="fab fa-vk"></i></li><li><i class="fab fa-vnv"></i></li><li><i class="fas fa-voicemail"></i></li><li><i class="fas fa-volleyball-ball"></i></li><li><i class="fas fa-volume-down"></i></li><li><i class="fas fa-volume-mute"></i></li><li><i class="fas fa-volume-off"></i></li><li><i class="fas fa-volume-up"></i></li><li><i class="fas fa-vote-yea"></i></li><li><i class="fas fa-vr-cardboard"></i></li><li><i class="fab fa-vuejs"></i></li><li><i class="fas fa-walking"></i></li><li><i class="fas fa-wallet"></i></li><li><i class="fas fa-warehouse"></i></li><li><i class="fas fa-water"></i></li><li><i class="fas fa-wave-square"></i></li><li><i class="fab fa-waze"></i></li><li><i class="fab fa-weebly"></i></li><li><i class="fab fa-weibo"></i></li><li><i class="fas fa-weight"></i></li><li><i class="fas fa-weight-hanging"></i></li><li><i class="fab fa-weixin"></i></li><li><i class="fab fa-whatsapp"></i></li><li><i class="fab fa-whatsapp-square"></i></li><li><i class="fas fa-wheelchair"></i></li><li><i class="fab fa-whmcs"></i></li><li><i class="fas fa-wifi"></i></li><li><i class="fab fa-wikipedia-w"></i></li><li><i class="fas fa-wind"></i></li><li><i class="fas fa-window-close"></i></li><li><i class="fas fa-window-maximize"></i></li><li><i class="fas fa-window-minimize"></i></li><li><i class="fas fa-window-restore"></i></li><li><i class="fab fa-windows"></i></li><li><i class="fas fa-wine-bottle"></i></li><li><i class="fas fa-wine-glass"></i></li><li><i class="fas fa-wine-glass-alt"></i></li><li><i class="fab fa-wix"></i></li><li><i class="fab fa-wizards-of-the-coast"></i></li><li><i class="fab fa-wolf-pack-battalion"></i></li><li><i class="fas fa-won-sign"></i></li><li><i class="fab fa-wordpress"></i></li><li><i class="fab fa-wordpress-simple"></i></li><li><i class="fab fa-wpbeginner"></i></li><li><i class="fab fa-wpexplorer"></i></li><li><i class="fab fa-wpforms"></i></li><li><i class="fab fa-wpressr"></i></li><li><i class="fas fa-wrench"></i></li><li><i class="fas fa-x-ray"></i></li><li><i class="fab fa-xbox"></i></li><li><i class="fab fa-xing"></i></li><li><i class="fab fa-xing-square"></i></li><li><i class="fab fa-y-combinator"></i></li><li><i class="fab fa-yahoo"></i></li><li><i class="fab fa-yammer"></i></li><li><i class="fab fa-yandex"></i></li><li><i class="fab fa-yandex-international"></i></li><li><i class="fab fa-yarn"></i></li><li><i class="fab fa-yelp"></i></li><li><i class="fas fa-yen-sign"></i></li><li><i class="fas fa-yin-yang"></i></li><li><i class="fab fa-yoast"></i></li><li><i class="fab fa-youtube"></i></li><li><i class="fab fa-youtube-square"></i></li><li><i class="fab fa-zhihu"></i></li></ul><div class="action-buttons"><button class="save-icon">Save</button><button class="close-button">Close</button></div></div></div>');

	var icon_class;

    $('li[id^="customize-control-theme_options-featured_services_icon_"]').click(function() {
    	$('li[id^="customize-control-theme_options-featured_services_icon_"]').removeClass('active');
    	$(this).addClass('active');
	    $('#icons-list-wrapper').addClass('active');
	});

	$('#icons-list-wrapper li').click(function() {
    	icon_class = $(this).find('i').attr('class');
    	$('#icons-list-wrapper li').removeClass('active');
		$(this).addClass('active');
	});

	$('#icons-list-wrapper .save-icon').click(function() {
    	$('#icons-list-wrapper').removeClass('active');
    	$('li[id^="customize-control-theme_options-featured_services_icon_"].active input').val(icon_class).change();
	});

	$('#icons-list-wrapper .close-button').click(function() {
    	$('#icons-list-wrapper').removeClass('active');
    	$('#icons-list-wrapper li').removeClass('active');
    	$('li[id^="customize-control-theme_options-featured_services_icon_"]').removeClass('active');
	});

	$(document).click(function (e) {
        var container = $('.icons-list, li[id^="customize-control-theme_options-featured_services_icon_"] input');
        if (!container.is(e.target) && container.has(e.target).length === 0) {
            $('#icons-list-wrapper').removeClass('active');
	    	$('#icons-list-wrapper li').removeClass('active');
	    	$('li[id^="customize-control-theme_options-featured_services_icon_"]').removeClass('active');
        }
    });

    $(document).keyup(function(e) {
        if (e.keyCode === 27) {
            $('#icons-list-wrapper').removeClass('active');
	    	$('#icons-list-wrapper li').removeClass('active');
	    	$('li[id^="customize-control-theme_options-featured_services_icon_"]').removeClass('active');
        }
    });

});