<?php
$hq_header_banner = get_theme_mod('hq_header_banner', 'frontpage');
?><header class="site-header" role="banner">
    <div class="logo-nav">
        <div class="site-branding">
            <?php
            if (has_custom_logo()) {
                the_custom_logo();
            } elseif ($site_name = get_bloginfo('name')) {
                ?>
                <h1 class="site-title">
                    <a href="<?php echo esc_url(home_url('/')); ?>" title="<?php esc_attr_e('Home', 'marmot-blog'); ?>" rel="home">
                        <?php echo esc_html($site_name); ?>
                    </a>
                </h1>
                <p class="site-description">
                    <?php
                    if ($tagline = get_bloginfo('description', 'display')) {
                        echo esc_html($tagline);
                    }
                    ?>
                </p>
            <?php } ?>
        </div>
        <nav class="site-navigation" role="navigation">
            <?php
            if (has_nav_menu('primary')) {
                wp_nav_menu(array('theme_location' => 'primary', 'menu_class' => 'primary-menu'));
            } else {
                wp_page_menu(
                        array(
                            'before' => '<ul id="menu-primary-items" class="primary-menu">',
                            'after' => '</ul>',
                        )
                );
            }
            ?>
        </nav>
    </div>
    <?php
    if (
            ('frontpage' === $hq_header_banner && is_front_page()) ||
            'entire-site' === $hq_header_banner
    ) {
        $result = wp_get_recent_posts(array(
            'numberposts' => 1,
            'offset' => 0,
            'category' => 0,
            'orderby' => 'post_date',
            'order' => 'DESC',
            'include' => '',
            'exclude' => '',
            'meta_key' => '',
            'meta_value' => '',
            'post_type' => 'post',
            'post_status' => 'publish',
            'suppress_filters' => true,
                ), OBJECT);
        foreach ($result as $p) {

            $author = get_user_by('ID', $p->post_author);
            ?>
            <div class="header-banner">
                <div class="inner">
                    <h1><a href="<?php the_permalink($p) ?>"><?php echo $p->post_title; ?></a></h1>
                    <ul class="meta">
                        <li><a href="<?php echo get_author_posts_url($p->post_author); ?>"><?php echo esc_html($author->display_name); ?></a></li>
                        <li><a href="<?php echo get_day_link(get_post_time('Y', false, $p), get_post_time('m', false, $p), get_post_time('j', false, $p)); ?>"><?php echo get_the_date(null, $p); ?></a></li>
                        <li><?php
                                $comments_count = get_comments_number($p);
                                if ($comments_count < 1) {
                                    echo esc_html_x('No comments', 'header', 'marmot-blog');
                                } elseif ($comments_count == 1) {
                                    echo '1' . esc_html_x(' comment', 'header', 'marmot-blog');
                                } else {
                                    /* translators: %s - comments count */
                                    echo esc_html(sprintf(_x('%s comments', 'header', 'marmot-blog'), $comments_count));
                                }
                                ?></li>
                    </ul>
                    <?php echo get_the_excerpt($p) ?><br>
                    <a href="<?php the_permalink($p) ?>" class="read-more"><?php echo esc_html(get_theme_mod('hq_header_banner_button_text')); ?></a>
                </div>
            </div>
            <?php
        }
        ?> 

        <style type="text/css" rel="header-image">
    <?php
    $url = get_theme_mod('header_image', get_theme_support('custom-header', 'default-image'));
    if ('remove-header' === $url) {
        $url = '';
    }
    if (is_random_header_image()) {
        $url = get_random_header_image();
    }
    ?>
            .site-header .header-banner {
    <?php if ($url) { ?>
                    background-image: url( <?php echo esc_url(set_url_scheme($url)); ?>);
                    background-position: center top;
                    background-repeat: no-repeat;
                    background-size: cover;
    <?php } ?>
            }
        </style>
        <?php
    }
    ?>
</header>
