<?php
/**
 * Add admin Notice When Active Theme, Just Show One Time
 * 
 * @package markito-x
 *
 * @return bool|null
*/
add_action( 'admin_notices', 'markito_x_admin_notice' );

function markito_x_admin_notice() {
	global $current_user;
	$user_id   = $current_user->ID;
	$theme_data  = wp_get_theme();
	if ( !get_user_meta( $user_id, esc_html( $theme_data->get( 'TextDomain' ) ) . '_notice_ignore' ) ) {
		?>
		<div class="notice thunk-notice">

		<h1>
			<?php
			/* translators: %1$s: theme name, %2$s theme version */
			printf( esc_html__( 'Welcome to %1$s - Version %2$s', 'markito-x' ), esc_html( $theme_data->Name ), esc_html( $theme_data->Version ) );
			?>
		</h1>
		<p>
			<?php
			/* translators: %1$s: theme name, %2$s link */
			printf( __( '! Thank You For Choosing %1$s ! <br> To fully take advantage of the best our theme can offer please make sure you visit our <a class="markito_x_theme" href="%2$s">Welcome page</a>', 'markito-x' ), esc_html( $theme_data->Name ), esc_url( admin_url( 'themes.php?page=markito_options' ) ) );
			printf( '<a href="%1$s" class="notice-dismiss dashicons dashicons-dismiss dashicons-dismiss-icon"></a>', '?' . esc_html( $theme_data->get( 'TextDomain' ) ) . '_notice_ignore=0' );
			?>
		</p>
		<p>
			<a href="<?php echo esc_url( admin_url( 'themes.php?page=markito_options' ) ) ?>" class="button button-primary button-hero" style="text-decoration: none;">
			<?php
			/* translators: %s theme name */
			printf( esc_html__( 'Get started with %s', 'markito-x' ), esc_html( $theme_data->Name ) )
			?>
			</a>
		</p>
		</div>
		<?php
	}
}

add_action( 'admin_init', 'markito_x_started_notice_ignore' );
function markito_x_started_notice_ignore() {
	global $current_user;
	$theme_data  = wp_get_theme();
	$user_id   = $current_user->ID;
	/* If user clicks to ignore the notice, add that to their user meta */
	if ( isset( $_GET[ esc_html( $theme_data->get( 'TextDomain' ) ) . '_notice_ignore' ] ) && '0' == $_GET[ esc_html( $theme_data->get( 'TextDomain' ) ) . '_notice_ignore' ] ) {
		add_user_meta( $user_id, esc_html( $theme_data->get( 'TextDomain' ) ) . '_notice_ignore', 'true', true );
	}
}

if (!function_exists('markito_x_admin_enqueue_scripts')) {
    function markito_x_admin_enqueue_scripts(){
      wp_enqueue_style( 'markito_x-admin-css', get_stylesheet_directory_uri() . '/inc/welcome-admin-notice/admin.css' );
    }
}
add_action( 'admin_enqueue_scripts', 'markito_x_admin_enqueue_scripts');