<?php  
    function markito_x_add_sidebar_layout_box(){
        $post_id   = isset( $_GET['post'] ) ? $_GET['post'] : '';
        $template  = get_post_meta( $post_id, '_wp_page_template', true );
        $templates = array( '' ); 
        
        // For Post
        add_meta_box( 
            'markito_x_sidebar_layout',
            __( 'Sidebar Layout', 'markito-x' ),
            'markito_x_sidebar_layout_callback', 
            'post',
            'normal',
            'high'
        );

        if( ! in_array( $template, $templates ) ) {
            // For Pages
            add_meta_box( 
                'markito_x_sidebar_layout',
                __( 'Sidebar Layout', 'markito-x' ),
                'markito_x_sidebar_layout_callback', 
                'page',
                'normal',
                'high'
            );
        }
    }
    add_action( 'add_meta_boxes', 'markito_x_add_sidebar_layout_box' );

    $markito_x_sidebar_layout = array(    
        
        'no-sidebar'     => array(
            'value'     => 'no-sidebar',
            'label'     => __( 'Full Width', 'markito-x' ),
            'thumbnail' => esc_url( get_stylesheet_directory_uri() . '/assets/images/full-width.png' )
        ),
        
        'left-sidebar' => array(
            'value'     => 'left-sidebar',
            'label'     => __( 'Left Sidebar', 'markito-x' ),
            'thumbnail' => esc_url( get_stylesheet_directory_uri() . '/assets/images/left-sidebar.png' )         
        ),
        'right-sidebar' => array(
            'value'     => 'right-sidebar',
            'label'     => __( 'Right Sidebar', 'markito-x' ),
            'thumbnail' => esc_url( get_stylesheet_directory_uri() . '/assets/images/right-sidebar.png' )         
        )    
    );

    function markito_x_sidebar_layout_callback(){
        global $post , $markito_x_sidebar_layout;
        wp_nonce_field( basename( __FILE__ ), 'markito_nonce' ); ?> 
        <table class="form-table">
            <tr>
                <td colspan="4"><em class="f13"><?php esc_html_e( 'Choose Sidebar Template', 'markito-x' ); ?></em></td>
            </tr>
            <tr>
                <td>
                    <?php  
                        foreach( $markito_x_sidebar_layout as $field ){  
                            $layout = get_post_meta( $post->ID, 'markito_x_sidebar_layout', true ); ?>
                            <div class="hide-radio radio-image-wrapper" style="float:left; margin-right:30px;">
                                <input id="<?php echo esc_attr( $field['value'] ); ?>" type="radio" name="markito_x_sidebar_layout" value="<?php echo esc_attr( $field['value'] ); ?>" <?php checked( $field['value'], $layout ); if( empty( $layout ) ){ checked( $field['value'], 'default-sidebar' ); }?>/>
                                <label class="description" for="<?php echo esc_attr( $field['value'] ); ?>">
                                    <img src="<?php echo esc_url( $field['thumbnail'] ); ?>" alt="<?php echo esc_attr( $field['label'] ); ?>" />
                                </label>
                            </div>
                            <?php 
                        } // end foreach 
                    ?>
                    <div class="clear"></div>
                </td>
            </tr>
        </table> 
    <?php 
    }

    function markito_x_save_sidebar_layout( $post_id ){
        global $markito_x_sidebar_layout;

        // Verify the nonce before proceeding.
        if( !isset( $_POST[ 'markito_nonce' ] ) || !wp_verify_nonce( $_POST[ 'markito_nonce' ], basename( __FILE__ ) ) )
            return;
        
        // Stop WP from clearing custom fields on autosave
        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )  
            return;

        if( 'page' == $_POST['post_type'] ){  
            if( ! current_user_can( 'edit_page', $post_id ) ) return $post_id;  
        }elseif( ! current_user_can( 'edit_post', $post_id ) ){  
            return $post_id;  
        }

        $layout = isset( $_POST['markito_x_sidebar_layout'] ) ? sanitize_key( $_POST['markito_x_sidebar_layout'] ) : 'default-sidebar';

        if( array_key_exists( $layout, $markito_x_sidebar_layout ) ){
            update_post_meta( $post_id, 'markito_x_sidebar_layout', $layout );
        }else{
            delete_post_meta( $post_id, 'markito_x_sidebar_layout' );
        }
    }
    add_action( 'save_post' , 'markito_x_save_sidebar_layout' );

    //Save meta box content.

    // @param int $post_id Post ID
    
    function markito_x_Wp_Blog_Post_Sidebar_Type_Save_Value_Function( $post_id ) {
        // Save logic goes here. Don't forget to include nonce checks!

        global $post;
    
        if(isset($_POST["project_font_icon"])):
            
            update_post_meta($post->ID, 'Project_Select_Option_Font_Icon_Meta_Key_Value', $_POST["project_font_icon"]);
        
        endif;
    } 
    add_action( 'save_post', 'markito_x_Wp_Blog_Post_Sidebar_Type_Save_Value_Function' );  