<?php
    function markito_x_sanitize_checkbox_function( $checked ) {
        // Boolean check.
        return ( ( isset( $checked ) && true == $checked ) ? true : false );
    }

    function markito_x_customize_register( $wp_customize ) {

        $font_choices = array(
            'Source Sans Pro' => 'Source Sans Pro',
            'Open Sans' => 'Open Sans',
            'Oswald' => 'Oswald',
            'Playfair Display' => 'Playfair Display',
            'Montserrat' => 'Montserrat',
            'Raleway' => 'Raleway',
            'Droid Sans' => 'Droid Sans',
            'Lato' => 'Lato',
            'Arvo' => 'Arvo',
            'Lora' => 'Lora',
            'Merriweather' => 'Merriweather',
            'Oxygen' => 'Oxygen',
            'PT Serif' => 'PT Serif',
            'PT Sans' => 'PT Sans',
            'PT Sans Narrow' => 'PT Sans Narrow',
            'Cabin' => 'Cabin',
            'Fjalla One',
            'Francois One',
            'Josefin Sans' => 'Josefin Sans',
            'Libre Baskerville' => 'Libre Baskerville',
            'Arimo' => 'Arimo',
            'Ubuntu' => 'Ubuntu',
            'Bitter' => 'Bitter',
            'Droid Serif' => 'Droid Serif',
            'Roboto' => 'Roboto',
            'Open Sans Condensed' => 'Open Sans Condensed',
            'Roboto Condensed' => 'Roboto Condensed',
            'Roboto Slab' => 'Roboto Slab',
            'Yanone Kaffeesatz' => 'Yanone Kaffeesatz',
            'Rokkitt' => 'Rokkitt',
                
        );
        
        $wp_customize->add_section(
            'font_section',
                array(
                    'title' => __( 'Font Section', 'markito-x' ),
                    'description' => __('Here you can add font family','markito-x'),
                    'capability'=>'edit_theme_options',
                    'priority' => 5,
            )
        );
            
        $wp_customize->add_setting('markito_x_show_Google_Fonts',
            array(
                'sanitize_callback' => 'markito_x_sanitize_checkbox_function',
                'default'           => 0,
            )
         );

        $wp_customize->add_control('markito_x_show_Google_Fonts',
            array(
                'type'        => 'checkbox',
                'label'       => esc_html__('Enable Fonts', 'markito-x'),
                'section'     => 'font_section',
                'description' => esc_html__('Check this box to Enable Custom Fonts', 'markito-x'),
            )
        );

        $wp_customize->add_setting( 'font_family', 
            array(
                'default' =>'',
                'sanitize_callback' => 'markito_x_Theme_Fonts_Sanitize_Text_Function',
            )
        );

        $wp_customize->add_control( 'font_family',
            array(
                'type' => 'select',
                'label' => __('Select your desired font family for heading','markito-x'),
                'section' => 'font_section',
                'choices' => $font_choices
            )
        );

        $wp_customize->add_setting( 'font_family2', 
           array(
                'default' =>'',
                'sanitize_callback' => 'markito_x_Theme_Fonts_Sanitize_Text_Function',
            )
        );

        $wp_customize->add_control( 'font_family2', 
            array(
                    'type' => 'select',
                    'label' => __('Select your desired font family for body','markito-x'),
                    'section' => 'font_section',
                    'choices' => $font_choices
            )
        );

        // markito x Theme Sanitize Function
        function markito_x_Theme_Fonts_Sanitize_Text_Function( $text ) {
            return sanitize_text_field( $text );
        }

    }
    add_action( 'customize_register', 'markito_x_customize_register' );

    function markito_x_scripts() {
        $headings_font = esc_html(get_theme_mod('font_family'));
        $body_font = esc_html(get_theme_mod('font_family2'));

        if( $headings_font ) {
            wp_enqueue_style( 'markito-x-headings-fonts', '//fonts.googleapis.com/css?family='. $headings_font );
        } else {
            wp_enqueue_style( 'markito-x-source-sans', '//fonts.googleapis.com/css?family=Lato:400,700,400italic,700italic');
        }
        if( $body_font ) {
            wp_enqueue_style( 'markito-x-body-fonts', '//fonts.googleapis.com/css?family='. $body_font );
        } else {
            wp_enqueue_style( 'markito-x-source-body', '//fonts.googleapis.com/css?family=Source+Sans+Pro:400,300,400italic,700,600');
        }
    }
    add_action( 'wp_enqueue_scripts', 'markito_x_scripts' );