<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package markito-x
*/
?>
<style>
.w_footer {
    padding: 70px 0;
    background: #fcd3d1;
}

.widget-heading {
    padding: 30px 15px;
}

.widget-heading h1 {
    border-bottom: 2px solid #f05036;
    display: inline-block;
    font-size: 24px;
    padding: 5px 5px 5px 0;
    color: #212121;
}

#calendar_wrap {
    padding: 10px;
}

table.table, table {
    width: 100%;
    text-align: left;
    background-color: transparent;
}

#wp-calendar caption {
    padding: 10px;
    color: #fff;
    text-align: center;
    font-size: 16px;
    font-weight: 700;
    background-color: #f05036;
}

.footer-widget #wp-calendar thead tr th, .footer-widget table td {
    color: #f05036;
}

#wp-calendar thead tr th, #wp-calendar tbody tr td {
    text-align: center;
    color: #212121;
}

table th, table td {
    border: 1px solid #f05036;
    padding: 6px;
    line-height: 20px;
    text-align: center;
    vertical-align: top;
}

.footer-widget ul {
    list-style: none;
    padding-left: 20px;
    margin: 0;
}

.footer-widget ul li {
    display: block;
}

.footer-widget ul li a {
    color: #212121;
    font-size: 16px;
}

.wp-block-latest-posts.wp-block-latest-posts__list {
    list-style: none;
}
</style>
   <!---Start-Footer-Section-->
  <?php 
$markito_footer_areas = get_theme_mod('markito_footer_areas', '1'); 
if ($markito_footer_areas == '1') : ?>
    <!-- Start Footer Section -->
    <footer class="w_footer">
        <div class="container">
            <div class="row">
                <!-- Footer Sidebar 1 -->
                <div class="col-lg-6">
                    <?php 
                        // Define footer widget area outside of conditionals
                        $footer_widget = array(
                            'name' => __( 'Footer Widget Area', 'markito' ),
                            'id' => 'footer-sidebar',
                            'description' => __( 'Footer Widget Area', 'markito' ),
                            'before_widget' => '<div class="col-md-12 col-sm-12 footer-widget">',
                            'after_widget' => '</div>',
                            'before_title' => '<div class="col-md-12 widget-heading"><h1>',
                            'after_title' => '</h1></div>'
                        );

                        if ( is_active_sidebar( 'footer-sidebar' ) ) :
                            dynamic_sidebar( 'footer-sidebar' );
                        else:
                            // Fallback widgets for the first sidebar
                            the_widget('WP_Widget_Calendar', 'title=' . __('Calendar', 'markito'), $footer_widget);
                            the_widget('WP_Widget_Recent_Posts', null, $footer_widget);
                        endif; 
                    ?>
                </div>

                <!-- Footer Sidebar 2 -->
                <div class="col-lg-6">
                    <?php 
                        if ( is_active_sidebar( 'footer-sidebar-two' ) ) :
                            dynamic_sidebar( 'footer-sidebar-two' );
                        else:
                            // Fallback widgets for the second sidebar
                            the_widget('WP_Widget_Pages', null, $footer_widget);
                            the_widget('WP_Widget_Archives', null, $footer_widget);
                        endif; 
                    ?>
                </div>
            </div>
        </div>
    </footer>
<?php endif; ?>
            <div class="container">
               <div class="row justify-content-center">
                  <div class="container-fluid">
                     <div class="copy-right">
                        <span class="copy-right-seprater"></span> <br> 
                        <?php esc_html_e("Proudly Powered by" ,'markito-x'); ?> 
                           <a href="<?php echo esc_url( __( 'https://wordpress.org/', 'markito-x' ) ); ?>" target="_black">
                              <?php echo esc_html__( 'WordPress', 'markito-x' ); ?>
                           </a>
                        <span class="sep"> | </span>
                        <?php if( get_theme_mod( 'markito_Developed_By_Text_Settings' ) ) :
                                    echo esc_html(get_theme_mod( 'markito_Developed_By_Text_Settings' ));
                                 else :
                                    esc_html_e('Theme By Markito' , 'markito-x');  
                              endif;
                        ?>
                        <a href="<?php if( get_theme_mod( 'markito_Footer_developed_by_Link_Settings' ) ) :
                                 echo esc_url(get_theme_mod( "markito_Footer_developed_by_Link_Settings" ));
                              else :
                                 echo esc_url("http://infigosoftware.in/");  
                              endif;
                         ?>" target="_black"> 
                        <?php if( get_theme_mod( 'markito_Footer_developed_by_Link_Text_Settings' ) ) :
                                    echo esc_html(get_theme_mod( 'markito_Footer_developed_by_Link_Text_Settings' ));
                                 else :
                                    esc_html_e('Infigo Software' , 'markito-x');  
                              endif;
                        ?> </a>
                       <br> 
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div> 
   
</div><!-- #page -->

<?php $markito_x_Back_To_Top_Button_background = get_theme_mod('markito_x_Back_To_Top_Button_background');
if( !empty($markito_x_Back_To_Top_Button_background) ) : ?>

   <style>
      #btn-to-top {
         display: inline-block;
         width: 40px;
         height: 40px;
         background-color: <?php echo $markito_x_Back_To_Top_Button_background; ?> !important;
         text-align: center;
         position: fixed;
         bottom: 90px;
         right: 35px;
         opacity: 0;
         visibility: hidden;
         z-index: 999;
         transform: scale(1.1,1.1);
         transition: all 0.5s ease;
      }
   </style>    
                
<?php endif; ?>

<?php $markito_x_Back_To_Top_Button_color_background = get_theme_mod('markito_x_Back_To_Top_Button_color_background');
   if( !empty($markito_x_Back_To_Top_Button_color_background) ) : ?>

      <style>

         a#btn-to-top i {
            font-size: 20px;
            color: <?php echo $markito_x_Back_To_Top_Button_color_background; ?> !important;
            line-height: 2.1;
         }

      </style>    
                
<?php endif; ?>

<?php 
$markito_x_Back_To_Top_Location_Button = get_theme_mod('markito_x_Back_To_Top_Location_Button', 'Right'); 
if( $markito_x_Back_To_Top_Location_Button === "Left" ) :
   ?>

   <style>
   #btn-to-top.show {
      opacity: 1;
      visibility: visible;
      left: 10%;
      position: fixed;
   }
   </style>  

   <?php

endif;
?>                  

<!--- scroll-to-top -->
<?php $markito_x_Back_To_Top_Section_Visibility = get_theme_mod( 'markito_x_Back_To_Top_Section_Visibility' ,1 );
if( $markito_x_Back_To_Top_Section_Visibility ) : ?>
   <a href="#" id="btn-to-top"><i class="fas fa-arrow-up"></i></a>
<?php endif; ?>

<?php get_template_part('custom','font'); ?>
<?php wp_footer(); ?>
</body>
</html>