<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if( !class_exists( 'Marketr_Welcome' ) ) {

	class Marketr_Welcome {
		public $marketr_theme_fields;

		public function __construct( $marketr_fields = array() ) {
			$this->marketr_theme_fields = $marketr_fields;
			add_action ('admin_init' , array( $this, 'admin_scripts' ) );
			add_action('admin_menu', array( $this, 'marketr_themeinfo_page_menu' ));
		}

		public function admin_scripts() {
			global $pagenow;
			$marketr_file_dir = get_template_directory_uri() . '/themeinfo/assets/';

			if ( $pagenow === 'themes.php' && isset($_GET['page']) && $_GET['page'] === 'marketr-themeinfo-page' ) {

				wp_enqueue_style (
					'marketr-themeinfo-page-style',
					$marketr_file_dir . 'marketr_themeinfo_page.css',
					array(), '1.0.0'
				);

				wp_enqueue_script (
					'marketr-themeinfo-page-functions',
					$marketr_file_dir . 'marketr_themeinfo_page.js',
					array('jquery'),
					'1.0.0',
					true
				);
			}
		}

        public function marketr_theme_info($marketr_id, $marketr_screenshot = false) {
            $marketr_themedata = wp_get_theme();
            return ($marketr_screenshot === true) ? esc_url($marketr_themedata->get_screenshot()) : esc_html($marketr_themedata->get($marketr_id));
        }

        public function marketr_themeinfo_page_menu() {
            add_theme_page(
                /* translators: 1: Theme Name. */
                sprintf(esc_html__('%1$s Info', 'marketr'), $this->marketr_theme_info('Name')),
                sprintf(esc_html__('%1$s Info', 'marketr'), $this->marketr_theme_info('Name')),
                'edit_theme_options',
                'marketr-themeinfo-page',
                array( $this, 'marketr_themeinfo_page' )
            );
		}

        public function marketr_themeinfo_page() {
            // Define tabs with proper escaping and prefixes
            $marketr_tabs = array(
                'marketr_home'      => esc_html__('Home', 'marketr'),
                'marketr_free_pro'  => esc_html__('Free VS Pro', 'marketr'),
                'marketr_faqs'      => esc_html__('FAQs', 'marketr'),
                'marketr_support'   => esc_html__('Free Theme Supports', 'marketr'),
                'marketr_review'    => esc_html__('Please Rate Us', 'marketr'),
                'marketr_free_demo_content'    => esc_html__('Click Here For Free Demo Content', 'marketr'),
            );
            ?>
            <div class="wrap about-wrap access-wrap">
        
                <div class="abt-promo-wrap clearfix">
                    <div class="abt-theme-wrap">
                        <h1>
                            <?php
                                printf(
                                    /* translators: 1: Theme Name. */
                                    esc_html__('%1$s - Version %2$s', 'marketr'),
                                    esc_html($this->marketr_theme_info('Name')),
                                    esc_html($this->marketr_theme_info('Version'))
                                );
                            ?>
                        </h1>
                        <div class="doc-links">
                            <h4><?php echo esc_html__('Visit Sites :-', 'marketr'); ?></h4>
                            <a href="<?php echo esc_url(MARKETR_BUY_NOW); ?>" target="_blank">
                                <span class="dashicons dashicons-admin-site-alt3"></span>
                                <span class="theme-pixel-tooltip"><?php echo esc_html__('View Website', 'marketr'); ?></span>
                            </a>
                            <a href="<?php echo esc_url(MARKETR_LIVE_DEMO); ?>" target="_blank">
                                <span class="dashicons dashicons-desktop"></span>
                                <span class="theme-pixel-tooltip"><?php echo esc_html__('View Demo Site', 'marketr'); ?></span>
                            </a>
                            <a href="<?php echo esc_url(MARKETR_THEME_SUPPORT); ?>" target="_blank">
                                <span class="dashicons dashicons-megaphone"></span>
                                <span class="theme-pixel-tooltip"><?php echo esc_html__('Contact Support', 'marketr'); ?></span>
                            </a>
                            <a href="<?php echo esc_url(MARKETR_FREE_DOC); ?>" target="_blank">
                                <span class="dashicons dashicons-pdf"></span>
                                <span class="theme-pixel-tooltip"><?php echo esc_html__('Documentation', 'marketr'); ?></span>
                            </a>
                        </div>
                    </div>
                </div>
        
                <div class="test">
                    <div class="nav-tab-wrapper clearfix">
                        <?php
                        $tabHTML = '';
        
                        foreach ($marketr_tabs as $marketr_id => $marketr_label) :
        
                            $marketr_target = '';
                            $marketr_nav_class = 'nav-tab';
                            $marketr_section = isset($_GET['section']) ? sanitize_text_field($_GET['section']) : 'marketr_home';
        
                            if ($marketr_id === $marketr_section) {
                                $marketr_nav_class .= ' nav-tab-active';
                            }
        
                            if ($marketr_id === 'marketr_free_pro') {
                                $marketr_nav_class .= ' upgrade-button';
                            }

                            if ($marketr_id === 'marketr_review') {
                                $marketr_nav_class .= ' review-button';
                            }

                            if ($marketr_id === 'marketr_free_demo_content') {
                                $marketr_nav_class .= ' demo-content-button';
                            }
        
                            switch ($marketr_id) {
        
                                case 'marketr_support':
                                    $marketr_target = 'target="_blank"';
                                    $marketr_url = esc_url('https://wordpress.org/support/theme/' . esc_html($this->marketr_theme_info('TextDomain')));
                                break;
        
                                case 'marketr_review':
                                    $marketr_target = 'target="_blank"';
                                    $marketr_url = esc_url('https://wordpress.org/support/theme/' . esc_html($this->marketr_theme_info('TextDomain')) . '/reviews/#new-post');
                                break;

                                case 'marketr_free_demo_content':
                                $marketr_target = 'target="_blank"';
                                $marketr_url = esc_url(admin_url('themes.php?page=marketr-freedemocontent'));
                                break;
                                
                                
                                case 'marketr_home':
                                    $marketr_url = esc_url(admin_url('themes.php?page=marketr-themeinfo-page'));
                                break;
        
                                default:
                                    $marketr_url = esc_url(admin_url('themes.php?page=marketr-themeinfo-page&section=' . esc_attr($marketr_id)));
                                break;
        
                            }
        
                            $tabHTML .= '<a ';
                            $tabHTML .= $marketr_target;
                            $tabHTML .= ' href="' . esc_url($marketr_url) . '"';
                            $tabHTML .= ' class="' . esc_attr($marketr_nav_class) . '"';
                            $tabHTML .= '>';

                            if ($marketr_id === 'marketr_free_demo_content') {
                                $tabHTML .= '<span>' . esc_html($marketr_label) . '</span>';
                            } else {
                                $tabHTML .= esc_html($marketr_label);
                            }

                            if ($marketr_id === 'marketr_review') {
                                $tabHTML .= ' <span class="dashicons dashicons-star-filled"></span>';
                                $tabHTML .= ' <span class="dashicons dashicons-star-filled"></span>';
                                $tabHTML .= ' <span class="dashicons dashicons-star-filled"></span>';
                                $tabHTML .= ' <span class="dashicons dashicons-star-filled"></span>';
                                $tabHTML .= ' <span class="dashicons dashicons-star-filled"></span>';
                            }

                            $tabHTML .= '</a>';
        
                        endforeach;
        
                        echo $tabHTML;
                        ?>
        
                        <div class="get-pro">
                            <h3><?php echo esc_html__('Marketr Pro', 'marketr'); ?></h3>
                            <p><?php echo esc_html__('Get all of the features that are infinite!!!', 'marketr'); ?></p>
                            <a class="theme-pixel-button-btn primary-btn" target="_blank" href="<?php echo esc_url(MARKETR_BUY_NOW); ?>"><?php echo esc_html__('Upgrade To Pro', 'marketr'); ?></a>
                        </div>
                    </div>

                    <div class="second-div">
                        <div class="themeinfo-section-wrapper">
                            <div class="themeinfo-section marketr_home clearfix">
                                <?php
                                $marketr_section = isset($_GET['section']) ? sanitize_text_field($_GET['section']) : 'marketr_home';
                                switch ($marketr_section) {
            
                                    case 'marketr_free_pro':
                                        $this->marketr_free_pro();
                                    break;
            
                                    case 'marketr_faqs':
                                        $this->marketr_faqs();
                                    break;
            
                                    case 'marketr_home':
                                    default:
                                        $this->marketr_home();
                                    break;
            
                                }
                                ?>
                            </div>
                        </div>
            
                        <div class="theme-steps-list">

                            <div class="theme-steps highlight">
                                <h3><?php echo esc_html__('Buy Marketr Pro', 'marketr'); ?></h3>
                                <p><?php echo esc_html__('To get limitless features and improvements, buy the Marketr Theme Pro edition.', 'marketr'); ?></p>
                                <a target="_blank" class="button button-primary" href="<?php echo esc_url(MARKETR_BUY_NOW); ?>"><?php echo esc_html__('Buy Pro Theme', 'marketr'); ?></a>
                            </div>

                            <div class="theme-steps">
                                <h3><?php echo esc_html__('Documentation', 'marketr'); ?></h3>
                                <p><?php echo esc_html__('Do you need additional information? You may find detailed instructions on how to use the Marketr Theme in our extensive documentation.', 'marketr'); ?></p>
                                <a target="_blank" class="button button-primary" href="<?php echo esc_url(MARKETR_FREE_DOC); ?>"><?php echo esc_html__('Go to Free Docs', 'marketr'); ?></a>
                            </div>
            
                            <div class="theme-steps">
                                <h3><?php echo esc_html__('Preview Pro Theme', 'marketr'); ?></h3>
                                <p><?php echo esc_html__('Explore our Pro Themes full potential! To see the stunning designs and high-end functionality, click the Live Demo button.', 'marketr'); ?></p>
                                <a target="_blank" class="button button-primary" href="<?php echo esc_url(MARKETR_LIVE_DEMO); ?>"><?php echo esc_html__('View Live Demo', 'marketr'); ?></a>
                            </div>
            
                            <div class="theme-steps highlight">
                                <h3><?php echo esc_html__('Get the Bundle', 'marketr'); ?></h3>
                                <p><?php echo esc_html__('Introducing the WP Theme Bundle by Theme Pixel, a comprehensive collection of over 50 professionally designed WordPress themes tailored for various niches and businesses.', 'marketr'); ?></p>
                                <a target="_blank" class="button button-primary" href="<?php echo esc_url(MARKETR_BUNDLE); ?>"><?php echo esc_html__('Get All Themes', 'marketr'); ?></a>
                            </div>
            
                        </div>
                    </div>
                </div>
        
            </div>
            <?php
        }

        public function marketr_home() {
            ?>
            <div class="theme-info-top-wrap clearfix">
                <h3><?php esc_html_e( 'HOME', 'marketr' ); ?></h3>
                <div class="theme-details">
                    <div class="theme-screenshot">
                        <img src="<?php echo esc_url( $this->marketr_theme_info( 'Screenshot', true ) ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'marketr' ); ?>" />
                    </div>
                    <div class="about-text"><?php echo esc_html( $this->marketr_theme_info( 'Description' ) ); ?></div>
                    <div class="clearfix"></div>
                </div>
                <div class="theme-pixel-settings">
                    <h2><?php esc_html_e( 'Quick Customizer Settings', 'marketr' ); ?></h2>
                    <div class="theme-pixel-button">
                        <a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" class="theme-pixel-btn" target="_blank">
                            <?php esc_html_e( 'Go To Customizer', 'marketr' ); ?> <span class="dashicons dashicons-arrow-right-alt"></span>
                        </a>
                    </div>
                </div>
                <div class="theme-pixel-card customizer three-col">
                    <div class="theme-pixel-cardbody">
                        <div class="icon-box">
                            <span class="dashicons dashicons-admin-site-alt3"></span>
                        </div>
                        <div class="theme-pixel-text-wrap">
                            <h3 class="theme-pixel-heading"><?php esc_html_e( 'Site Identity', 'marketr' ); ?></h3>
                            <div class="theme-pixel-button">
                                <a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php?autofocus%5Bcontrol%5D=site_identity' ) ); ?>" class="theme-pixel-btn">
                                    <?php esc_html_e( 'Customize', 'marketr' ); ?>
                                    <span class="dashicons dashicons-arrow-right-alt"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="theme-pixel-cardbody">
                        <div class="icon-box">
                            <span class="dashicons dashicons-color-picker"></span>
                        </div>
                        <div class="theme-pixel-text-wrap">
                            <h3 class="theme-pixel-heading"><?php esc_html_e( 'Color Settings', 'marketr' ); ?></h3>
                            <div class="theme-pixel-button">
                                <a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php?autofocus%5Bsection%5D=colors' ) ); ?>" class="theme-pixel-btn">
                                    <?php esc_html_e( 'Customize', 'marketr' ); ?>
                                    <span class="dashicons dashicons-arrow-right-alt"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="theme-pixel-cardbody">
                        <div class="icon-box">
                            <span class="dashicons dashicons-screenoptions"></span>
                        </div>
                        <div class="theme-pixel-text-wrap">
                            <h3 class="theme-pixel-heading"><?php esc_html_e( 'Layout Settings', 'marketr' ); ?></h3>
                            <div class="theme-pixel-button">
                                <a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php?autofocus%5Bpanel%5D=layout_settings' ) ); ?>" class="theme-pixel-btn">
                                    <?php esc_html_e( 'Customize', 'marketr' ); ?>
                                    <span class="dashicons dashicons-arrow-right-alt"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="theme-pixel-cardbody">
                        <div class="icon-box">
                            <span class="dashicons dashicons-format-image"></span>
                        </div>
                        <div class="theme-pixel-text-wrap">
                            <h3 class="theme-pixel-heading"><?php esc_html_e( 'General Settings', 'marketr' ); ?></h3>
                            <div class="theme-pixel-button">
                                <a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php?autofocus%5Bpanel%5D=banner_option' ) ); ?>" class="theme-pixel-btn">
                                    <?php esc_html_e( 'Customize', 'marketr' ); ?>
                                    <span class="dashicons dashicons-arrow-right-alt"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="theme-pixel-cardbody">
                        <div class="icon-box">
                            <span class="dashicons dashicons-align-full-width"></span>
                        </div>
                        <div class="theme-pixel-text-wrap">
                            <h3 class="theme-pixel-heading"><?php esc_html_e( 'Frontpage Settings', 'marketr' ); ?></h3>
                            <div class="theme-pixel-button">
                                <a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php?autofocus%5Bpanel%5D=general_settings' ) ); ?>" class="theme-pixel-btn">
                                    <?php esc_html_e( 'Customize', 'marketr' ); ?>
                                    <span class="dashicons dashicons-arrow-right-alt"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="theme-pixel-cardbody">
                        <div class="icon-box">
                            <span class="dashicons dashicons-admin-page"></span>
                        </div>
                        <div class="theme-pixel-text-wrap">
                            <h3 class="theme-pixel-heading"><?php esc_html_e( 'Footer Settings', 'marketr' ); ?></h3>
                            <div class="theme-pixel-button">
                                <a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php?autofocus%5Bsection%5D=footer_option' ) ); ?>" class="theme-pixel-btn">
                                    <?php esc_html_e( 'Customize', 'marketr' ); ?>
                                    <span class="dashicons dashicons-arrow-right-alt"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }        

		public function marketr_free_pro() {
            ?>
            <h3><?php esc_html_e( 'FREE VS PRO', 'marketr' ); ?></h3>
            <div class="freeandpro">
                <table class="card table free-pro" cellspacing="0" cellpadding="0">
                    <tbody class="table-body">
                        <tr class="table-head">
                            <th class="large"><?php echo esc_html__( 'Features', 'marketr' ); ?></th>
                            <th class="indicator"><?php echo esc_html__( 'Free theme', 'marketr' ); ?></th>
                            <th class="indicator"><?php echo esc_html__( 'Pro Theme', 'marketr' ); ?></th>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Responsive Design', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Site Logo upload', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Footer Copyright text', 'marketr' ); ?></h4>
                                    <div class="feature-inline-row">
                                        <span class="info-icon dashicon dashicons dashicons-info"></span>
                                        <span class="feature-description">
                                            <?php echo esc_html__( 'Remove the copyright text from the Footer.', 'marketr' ); ?>
                                        </span>
                                    </div>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Easy Customization', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Lightweight & Fast Loading', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Global Color', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-no-alt" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Regular Bug Fixes', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>
                        
                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Premium Support', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Theme Sections', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="abc"><?php echo esc_html__( '2 Sections', 'marketr' ); ?></span></td>
                            <td class="indicator"><span class="abc"><?php echo esc_html__( '15+ Sections', 'marketr' ); ?></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Custom colors', 'marketr' ); ?></h4>
                                    <div class="feature-inline-row">
                                        <span class="info-icon dashicon dashicons dashicons-info"></span>
                                        <span class="feature-description">
                                            <?php echo esc_html__( 'Choose a color for links, buttons, icons and so on.', 'marketr' ); ?>
                                        </span>
                                    </div>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-no-alt" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Google fonts', 'marketr' ); ?></h4>
                                    <div class="feature-inline-row">
                                        <span class="info-icon dashicon dashicons dashicons-info"></span>
                                        <span class="feature-description">
                                            <?php echo esc_html__( 'You can choose and use over 600 different fonts, for the logo, the menu and the titles.', 'marketr' ); ?>
                                        </span>
                                    </div>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-no-alt" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Compatible with Popular Plugins', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-no-alt" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Translation & WPML Ready', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-no-alt" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'SEO Optimized', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-no-alt" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Premium Support', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-no-alt" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Extensive Customization', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-no-alt" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'Custom Post Types', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-no-alt" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>

                        <tr class="feature-row">
                            <td class="large">
                                <div class="feature-wrap">
                                    <h4><?php echo esc_html__( 'High-Level Compatibility with Modern Browsers', 'marketr' ); ?></h4>
                                </div>
                            </td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-no-alt" size="30"></span></td>
                            <td class="indicator"><span class="dashicon dashicons dashicons-yes" size="30"></span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <?php
        }

        public function marketr_faqs() {
            ?>
            <h3><?php esc_html_e( 'FAQs', 'marketr' ); ?></h3>
            <div class="faq-container">
                <div class="accordion" id="MarketrFaqAccordion">
                    <!-- FAQ 1 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="MarketrHeadingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#MarketrCollapseOne" aria-expanded="true" aria-controls="MarketrCollapseOne">
                                <?php echo esc_html__('What is the difference between Free and Pro?', 'marketr'); ?>
                            </button>
                        </h2>
                        <div id="MarketrCollapseOne" class="accordion-collapse collapse show" aria-labelledby="MarketrHeadingOne" data-bs-parent="#MarketrFaqAccordion">
                            <div class="accordion-body">
                                <p>
                                    <?php echo esc_html__('The themes are well-made in both their free and premium versions. But there are a lot more features in the Pro edition.', 'marketr'); ?>
                                </p>
                                <p>
                                    <?php echo esc_html__('You may quickly alter the appearance and feel of your website with the Pro version. You can alter your websites color and typeface with a few clicks. With more customization choices, the premium version gives you greater control over the theme. In addition, the theme offers more layout options and sections than the free version.', 'marketr'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    <!-- FAQ 2 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="MarketrHeadingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#MarketrCollapseTwo" aria-expanded="false" aria-controls="MarketrCollapseTwo">
                                <?php echo esc_html__('What are the advantages of upgrading to the Premium version?', 'marketr'); ?>
                            </button>
                        </h2>
                        <div id="MarketrCollapseTwo" class="accordion-collapse collapse" aria-labelledby="MarketrHeadingTwo" data-bs-parent="#MarketrFaqAccordion">
                            <div class="accordion-body">
                                <p>
                                    <?php echo esc_html__('In addition to the additional features and regular upgrades, the Premium version comes with premium support. Compared to the free assistance, you will receive a much faster response if you encounter any theme problems.', 'marketr'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    <!-- FAQ 3 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="MarketrHeadingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#MarketrCollapseThree" aria-expanded="false" aria-controls="MarketrCollapseThree">
                                <?php echo esc_html__('Upgrading to the Pro version- will I lose my changes?', 'marketr'); ?>
                            </button>
                        </h2>
                        <div id="MarketrCollapseThree" class="accordion-collapse collapse" aria-labelledby="MarketrHeadingThree" data-bs-parent="#MarketrFaqAccordion">
                            <div class="accordion-body">
                                <p>
                                    <?php echo esc_html__('Your posts, pages, media, categories, and other data will all be preserved when you upgrade to the Pro theme.', 'marketr'); ?>
                                </p>
                                <p>
                                    <?php echo esc_html__('You will need to configure the extra features via the customizer, though, because the Pro edition has more features and options. It just takes a few minutes to complete this easy process.', 'marketr'); ?>
                                </p>
                                <p>
                                    <?php echo esc_html__('There is a lot of flexibility in the Pro version to accommodate future updates. As a result, it differs slightly from the free theme yet is incredibly versatile and user-friendly.', 'marketr'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    <!-- FAQ 4 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="MarketrHeadingFour">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#MarketrCollapseFour" aria-expanded="false" aria-controls="MarketrCollapseFour">
                                <?php echo esc_html__('How do I change the copyright text?', 'marketr'); ?>
                            </button>
                        </h2>
                        <div id="MarketrCollapseFour" class="accordion-collapse collapse" aria-labelledby="MarketrHeadingFour" data-bs-parent="#MarketrFaqAccordion">
                            <div class="accordion-body">
                                <p>
                                    <?php echo esc_html__('You can change the copyright text going to Appearance > Customize > Footer Option > And here you can find (Edit Footer Copyright Text)', 'marketr'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    <!-- FAQ 5 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="MarketrHeadingFour">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#MarketrCollapseFour" aria-expanded="false" aria-controls="MarketrCollapseFour">
                                <?php echo esc_html__('Why is my theme not working well?', 'marketr'); ?>
                            </button>
                        </h2>
                        <div id="MarketrCollapseFour" class="accordion-collapse collapse" aria-labelledby="MarketrHeadingFour" data-bs-parent="#MarketrFaqAccordion">
                            <div class="accordion-body">
                                <p>
                                    <?php echo esc_html__('It could be a plugin conflict if your customizer is not loading correctly or if you are experiencing problems with the theme.', 'marketr'); ?>
                                </p>
                                <p>
                                    <?php echo esc_html__('Deactivate every plugin first, with the exception of those the theme suggests, to resolve the problem. After that, use "Ctrl+Shift+R" on Windows to force a new page load. Once the problems have been resolved, begin turning on each plugin individually, then refresh and verify your website each time. This will assist you in identifying the problematic plugin.', 'marketr'); ?>
                                </p>
                                <p>
                                    <?php echo esc_html__('Please get in touch with us if this was not helpful.', 'marketr'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    <!-- FAQ 5 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="MarketrHeadingFour">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#MarketrCollapseFour" aria-expanded="false" aria-controls="MarketrCollapseFour">
                                <?php echo esc_html__('How can I solve my issues quickly and get faster support?', 'marketr'); ?>
                            </button>
                        </h2>
                        <div id="MarketrCollapseFour" class="accordion-collapse collapse" aria-labelledby="MarketrHeadingFour" data-bs-parent="#MarketrFaqAccordion">
                            <div class="accordion-body">
                                <p>
                                    <?php echo esc_html__('Please make sure you have updated the theme to the most recent version before sending us a support ticket for any problems. The theme update may have resolved the issue.', 'marketr'); ?>
                                </p>
                                <p>
                                    <?php echo esc_html__('Please try to include as much information as you can in your support ticket submission so that we can address your issue more quickly. We advise you to email us one or more screenshots that clearly illustrate the problems and include the URL of your website.', 'marketr'); ?>
                                </p>
                                <p>
                                    <?php echo esc_html__('Please be patient with us as we may have a delayed response time during the weekend.', 'marketr'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
        
	}

}
new Marketr_Welcome();
?>