<?php
/**
 * Site information display template section
 *
 * @package Marketr
 */

?>

<div class="site-info">
	<?php
    $marketr_footer_text = get_theme_mod('marketr_footer_text', '');

	if (!empty($marketr_footer_text)) {
        $marketr_text = esc_html($marketr_footer_text);
    } else {
		$theme = wp_get_theme();
		$marketr_text = sprintf(
			/* translators: 1: Theme author with link, 2: Copyright year, 3: Theme name with link */
			esc_html__('Theme design by %1$s | Copyright @ %2$s %3$s', 'marketr'),
			'<a href="' . esc_url($theme->get('AuthorURI')) . '" target="_blank">' . esc_html($theme->get('Author')) . '</a>',
			esc_html(date('Y')),
			'<a href="' . esc_url($theme->get('ThemeURI')) . '" target="_blank">' . esc_html($theme->get('Name')) . '</a>'
		);
    }
	?>
	<p><?php echo $marketr_text; ?></p>
</div>