<?php 
$marketr_has_header_image = has_header_image();
$marketr_header_image_url = $marketr_has_header_image ? esc_url(get_header_image()) : '';
$marketr_header_style = '';
if ($marketr_has_header_image) {
    $marketr_header_style = sprintf(
        'background-image: url(%s); background-position: center; background-attachment: fixed; background-size: cover;',
        $marketr_header_image_url
    );
}
?>
<header id="masthead" class="site-header header-one">
	<?php get_template_part( 'template-parts/offcanvas', 'menu' ); ?>
	<div class="bottom-header header-image-wrap fixed-header" <?php if ($marketr_header_style) echo 'style="' . esc_attr($marketr_header_style) . '";'; ?>>
		<?php if( marketr_has_header_media() ){ marketr_header_media(); } ?>
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-3 col-md-4">
					<?php get_template_part( 'template-parts/site', 'branding' ); ?>
				</div>
				<div class="col-lg-7 col-md-4">
					<div class="toggle-menu menu text-center text-md-left">
						<button onclick="marketr_mobile_menu_open()" class="toggle p-2"><i class="fa-solid fa-bars"></i></button>
					</div>
					<div id="responsive" class="nav side_nav">
						<nav id="top_menu" class="nav_menu" role="navigation" aria-label="<?php esc_attr_e( 'Menu', 'marketr' ); ?>">
							<?php 
							    wp_nav_menu( array( 
									'theme_location' => 'menu-1',
									'container_class' => 'navigation clearfix' ,
									'menu_class' => 'clearfix',
									'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav m-0 px-0">%3$s</ul>',
									'fallback_cb' => 'wp_page_menu',
							    ) ); 
							?>
							<a href="javascript:void(0)" class="closebtn menu" onclick="marketr_mobile_menu_close()"><i class="fa-solid fa-xmark"></i></a>
						</nav>
					</div>
				</div>
				<div class="col-lg-2 col-md-4 phone_box text-center text-md-right my-4">
					<?php
						$marketr_phone_number = get_theme_mod( 'marketr_phone_number', '+1800-123-123' );
					 	if ( ! empty( $marketr_phone_number ) ) { ?>
				 		<span><i class="fas fa-phone"></i><?php echo esc_html( $marketr_phone_number ); ?></span>
                    <?php } ?>
				</div>
			</div>
		</div>
	</div>
</header>