<?php
/**
 * Settings for theme wizard
 *
 * @package Whizzie
 * @author Catapult Themes
 * @since 1.0.0
 */

/**
 * Define constants
 **/
if ( ! defined( 'WHIZZIE_DIR' ) ) {
	define( 'WHIZZIE_DIR', dirname( __FILE__ ) );
}
// Load the Whizzie class and other dependencies
require trailingslashit( WHIZZIE_DIR ) . 'free-content.php';
// Gets the theme object
$current_theme = wp_get_theme();
$theme_title = $current_theme->get( 'Name' );

/**
 * Make changes below
 **/

// Change the title and slug of your wizard page
$marketr_config['marketr_page_slug'] 	= 'marketr';
$marketr_config['marketr_page_title']	= 'Free Demo Content';

// You can remove elements here as required
// Don't rename the IDs - nothing will break but your changes won't get carried through
$marketr_config['steps'] = array(
	'intro' => array(
		'id'			=> 'intro',
		'title'			=> __( 'Welcome to ', 'marketr' ) . $theme_title,
		'icon'			=> 'dashboard',
		'button_text'	=> __( 'System Status', 'marketr' ),
		'can_skip'		=> false,
	),
	'plugins' => array(
		'id'			=> 'plugins',
		'title'			=> __( 'Plugins', 'marketr' ),
		'icon'			=> 'admin-plugins',
		'button_text'	=> __( 'Install Plugins', 'marketr' ),
		'can_skip'		=> true,
	),
	'widgets' => array(
		'id'			=> 'widgets',
		'title'			=> __( 'Free Demo Content', 'marketr' ),
		'icon'			=> 'welcome-widgets-menus',
		'button_text_one'	=> __( 'Click On The Image To Import Customizer Demo', 'marketr' ),
		'button_text_two'	=> __( 'Click On The Image To Import Gutenberg Block Demo', 'marketr' ),
		'can_skip'		=> true,
	),
	'done' => array(
		'id'			=> 'done',
		'title'			=> __( 'All Done', 'marketr' ),
		'icon'			=> 'yes',
	)
);

/**
 * This kicks off the wizard
 **/
if( class_exists( 'MarketrThemeWhizzie' ) ) {
	$MarketrThemeWhizzie = new MarketrThemeWhizzie( $marketr_config );
}
