<?php
/**
 * @package Free Demo Content
 * @since 1.0.0
 */

class MarketrThemeWhizzie {

	protected $version = '1.1.0';

	/** @var string Current theme name, used as namespace in actions. */
	protected $marketr_theme_name = '';
	protected $marketr_theme_title = '';

	/** @var string Free Demo Content page slug and title. */
	protected $marketr_page_slug = '';
	protected $marketr_page_title = '';

	/** @var array Free Demo Content steps set by user. */
	protected $marketr_config_steps = array();

	/**
	 * Relative plugin url for this plugin folder
	 * @since 1.0.0
	 * @var string
	*/
	protected $marketr_plugin_url = '';
	protected $marketr_plugin_path = '';
	public $marketr_parent_slug;
	/**
	 * TGMPA instance storage
	 *
	 * @var object
	*/
	protected $marketr_tgmpa_instance;

	/**
	 * TGMPA Menu slug
	 *
	 * @var string
	*/
	protected $marketr_tgmpa_menu_slug = 'tgmpa-install-plugins';

	/**
	 * TGMPA Menu url
	 *
	 * @var string
	*/
	protected $marketr_tgmpa_url = 'themes.php?page=tgmpa-install-plugins';
	/**
	 * Constructor
	 *
	 * @param $marketr_config	Our config parameters
	*/
	public function __construct( $marketr_config ) {
		$this->set_vars( $marketr_config );
		$this->init();

		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	}

	/**
	 * Set some settings
	 * @since 1.0.0
	 * @param $marketr_config	Our config parameters
	*/
	public function set_vars( $marketr_config ) {

		require_once trailingslashit( WHIZZIE_DIR ) . 'tgm/tgm.php';

		if( isset( $marketr_config['marketr_page_slug'] ) ) {
			$this->marketr_page_slug = esc_attr( $marketr_config['marketr_page_slug'] );
		}
		if( isset( $marketr_config['marketr_page_title'] ) ) {
			$this->marketr_page_title = esc_attr( $marketr_config['marketr_page_title'] );
		}
		if( isset( $marketr_config['steps'] ) ) {
			$this->marketr_config_steps = $marketr_config['steps'];
		}

		$this->marketr_plugin_path = trailingslashit( dirname( __FILE__ ) );
		$relative_url = str_replace( get_template_directory(), '', $this->marketr_plugin_path );
		$this->marketr_plugin_url = trailingslashit( get_template_directory_uri() . $relative_url );
		$current_theme = wp_get_theme();
		$this->marketr_theme_title = $current_theme->get( 'Name' );
		$this->marketr_theme_name = strtolower( preg_replace( '#[^a-zA-Z]#', '', $current_theme->get( 'Name' ) ) );
		$this->marketr_page_slug = apply_filters( $this->marketr_theme_name . '_theme_setup_wizard_marketr_page_slug', $this->marketr_theme_name . '-freedemocontent' );
		$this->marketr_parent_slug = apply_filters( $this->marketr_theme_name . '_theme_setup_wizard_parent_slug', '' );
	}

	/**
	 * Hooks and filters
	 * @since 1.0.0
	*/
	public function init() {

		if ( class_exists( 'TGM_Plugin_Activation' ) && isset( $GLOBALS['tgmpa'] ) ) {
			add_action( 'init', array( $this, 'get_tgmpa_instance' ), 30 );
			add_action( 'init', array( $this, 'set_tgmpa_url' ), 40 );
		}

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'admin_init', array( $this, 'get_plugins' ), 30 );
		add_filter( 'tgmpa_load', array( $this, 'tgmpa_load' ), 10, 1 );
		add_action( 'wp_ajax_setup_plugins', array( $this, 'setup_plugins' ) );
		add_action( 'wp_ajax_setup_widgets', array( $this, 'setup_widgets' ) );
	}

	public function enqueue_scripts() {
		wp_enqueue_style( 'marketr-free-demo-content-style', get_template_directory_uri() . '/inc/free-demo-content/css-and-js/free-demo-content-style.css');
		wp_register_script( 'marketr-free-demo-content-script', get_template_directory_uri() . '/inc/free-demo-content/css-and-js/free-demo-content-script.js', array( 'jquery' ), time() );
		wp_localize_script(
			'marketr-free-demo-content-script',
			'marketr_whizzie_params',
			array(
				'ajaxurl' 		=> admin_url( 'admin-ajax.php' ),
				'wpnonce' 		=> wp_create_nonce( 'whizzie_nonce' ),
				'verify_text'	=> esc_html( 'verifying', 'marketr' )
			)
		);
		wp_enqueue_script( 'marketr-free-demo-content-script' );
	}

	public function tgmpa_load( $status ) {
		return is_admin() || current_user_can( 'install_themes' );
	}

	/**
	 * Get configured TGMPA instance
	 *
	 * @access public
	 * @since 1.1.2
	*/
	public function get_tgmpa_instance() {
		$this->marketr_tgmpa_instance = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
	}

	/**
	 * Update $marketr_tgmpa_menu_slug and $tgmpa_parent_slug from TGMPA instance
	 *
	 * @access public
	 * @since 1.1.2
	*/
	public function set_tgmpa_url() {
		$this->marketr_tgmpa_menu_slug = ( property_exists( $this->marketr_tgmpa_instance, 'menu' ) ) ? $this->marketr_tgmpa_instance->menu : $this->marketr_tgmpa_menu_slug;
		$this->marketr_tgmpa_menu_slug = apply_filters( $this->marketr_theme_name . '_theme_setup_wizard_tgmpa_menu_slug', $this->marketr_tgmpa_menu_slug );
		$tgmpa_parent_slug = ( property_exists( $this->marketr_tgmpa_instance, 'marketr_parent_slug' ) && $this->marketr_tgmpa_instance->marketr_parent_slug !== 'themes.php' ) ? 'admin.php' : 'themes.php';
		$this->marketr_tgmpa_url = apply_filters( $this->marketr_theme_name . '_theme_setup_wizard_tgmpa_url', $tgmpa_parent_slug . '?page=' . $this->marketr_tgmpa_menu_slug );
	}


	/**  Make a modal screen for the wizard **/
	public function menu_page() {
		add_theme_page( esc_html( $this->marketr_page_title ), esc_html( $this->marketr_page_title ), 'manage_options', $this->marketr_page_slug, array( $this, 'marketr_guide' ) );
	}

	/*** Make an interface for the wizard ***/
	public function Marketr_Demo_Content_Page() {

		tgmpa_load_bulk_installer();

		// install plugins with TGM.
		if ( ! class_exists( 'TGM_Plugin_Activation' ) || ! isset( $GLOBALS['tgmpa'] ) ) {
			die( 'Failed to find TGM' );
		}
		$marketr_url = wp_nonce_url( add_query_arg( array( 'plugins' => 'go' ) ), 'whizzie-setup' );

		// copied from TGM
		$marketr_method = ''; // Leave blank so WP_Filesystem can populate it as necessary.
		$marketr_fields = array_keys( $_POST ); // Extra fields to pass to WP_Filesystem.
		if ( false === ( $creds = request_filesystem_credentials( esc_url_raw( $marketr_url ), $marketr_method, false, false, $marketr_fields ) ) ) {
			return true; // Stop the normal page form from displaying, credential request form will be shown.
		}
		// Now we have some credentials, setup WP_Filesystem.
		if ( ! WP_Filesystem( $creds ) ) {
			// Our credentials were no good, ask the user for them again.
			request_filesystem_credentials( esc_url_raw( $marketr_url ), $marketr_method, true, false, $marketr_fields );
			return true;
		}

		/* If we arrive here, we have the filesystem */ ?>
		<div class="wrap">
			<?php echo '<div class="whizzie-wrap">';
				// The wizard is a list with only one item visible at a time
				$marketr_steps = $this->get_steps();
				echo '<div class="abcd">';

					echo '<ul class="whizzie-nav wizard-icon-nav nav-tab-wrapper clearfix">';?>

					<?php
						$marketr_stepI=1;
						foreach( $marketr_steps as $marketr_step ) {
							$marketr_stepAct=($marketr_stepI ==1)? 1 : 0;
							if( isset( $marketr_step['icon_text'] ) && $marketr_step['icon_text'] ) {
								echo '<li class="commom-cls nav-step-' . esc_attr( $marketr_step['id'] ) . '" wizard-steps="step-'.esc_attr( $marketr_step['id'] ).'" data-enable="'.$marketr_stepAct.'">
								<a class="nav-tab upgrade-button">'.esc_attr( $marketr_step['icon_text'] ).'</a>
								</li>';
							}
						$marketr_stepI++;}

						echo '<div class="get-pro">';

							echo '<div class="theme-steps highlight">
									<h3>' . esc_html__('Marketr Pro', 'marketr') . '</h3>
									<p>' . esc_html__('Get all of the features that are infinite!!!', 'marketr') . '</p>
									<a target="_blank" class="button button-primary" href="' . esc_url(MARKETR_BUY_NOW) . '">' . esc_html__('Upgrade To Pro', 'marketr') . '</a>
								</div>';

						echo '</div>';

					echo '</ul>';
			 	echo '</div>';

				echo '<div class="second-div">';
					echo '<ul class="whizzie-menu wizard-menu-page theme-details">';
					foreach( $marketr_steps as $marketr_step ) {
						$marketr_class = 'step step-' . esc_attr( $marketr_step['id'] );
						echo '<li data-step="' . esc_attr( $marketr_step['id'] ) . '" class="' . esc_attr( $marketr_class ) . '" >';

							$marketr_content = call_user_func( array( $this, $marketr_step['view'] ) );
							if( isset( $marketr_content['summary'] ) ) {
								printf(
									'<div class="summary">%s</div>',
									wp_kses_post( $marketr_content['summary'] )
								);
							}
							if( isset( $marketr_content['detail'] ) ) {
								// Add a link to see more detail
								printf( '<div class="wz-require-plugins">');
								printf(
									'<div class="detail">%s</div>',
									$marketr_content['detail'] // Need to escape this
								);
								printf('</div>');
							}
							printf('<div class="wizard-button-wrapper">');
								// The next button
								if( isset( $marketr_step['button_text'] ) && $marketr_step['button_text'] ) {
									printf(
										'<div class="button-wrap"><a href="#" class="button button-primary do-it" data-callback="%s" data-step="%s">%s</a></div>',
										esc_attr( $marketr_step['callback'] ),
										esc_attr( $marketr_step['id'] ),
										esc_html( $marketr_step['button_text'] )
									);
								}

								if( isset( $marketr_step['button_text_one'] )) {
									printf(
										'<div class="button-wrap button-wrap-one">
											<a href="#" class="button button-primary do-it" data-callback="install_widgets" data-step="widgets"><p class="demo-type-text">%s</p></a>
										</div>',
										esc_html( $marketr_step['button_text_one'] )
									);
								}
							printf('</div>');
						echo '</li>';
					}
					echo '</ul>';

					echo '<div class="theme-steps-list">';

						echo '<div class="theme-steps highlight">
								<h3>' . esc_html__('Buy Marketr Pro', 'marketr') . '</h3>
								<p>' . esc_html__('To get limitless features and improvements, buy the Marketr Theme Pro edition.', 'marketr') . '</p>
								<a target="_blank" class="button button-primary" href="' . esc_url(MARKETR_BUY_NOW) . '">' . esc_html__('Buy Pro Theme', 'marketr') . '</a>
							</div>';

						echo '<div class="theme-steps highlight">
								<h3>' . esc_html__('Get the Bundle', 'marketr') . '</h3>
								<p>' . esc_html__('Introducing the WP Theme Bundle by Theme Pixel, a comprehensive collection of over 50 professionally designed WordPress themes tailored for various niches and businesses.', 'marketr') . '</p>
								<a target="_blank" class="button button-primary" href="' . esc_url(MARKETR_BUNDLE) . '">' . esc_html__('Get All Themes', 'marketr') . '</a>
							</div>';

					echo '</div>';

				echo '</div>';
				?>
			<?php echo '</div>';?>
		</div>
	<?php }

	/**
	 * Set options for the steps
	 * @return Array
	*/
	public function get_steps() {
		$marketr_dev_steps = $this->marketr_config_steps;
		$marketr_steps = array(
			'plugins' => array(
				'id'			=> 'plugins',
				'title'			=> __( 'Plugins', 'marketr' ),
				'icon'			=> 'admin-plugins',
				'view'			=> 'get_step_plugins',
				'callback'		=> 'install_plugins',
				'button_text'	=> __( 'Install Plugins', 'marketr' ),
				'can_skip'		=> true,
				'icon_text'      => 'Plugins'
			),
			'widgets' => array(
				'id'			=> 'widgets',
				'title'			=> __( 'Customizer', 'marketr' ),
				'icon'			=> 'welcome-widgets-menus',
				'view'			=> 'get_step_widgets',
				'callback'		=> 'install_widgets',
				'button_text_one'	=> __( 'Import Demo Content', 'marketr' ),

				'can_skip'		=> true,
				'icon_text'      => 'Import Demo Content'
			),
			'done' => array(
				'id'			=> 'done',
				'title'			=> __( 'All Done', 'marketr' ),
				'icon'			=> 'yes',
				'view'			=> 'get_step_done',
				'callback'		=> '',
				'icon_text'      => 'Done'
			)
		);

		// Iterate through each step and replace with dev config values
		if( $marketr_dev_steps ) {
			// Configurable elements - these are the only ones the dev can update from config.php
			$can_config = array( 'title', 'icon', 'button_text', 'can_skip' );
			foreach( $marketr_dev_steps as $dev_step ) {
				// We can only proceed if an ID exists and matches one of our IDs
				if( isset( $dev_step['id'] ) ) {
					$id = $dev_step['id'];
					if( isset( $marketr_steps[$id] ) ) {
						foreach( $can_config as $element ) {
							if( isset( $dev_step[$element] ) ) {
								$marketr_steps[$id][$element] = $dev_step[$element];
							}
						}
					}
				}
			}
		}
		return $marketr_steps;
	}

	/*** Print the content for the intro step ***/
		public function get_step_importer() { ?>
		<div class="summary">
			<p>
				<?php esc_html_e('Thank you for choosing this Marketr Theme. Using this quick setup wizard, you will be able to configure your new website and get it running in just a few minutes. Just follow these simple steps mentioned in the wizard and get started with your website.','marketr'); ?>
			</p>
		</div>
	<?php }

	/**
	 * Get the content for the plugins step
	 * @return $marketr_content Array
	*/
	public function get_step_plugins() {
		$plugins = $this->get_plugins();
		$marketr_content = array(); ?>
			<div class="summary">
				<p>
					<?php esc_html_e('Install Recommended Plugins:	','marketr') ?>
				</p>
			</div>
		<?php // The detail element is initially hidden from the user
		$marketr_content['detail'] = '<span class="wizard-plugin-count">'.count($plugins['all']).'</span><ul class="whizzie-do-plugins">';
		// Add each plugin into a list
		foreach( $plugins['all'] as $slug=>$plugin ) {
			$marketr_content['detail'] .= '<li data-slug="' . esc_attr( $slug ) . '">' . esc_html( $plugin['name'] ) . '<div class="wizard-plugin-title">';

			$marketr_content['detail'] .= '<span class="wizard-plugin-status">Installation Required</span><i class="spinner"></i></div></li>';
		}
		$marketr_content['detail'] .= '</ul>';

		return $marketr_content;
	}

	/**    Print the content for the intro step     **/
	public function get_step_widgets() { ?>
		<div class="summary">
			<p>
				<?php esc_html_e('This theme allows you to Import Demo Content content and add widgets. Install them using the button below. You can also update or deactivate them using the Customizer.','marketr'); ?>
			</p>
		</div>
	<?php }

	/***  Print the content for the final step  ***/
	public function get_step_done() { ?>

		<div class="setup-finish">
			<p>
				<?php echo esc_html('Your demo content has been imported successfully. Click the finish button for more information.'); ?>
			</p>
			<div class="finish-buttons">
				<a href="<?php echo esc_url( admin_url( 'themes.php?page=marketr-themeinfo-page' ) ); ?>" class="wz-btn-customizer" target="_blank"><?php esc_html_e('Marketr Info','marketr') ?></a>
				<a href="<?php echo esc_url(admin_url('/customize.php')); ?>" class="wz-btn-customizer" target="_blank"><?php esc_html_e('Customizer Settings','marketr') ?></a>
				<a href="" class="wz-btn-builder" target="_blank"><?php esc_html_e('Customize Your Demo','marketr'); ?></a>
				<a href="<?php echo esc_url(home_url()); ?>" class="wz-btn-visit-site" target="_blank"><?php esc_html_e('Visit Your Site','marketr'); ?></a>
			</div>
			<div class="finish-buttons">
				<a href="<?php echo esc_url(admin_url()); ?>" class="button button-primary"><?php esc_html_e('Finish','marketr'); ?></a>
			</div>
		</div>

	<?php }

	/***  Get the plugins registered with TGMPA  ***/
	public function get_plugins() {
		$instance = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
		$plugins = array(
			'all' 		=> array(),
			'install'	=> array(),
			'update'	=> array(),
			'activate'	=> array()
		);
		foreach( $instance->plugins as $slug=>$plugin ) {
			if( $instance->is_plugin_active( $slug ) && false === $instance->does_plugin_have_update( $slug ) ) {
				// Plugin is installed and up to date
				continue;
			} else {
				$plugins['all'][$slug] = $plugin;
				if( ! $instance->is_plugin_installed( $slug ) ) {
					$plugins['install'][$slug] = $plugin;
				} else {
					if( false !== $instance->does_plugin_have_update( $slug ) ) {
						$plugins['update'][$slug] = $plugin;
					}
					if( $instance->can_plugin_activate( $slug ) ) {
						$plugins['activate'][$slug] = $plugin;
					}
				}
			}
		}
		return $plugins;
	}

	public function setup_plugins() {
		if ( ! check_ajax_referer( 'whizzie_nonce', 'wpnonce' ) || empty( $_POST['slug'] ) ) {
			wp_send_json_error( array( 'error' => 1, 'message' => esc_html__( 'No Slug Found','marketr' ) ) );
		}
		$json = array();
		// send back some json we use to hit up TGM
		$plugins = $this->get_plugins();

		// what are we doing with this plugin?
		foreach ( $plugins['activate'] as $slug => $plugin ) {
			if ( $_POST['slug'] == $slug ) {
				$json = array(
					'url'           => admin_url( $this->marketr_tgmpa_url ),
					'plugin'        => array( $slug ),
					'tgmpa-page'    => $this->marketr_tgmpa_menu_slug,
					'plugin_status' => 'all',
					'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
					'action'        => 'tgmpa-bulk-activate',
					'action2'       => - 1,
					'message'       => esc_html__( 'Activating Plugin','marketr' ),
				);
				break;
			}
		}
		foreach ( $plugins['update'] as $slug => $plugin ) {
			if ( $_POST['slug'] == $slug ) {
				$json = array(
					'url'           => admin_url( $this->marketr_tgmpa_url ),
					'plugin'        => array( $slug ),
					'tgmpa-page'    => $this->marketr_tgmpa_menu_slug,
					'plugin_status' => 'all',
					'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
					'action'        => 'tgmpa-bulk-update',
					'action2'       => - 1,
					'message'       => esc_html__( 'Updating Plugin','marketr' ),
				);
				break;
			}
		}
		foreach ( $plugins['install'] as $slug => $plugin ) {
			if ( $_POST['slug'] == $slug ) {
				$json = array(
					'url'           => admin_url( $this->marketr_tgmpa_url ),
					'plugin'        => array( $slug ),
					'tgmpa-page'    => $this->marketr_tgmpa_menu_slug,
					'plugin_status' => 'all',
					'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
					'action'        => 'tgmpa-bulk-install',
					'action2'       => - 1,
					'message'       => esc_html__( 'Installing Plugin','marketr' ),
				);
				break;
			}
		}
		if ( $json ) {
			$json['hash'] = md5( serialize( $json ) ); // used for checking if duplicates happen, move to next plugin
			wp_send_json( $json );
		} else {
			wp_send_json( array( 'done' => 1, 'message' => esc_html__( 'Success','marketr' ) ) );
		}
		exit;
	}


	//. - . - . - . - . - . - . - . - . - . - . - . - . MENUS . - . - . - . - . - . - . - . - . - . - . - . - .//
	
	public function Marketr_Customizer_Header_Menu() {
		// ------- Create Primary Menu --------
		$marketr_themename = 'Marketr'; // Ensure the theme name is set
		$marketr_menuname = $marketr_themename . ' Primary Menu';
		$marketr_menulocation = 'menu-1';
		$marketr_menu_exists = wp_get_nav_menu_object($marketr_menuname);

		if (!$marketr_menu_exists) {
			$marketr_menu_id = wp_create_nav_menu($marketr_menuname);

			// Home
			wp_update_nav_menu_item($marketr_menu_id, 0, array(
				'menu-item-title' => __('Home', 'marketr'),
				'menu-item-classes' => 'home',
				'menu-item-url' => home_url('/'),
				'menu-item-status' => 'publish'
			));

			// About
			$marketr_page_about = get_page_by_path('about');
			if($marketr_page_about){
				wp_update_nav_menu_item($marketr_menu_id, 0, array(
					'menu-item-title' => __('About', 'marketr'),
					'menu-item-classes' => 'about',
					'menu-item-url' => get_permalink($marketr_page_about),
					'menu-item-status' => 'publish'
				));
			}

			// Page
			$marketr_page_Page = get_page_by_path('Page');
			if($marketr_page_Page){
				wp_update_nav_menu_item($marketr_menu_id, 0, array(
					'menu-item-title' => __('Page', 'marketr'),
					'menu-item-classes' => 'Page',
					'menu-item-url' => get_permalink($marketr_page_Page),
					'menu-item-status' => 'publish'
				));
			}

			// Blog
			$marketr_page_blog = get_page_by_path('blog');
			if($marketr_page_blog){
				wp_update_nav_menu_item($marketr_menu_id, 0, array(
					'menu-item-title' => __('Blog', 'marketr'),
					'menu-item-classes' => 'blog',
					'menu-item-url' => get_permalink($marketr_page_blog),
					'menu-item-status' => 'publish'
				));
			}

			// Contact Us
			$marketr_page_contact = get_page_by_path('contact');
			if($marketr_page_contact){
				wp_update_nav_menu_item($marketr_menu_id, 0, array(
					'menu-item-title' => __('Contact Us', 'marketr'),
					'menu-item-classes' => 'contact',
					'menu-item-url' => get_permalink($marketr_page_contact),
					'menu-item-status' => 'publish'
				));
			}

			// Assign menu to location if not set
			if (!has_nav_menu($marketr_menulocation)) {
				$marketr_locations = get_theme_mod('nav_menu_locations');
				$marketr_locations[$marketr_menulocation] = $marketr_menu_id; // Use $marketr_menu_id here
				set_theme_mod('nav_menu_locations', $marketr_locations);
			}
		}
	}


	/**
	* Imports the Demo Content
	* @since 1.1.0
	*/
	public function setup_widgets() {

		//. - . - . - . - . - . - . - . - . - . - . - . - . MENU PAGES . - . - . - . - . - . - . - . - . - . - . - . - .//
		
			$marketr_home_id='';
			$marketr_home_content = '';

			$marketr_home_title = 'Home';
			$marketr_home = array(
					'post_type' => 'page',
					'post_title' => $marketr_home_title,
					'post_content'  => $marketr_home_content,
					'post_status' => 'publish',
					'post_author' => 1,
					'post_slug' => 'home'
			);
			$marketr_home_id = wp_insert_post($marketr_home);

			//Set the home page template
			add_post_meta( $marketr_home_id, '_wp_page_template', 'default-home.php' );

			//Set the static front page
			$marketr_home = get_page_by_title( 'Home' );
			update_option( 'page_on_front', $marketr_home->ID );
			update_option( 'show_on_front', 'page' );


			// Create a posts page and assign the template
			$marketr_blog_title = 'Blog';
			$marketr_blog_check = get_page_by_path('blog');
			if (!$marketr_blog_check) {
				$marketr_blog = array(
					'post_type'    => 'page',
					'post_title'   => $marketr_blog_title,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'blog'
				);
				$marketr_blog_id = wp_insert_post($marketr_blog);

				// Set the posts page
				if (!is_wp_error($marketr_blog_id)) {
					update_option('page_for_posts', $marketr_blog_id);
				}
			}

			// Create a Contact Us page and assign the template
			$marketr_contact_title = 'Contact Us';
			$marketr_contact_check = get_page_by_path('contact');
			if (!$marketr_contact_check) {
				$marketr_contact = array(
					'post_type'    => 'page',
					'post_title'   => $marketr_contact_title,
					'post_status'  => 'publish',
					'post_content'   => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.',
					'post_author'  => 1,
					'post_name'    => 'contact'
				);
				wp_insert_post($marketr_contact);
			}

			// Create a About page and assign the template
			$marketr_about_title = 'About';
			$marketr_about_check = get_page_by_path('about');
			if (!$marketr_about_check) {
				$marketr_about = array(
					'post_type'    => 'page',
					'post_title'   => $marketr_about_title,
					'post_status'  => 'publish',
					'post_content'   => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.',
					'post_author'  => 1,
					'post_name'    => 'about'
				);
				wp_insert_post($marketr_about);
			}

			// Create a Page page and assign the template
			$marketr_Page_title = 'Page';
			$marketr_Page_check = get_page_by_path('Page');
			if (!$marketr_Page_check) {
				$marketr_Page = array(
					'post_type'    => 'page',
					'post_title'   => $marketr_Page_title,
					'post_status'  => 'publish',
					'post_content'   => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.',
					'post_author'  => 1,
					'post_name'    => 'Page'
				);
				wp_insert_post($marketr_Page);
			}

			
		//. - . - . - . - . - . - . - . - . - . - . - . - . FRONTPAGE CONTENT . - . - . - . - . - . - . - . - . - . - . - . - .//

			set_theme_mod('marketr_phone_number','+1800-123-123');

			set_theme_mod('marketr_banner_section_on_off_setting',true);
			set_theme_mod('marketr_about_section_on_off_setting',true);

			set_theme_mod('marketr_banner_heading','Digital Marketing Agency For You Better Business');
			set_theme_mod('marketr_banner_text','Lorem Ipsum is simply dummy text of the printing and typesetting industry.');
			set_theme_mod('marketr_banner_button_link','#');
			set_theme_mod('marketr_banner_button_text','Get A Quote');
			set_theme_mod( 'marketr_banner_image',get_template_directory_uri().'/assets/images/banner.png' );

			set_theme_mod('marketr_about_short_heading','GET TO KNOW US');
			set_theme_mod('marketr_about_heading','We Want To Give You The Best Service');
			set_theme_mod('marketr_about_content','Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever and the part of new memory since the');
			set_theme_mod( 'marketr_about_image_big',get_template_directory_uri().'/assets/images/big.png' );
			set_theme_mod( 'marketr_about_image_small',get_template_directory_uri().'/assets/images/small.png' );

			set_theme_mod('marketr_about_list1','Analyze the Problem');
			set_theme_mod('marketr_about_list2','We bring the right people');
			set_theme_mod('marketr_about_list3','Brand strategy and digital creation');

			set_theme_mod('marketr_about_achivement_number','20+');
			set_theme_mod('marketr_about_achivement_text','Years Experience');

			set_theme_mod('marketr_about_leading_heading','Leading in marketing');
			set_theme_mod('marketr_about_leading_text','Lorem ipsum dolor sit ame');
			
			set_theme_mod('marketr_about_button_link','#');
			set_theme_mod('marketr_about_button_text','More About');

		$this->Marketr_Customizer_Header_Menu();
	}

	//guidline for about theme
	public function marketr_guide() {
		$display_string = '';
		//custom function about theme customizer
		$return = add_query_arg( array()) ;
		$theme = wp_get_theme( 'marketr' );
		?>
		<div class="wrapper-info wrap about-wrap access-wrap">

			<div class="abt-promo-wrap clearfix">
				<div class="abt-theme-wrap">
				<h1><?php esc_html_e( 'Marketr', 'marketr' ); ?> <span class="version"><?php echo esc_html__( '- FREE DEMO CONTENT', 'marketr' ); ?></span></h1>
				<div class="doc-links">
						<h4><?php echo esc_html__('Visit Sites :-', 'marketr'); ?></h4>
						<a href="<?php echo esc_url(MARKETR_BUY_NOW); ?>" target="_blank">
							<span class="dashicons dashicons-admin-site-alt3"></span>
							<span class="theme-pixel-tooltip"><?php echo esc_html__('View Website', 'marketr'); ?></span>
						</a>
						<a href="<?php echo esc_url(MARKETR_LIVE_DEMO); ?>" target="_blank">
							<span class="dashicons dashicons-desktop"></span>
							<span class="theme-pixel-tooltip"><?php echo esc_html__('View Demo Site', 'marketr'); ?></span>
						</a>
						<a href="<?php echo esc_url(MARKETR_THEME_SUPPORT); ?>" target="_blank">
							<span class="dashicons dashicons-megaphone"></span>
							<span class="theme-pixel-tooltip"><?php echo esc_html__('Contact Support', 'marketr'); ?></span>
						</a>
						<a href="<?php echo esc_url(MARKETR_FREE_DOC); ?>" target="_blank">
							<span class="dashicons dashicons-pdf"></span>
							<span class="theme-pixel-tooltip"><?php echo esc_html__('Documentation', 'marketr'); ?></span>
						</a>
					</div>
				</div>
			</div>

			<div class="tab-sec theme-option-tab">
				<div id="demo_offer" class="tabcontent open">
					<?php $this->Marketr_Demo_Content_Page(); ?>
				</div>
			</div>
		</div>
		
	<?php }
}