<?php
/**
 * Marketr Theme Customizer
 *
 * @package Marketr
 */

// Customize Controls.
require get_template_directory() . '/inc/custom-settings-control/customize-controls.php';

// Customize Controls.
require get_template_directory() . '/inc/custom-range-controls.php';

// Sanitization For Customize Controls.
require get_template_directory() . '/inc/custom-settings-control/sanitization.php';

/**
 * Provide postMessage support for the Theme Customizer's site title and description.
 */
function marketr_customize_register( $wp_customize ) {

	// Header Settings Panel.
	$wp_customize->add_panel( 'marketr_header_settings_panel',
		array(
			'title'      => esc_html__( 'Header Settings', 'marketr' ),
			'priority'   => 2,
			'capability' => 'edit_theme_options',
		)
	);

	// Frontpage Sections Settings Panel.
	$wp_customize->add_panel( 'marketr_frontpage_sections_settings_panel',
		array(
			'title'      => esc_html__( 'Frontpage Sections Settings', 'marketr' ),
			'priority'   => 3,
			'capability' => 'edit_theme_options',
		)
	);

	// Footer Settings Panel.
	$wp_customize->add_panel( 'marketr_footer_settings_panel',
		array(
			'title'      => esc_html__( 'Footer Settings', 'marketr' ),
			'priority'   => 3,
			'capability' => 'edit_theme_options',
		)
	);

	// Site Identity

	$wp_customize->add_setting(
		'marketr_site_logo',
		array(
			'default'           => false,
			'sanitize_callback' => 'marketr_sanitize_on_off',
		)
	);

	$wp_customize->add_control(
		new marketr_On_Off_Custom_Control(
			$wp_customize,
			'marketr_site_logo',
			array(
				'label'    => esc_html__( 'ON / OFF Site Logo', 'marketr' ),
				'section'  => 'title_tagline',
				'settings' => 'marketr_site_logo',
			)
		)
	);

	$wp_customize->add_setting(
		'marketr_site_title_text',
		array(
			'default'           => true,
			'sanitize_callback' => 'marketr_sanitize_on_off',
		)
	);

	$wp_customize->add_control(
		new marketr_On_Off_Custom_Control(
			$wp_customize,
			'marketr_site_title_text',
			array(
				'label'    => esc_html__( 'ON / OFF Site Title', 'marketr' ),
				'section'  => 'title_tagline',
				'settings' => 'marketr_site_title_text',
			)
		)
	);

	$wp_customize->add_setting(
        'marketr_title_font_size',
        array(
            'default'    => 22,
            'sanitize_callback' => 'marketr_sanitize_number_range',
        )
    );

    $wp_customize->add_control(
        new marketr_Slider(
            $wp_customize,
            'marketr_title_font_size',
            array(
                'label'    => esc_html__( 'Site Title Font Size', 'marketr' ),
                'section'  => 'title_tagline',
                'label' => esc_html__('Site Title Font Size', 'marketr'),
                'input_attrs' => array(
					'reset'			   => 22,
		            'step'             => 1,
					'min'              => 0,
					'max'              => 50,
		        ),
            )
        )
    );


	$wp_customize->add_setting(
		'marketr_site_tagline_text',
		array(
			'default'           => false,
			'sanitize_callback' => 'marketr_sanitize_on_off',
		)
	);

	$wp_customize->add_control(
		new marketr_On_Off_Custom_Control(
			$wp_customize,
			'marketr_site_tagline_text',
			array(
				'label'    => esc_html__( 'ON / OFF Site Tagline', 'marketr' ),
				'section'  => 'title_tagline',
				'settings' => 'marketr_site_tagline_text',
			)
		)
	);
	
	$wp_customize->add_setting(
        'marketr_site_tagline_font_size',
        array(
            'default'    => 14,
            'sanitize_callback' => 'marketr_sanitize_number_range',
        )
    );

    $wp_customize->add_control(
        new marketr_Slider(
            $wp_customize,
            'marketr_site_tagline_font_size',
            array(
                'label'    => esc_html__( 'Tagline Font Size', 'marketr' ),
                'section'  => 'title_tagline',
                'label' => esc_html__('Tagline Font Size', 'marketr'),
                'input_attrs' => array(
					'reset'			   => 14,
		            'step'             => 1,
					'min'              => 0,
					'max'              => 50,
		        ),
            )
        )
    );
    
	// Header Option

	$wp_customize->add_section(
		'marketr_header_section',
		array(
			'panel'      => 'marketr_header_settings_panel',
			'title'    => esc_html__( 'Header Options', 'marketr' ),
		)
	);

	//MENU TYPOGRAPHY
	
	$wp_customize->add_setting('marketr_menu_font_weight',array(
        'default' => '',
        'sanitize_callback' => 'marketr_sanitize_choices'
	));
	$wp_customize->add_control('marketr_menu_font_weight',array(
     'type' => 'radio',
     'label'     => __('Menu Font Weight', 'marketr'),
     'section' => 'marketr_header_section',
     'type' => 'select',
     'choices' => array(
         '100' => __('100','marketr'),
         '200' => __('200','marketr'),
         '300' => __('300','marketr'),
         '400' => __('400','marketr'),
         '500' => __('500','marketr'),
         '600' => __('600','marketr'),
         '700' => __('700','marketr'),
         '800' => __('800','marketr'),
         '900' => __('900','marketr')
     ),
	) );
	
	$wp_customize->add_setting('marketr_menu_text_tranform',array(
		'default' => 'Capitalize',
		'sanitize_callback' => 'marketr_sanitize_choices'
 	));
 	$wp_customize->add_control('marketr_menu_text_tranform',array(
		'type' => 'select',
		'label' => __('Menu Text Transform','marketr'),
		'section' => 'marketr_header_section',
		'choices' => array(
		   'Uppercase' => __('Uppercase','marketr'),
		   'Lowercase' => __('Lowercase','marketr'),
		   'Capitalize' => __('Capitalize','marketr'),
		),
	) );
	$wp_customize->add_setting('marketr_menu_font_size', array(
	    'default'	=> 16,
        'sanitize_callback' => 'marketr_sanitize_number_range',
	));
	$wp_customize->add_control(new marketr_Slider($wp_customize, 'marketr_menu_font_size', array(
        'section' => 'marketr_header_section',
        'label' => esc_html__('Menu Font Size', 'marketr'),
        'input_attrs' => array(
					'reset'			   => 16,
		            'step'             => 1,
					'min'              => 0,
					'max'              => 35,
		        ),
	)));

	$wp_customize->add_setting(
		'marketr_phone_number',
		array(
			'default'           => '+1800-123-123',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_phone_number',
		array(
			'label'           => sprintf( esc_html__( 'Phone Number', 'marketr' ), ),
			'section'         => 'marketr_header_section',
			'settings'        => 'marketr_phone_number' ,
			'type'            => 'text',
		)
	);

	// Banner Option

	$wp_customize->add_section(
		'marketr_banner_section',
		array(
			'panel'      => 'marketr_frontpage_sections_settings_panel',
			'title'    => esc_html__( 'Banner Options', 'marketr' ),
		)
	);

	$wp_customize->add_setting(
		'marketr_banner_section_on_off_setting',
		array(
			'default'           => false,
			'sanitize_callback' => 'marketr_sanitize_on_off',
		)
	);

	$wp_customize->add_control(
		new Marketr_On_Off_Custom_Control(
			$wp_customize,
			'marketr_banner_section_on_off_setting',
			array(
				'label'    => esc_html__( 'ON / OFF Banner Section', 'marketr' ),
				'section'  => 'marketr_banner_section',
				'settings' => 'marketr_banner_section_on_off_setting',
			)
		)
	);

	$wp_customize->add_setting(
		'marketr_banner_heading',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_banner_heading',
		array(
			'label'           => sprintf( esc_html__( 'Banner Heading', 'marketr' ), ),
			'section'         => 'marketr_banner_section',
			'settings'        => 'marketr_banner_heading' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_banner_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_banner_text',
		array(
			'label'           => sprintf( esc_html__( 'Banner Content', 'marketr' ), ),
			'section'         => 'marketr_banner_section',
			'settings'        => 'marketr_banner_text' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_banner_button_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'marketr_banner_button_link',
		array(
			'label'           => sprintf( esc_html__( 'Banner Button Link', 'marketr' ), ),
			'section'         => 'marketr_banner_section',
			'settings'        => 'marketr_banner_button_link' ,
			'type'            => 'url',
		)
	);

	$wp_customize->add_setting(
		'marketr_banner_button_text',
		array(
			'default'           => 'Get A Quote',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_banner_button_text',
		array(
			'label'           => sprintf( esc_html__( 'Banner Button Text', 'marketr' ), ),
			'section'         => 'marketr_banner_section',
			'settings'        => 'marketr_banner_button_text' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_banner_image',
		array(
        	'default'           => '',
        	'sanitize_callback' => 'marketr_sanitize_image',

    	)
    );
    
    $wp_customize->add_control(
     	new WP_Customize_Image_Control(
    		$wp_customize, 'marketr_banner_image', 
    		array(
    			'label'           => sprintf( esc_html__( 'Banner Image', 'marketr' ), ),
		        'settings'  => 'marketr_banner_image',
		        'section'   => 'marketr_banner_section'
    		) 
    	)
    );

    // About Us Option

	$wp_customize->add_section(
		'marketr_about_section',
		array(
			'panel'      => 'marketr_frontpage_sections_settings_panel',
			'title'    => esc_html__( 'About Us Options', 'marketr' ),
		)
	);

	$wp_customize->add_setting(
		'marketr_about_section_on_off_setting',
		array(
			'default'           => false,
			'sanitize_callback' => 'marketr_sanitize_on_off',
		)
	);

	$wp_customize->add_control(
		new Marketr_On_Off_Custom_Control(
			$wp_customize,
			'marketr_about_section_on_off_setting',
			array(
				'label'    => esc_html__( 'ON / OFF About Section', 'marketr' ),
				'section'  => 'marketr_about_section',
				'settings' => 'marketr_about_section_on_off_setting',
			)
		)
	);

	$wp_customize->add_setting(
		'marketr_about_image_big',
		array(
        	'default'           => '',
        	'sanitize_callback' => 'marketr_sanitize_image',
    	)
    );
    
    $wp_customize->add_control(
     	new WP_Customize_Image_Control(
    		$wp_customize, 'marketr_about_image_big', 
    		array(
    			'label'           => sprintf( esc_html__( 'About Big Image', 'marketr' ), ),
		        'settings'  => 'marketr_about_image_big',
		        'section'   => 'marketr_about_section'
    		) 
    	)
    );

    $wp_customize->add_setting(
		'marketr_about_image_small',
		array(
        	'default'           => '',
        	'sanitize_callback' => 'marketr_sanitize_image',
    	)
    );
    
    $wp_customize->add_control(
     	new WP_Customize_Image_Control(
    		$wp_customize, 'marketr_about_image_small', 
    		array(
    			'label'           => sprintf( esc_html__( 'About Small Image', 'marketr' ), ),
		        'settings'  => 'marketr_about_image_small',
		        'section'   => 'marketr_about_section'
    		) 
    	)
    );

	$wp_customize->add_setting(
		'marketr_about_short_heading',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_short_heading',
		array(
			'label'           => sprintf( esc_html__( 'About Short Heading', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_short_heading' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_heading',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_heading',
		array(
			'label'           => sprintf( esc_html__( 'About Heading', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_heading' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_content',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_content',
		array(
			'label'           => sprintf( esc_html__( 'About Content', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_content' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_list1',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_list1',
		array(
			'label'           => sprintf( esc_html__( 'About List 1', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_list1' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_list2',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_list2',
		array(
			'label'           => sprintf( esc_html__( 'About List 2', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_list2' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_list3',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_list3',
		array(
			'label'           => sprintf( esc_html__( 'About List 3', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_list3' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_achivement_number',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_achivement_number',
		array(
			'label'           => sprintf( esc_html__( 'Achivement Number', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_achivement_number' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_achivement_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_achivement_text',
		array(
			'label'           => sprintf( esc_html__( 'Achivement Text', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_achivement_text' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_leading_heading',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_leading_heading',
		array(
			'label'           => sprintf( esc_html__( 'Leading Heading', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_leading_heading' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_leading_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_leading_text',
		array(
			'label'           => sprintf( esc_html__( 'Leading Text', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_leading_text' ,
			'type'            => 'text',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_button_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'marketr_about_button_link',
		array(
			'label'           => sprintf( esc_html__( 'About Button Link', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_button_link' ,
			'type'            => 'url',
		)
	);

	$wp_customize->add_setting(
		'marketr_about_button_text',
		array(
			'default'           => 'More About',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'marketr_about_button_text',
		array(
			'label'           => sprintf( esc_html__( 'About Button Text', 'marketr' ), ),
			'section'         => 'marketr_about_section',
			'settings'        => 'marketr_about_button_text' ,
			'type'            => 'text',
		)
	);

	// Footer Option

	$wp_customize->add_section(
        'marketr_footer_widgets_section',
        array(
            'panel'      => 'marketr_footer_settings_panel',
            'title'    => esc_html__( 'Footer Widgets Options', 'marketr' ),
        )
    );

	$wp_customize->add_setting(
		'marketr_footer_widgets_section_on_off_setting',
		array(
			'default'           => true,
			'sanitize_callback' => 'marketr_sanitize_on_off',
		)
	);

	$wp_customize->add_control(
		new marketr_On_Off_Custom_Control(
			$wp_customize,
			'marketr_footer_widgets_section_on_off_setting',
			array(
				'label'    => esc_html__( 'ON / OFF Footer Widgets', 'marketr' ),
				'section'  => 'marketr_footer_widgets_section',
				'settings' => 'marketr_footer_widgets_section_on_off_setting',
			)
		)
	);

	$wp_customize->add_section(
        'marketr_copyright_section',
        array(
            'panel'      => 'marketr_footer_settings_panel',
            'title'    => esc_html__( 'Copyright Options', 'marketr' ),
        )
    );

    $wp_customize->add_setting(
        'marketr_footer_text',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'marketr_footer_text',
        array(
            'label'           => sprintf( esc_html__( 'Edit Copyright Text', 'marketr' ), ),
            'section'         => 'marketr_copyright_section',
            'settings'        => 'marketr_footer_text' ,
            'type'            => 'text',
        )
    );

}
add_action( 'customize_register', 'marketr_customize_register' );

/**
 * Create the site title for the partial selective refresh.
 *
 * @return void
 */
function marketr_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Create the website's slogan for the partial selective refresh.
 *
 * @return void
 */
function marketr_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Marketr_Customize_Buttons {
	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function Marketr_get_instance() {

		static $marketr_instance = null;

		if ( is_null( $marketr_instance ) ) {
			$marketr_instance = new self;
			$marketr_instance->Marketr_setup_actions();
		}

		return $marketr_instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function Marketr_setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $marketr_manager
	 * @return void
	*/
	public function sections( $marketr_manager ) {
		load_template( trailingslashit( get_template_directory() ) . '/inc/marketr-section-pro.php' );

		$marketr_manager->register_section_type( 'Marketr_Customize_Section_Pro' );

		$marketr_manager->add_section( new Marketr_Customize_Section_Pro( $marketr_manager,'marketr_buy_now', array(
			'priority'   => 1,
			'title'    => esc_html__( 'Buy Marketr Pro', 'marketr' ),
			'pro_text' => esc_html__( 'Buy Pro Theme', 'marketr' ),
			'pro_url'    => esc_url( MARKETR_BUY_NOW ),
		) )	);

		$marketr_manager->add_section( new Marketr_Customize_Section_Pro( $marketr_manager, 'marketr_live_demo', array(
		    'priority'   => 1,
		    'title'      => esc_html__( 'Preview Pro Theme', 'marketr' ),
		    'pro_text'   => esc_html__( 'View Live Demo', 'marketr' ),
		    'pro_url'    => esc_url( MARKETR_LIVE_DEMO ),
		) ) );	
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'marketr-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'marketr-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/css/customize-controls.css' );
	}
}
Marketr_Customize_Buttons::Marketr_get_instance();