<?php
/**
 * The theme's header
 *
 * @package marketr
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> dir="<?php echo ( is_rtl() ) ? 'rtl' : 'ltr'; ?>">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php do_action( 'wp_body_open' ); ?>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'marketr' ); ?></a>

	<?php
		get_template_part( 'template-parts/header/header', 'one' );
	?>