<?php
/**
 * marketr functions and definitions
 *
 * @package marketr
 */

if ( ! function_exists( 'marketr_setup' ) ) :
	function marketr_setup() {
		
		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'woocommerce' );

		load_theme_textdomain( 'marketr', get_template_directory() . '/languages' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Post thumbnail support should be enabled for pages and posts.
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'marketr' ),
			'menu-2' => esc_html__( 'Footer', 'marketr' ),
		) );

		/*
		 * To produce valid HTML5, change the default core markup for the comments, search form, and search form.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );
		
		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'width'       => 270,
			'height'      => 80,
			'flex-height' => true,
			'flex-width'  => true,
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add custom image size.
		add_image_size( 'marketr-1920-550', 1920, 550, true );
		add_image_size( 'marketr-1370-550', 1370, 550, true );
		add_image_size( 'marketr-590-310', 590, 310, true );
		add_image_size( 'marketr-420-380', 420, 380, true );
		add_image_size( 'marketr-420-300', 420, 300, true );
		add_image_size( 'marketr-420-200', 420, 200, true );
		add_image_size( 'marketr-290-150', 290, 150, true );
		add_image_size( 'marketr-80-60', 80, 60, true );
		
		add_editor_style( array( '/assets/css/editor-style.min.css') );

		add_theme_support( 'align-wide' );
		add_theme_support( 'editor-styles' );
		add_theme_support( 'wp-block-styles' );

        add_theme_support( 'custom-background', apply_filters( 'marketr_custom_background', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        )));
        
        add_theme_support( 'responsive-embeds' );

		add_theme_support('custom-header', array(
			'default-image'      => '',
			'width'              => 1920,
			'height'             => 200,
			'flex-height'        => true,
			'flex-width'         => true,
			'uploads'            => true,
		));

		define('MARKETR_BUY_NOW',__('https://www.themepixels.net/products/wp-theme-bundle/','marketr'));
		define('MARKETR_LIVE_DEMO',__('https://themepixels.net/','marketr'));
		define('MARKETR_FREE_DOC',__('https://www.themepixels.net/docs/marketr-free/','marketr'));
		define('MARKETR_BUNDLE',__('https://www.themepixels.net/products/wp-theme-bundle/','marketr'));
		define('MARKETR_THEME_SUPPORT',__('https://wordpress.org/support/theme/marketr','marketr'));
        
		/**
		* FREE DEMO CONTENT.
		*/
		require get_template_directory() . '/inc/free-demo-content/marketr_config_file.php';

	}
endif;
add_action( 'after_setup_theme', 'marketr_setup' );

/**
 * Enqueue scripts and styles.
 */
function marketr_scripts() {

	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/bootstrap/css/bootstrap.min.css' );
	if ( is_rtl() ){
		wp_enqueue_style( 'bootstrap-rtl', get_template_directory_uri() . '/assets/bootstrap/css/rtl/bootstrap.min.css' );

		wp_enqueue_style( 'marketr-rtl-style', get_template_directory_uri() . '/rtl.css' );
	}

	// Theme stylesheet.
	wp_enqueue_style( 'marketr-style', get_stylesheet_uri() );
	require get_parent_theme_file_path( '/extra-pixel-customize.php' );
	wp_add_inline_style( 'marketr-style',$marketr_pix_theme_css );

	wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/font-awesome/css/all.min.css' );
	wp_enqueue_style( 'marketr-blocks', get_template_directory_uri() . '/assets/css/blocks.min.css' );
	wp_enqueue_style( 'marketr-style', get_stylesheet_uri() );
	wp_enqueue_style( 'marketr-google-font', 'https://fonts.googleapis.com/css?family=Open+Sans:300,400,400i,600,700,800|Poppins:300,400,400i,500,600,700,800,900&display=swap', false );

	$scripts = array(
		array(
			'id'     => 'bootstrap',
			'url'    => get_template_directory_uri() . '/assets/bootstrap/js/bootstrap.min.js',
			'footer' => true
		),
		array(
			'id'     => 'marketr-custom',
			'url'    => get_template_directory_uri() . '/assets/js/custom.js',
			'footer' => true
		)
	);

	marketr_add_scripts( $scripts );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'marketr_scripts' );

function marketr_sanitize_number_range( $number, $setting ) {

	// Ensure input is an absolute integer.
	$number = absint( $number );

	// Get the input attributes associated with the setting.
	$atts = $setting->manager->get_control( $setting->id )->input_attrs;

	// Get minimum number in the range.
	$min = ( isset( $atts['min'] ) ? $atts['min'] : $number );

	// Get maximum number in the range.
	$max = ( isset( $atts['max'] ) ? $atts['max'] : $number );

	// Get step.
	$step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );

	// If the number is within the valid range, return it; otherwise, return the default
	return ( $min <= $number && $number <= $max && is_int( $number / $step ) ? $number : $setting->default );
}


/*radio button sanitization*/
function marketr_sanitize_choices( $input, $setting ) {
    global $wp_customize;
    $control = $wp_customize->get_control( $setting->id );
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

/**
* Add script
* 
* @since marketr 1.0.0
*/
function marketr_add_scripts( $scripts ){
	foreach ( $scripts as $key => $value ) {
		wp_enqueue_script( $value['id'] , $value['url'] , array( 'jquery', 'jquery-masonry' ), 0.8, $value['footer'] );
	}
}

/**
 * Sanitizes Image Upload.
 *
 * @param string $input potentially dangerous data.
 */
function marketr_sanitize_image( $input ) {
	$filetype = wp_check_filetype( $input );
	if ( $filetype['ext'] && wp_ext2type( $filetype['ext'] ) === 'image' ) {
		return esc_url( $input );
	}
	return '';
}

/**
* Enqueue editor styles for Gutenberg
* 
* @since marketr 1.0.0
*/
function marketr_block_editor_styles() {
	// Block styles.
	wp_enqueue_style( 'marketr-block-editor-style', get_theme_file_uri( '/assets/css/editor-blocks.min.css' ) );
	// Google Font
	wp_enqueue_style( 'marketr-google-font', 'https://fonts.googleapis.com/css?family=Poppins:300,400,400i,500,600,700,700i', false );
}
add_action( 'enqueue_block_editor_assets', 'marketr_block_editor_styles' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

/**
 * Dynamic CSS.
 */
require get_template_directory() . '/inc/customizer/loader.php';

/**
* GET START.
*/
require get_template_directory() . '/themeinfo/marketr_themeinfo_page.php';


// NOTICE FUNCTION
function marketr_activation_notice() {
    if (get_option('marketr_notice_dismissed')) {
        return;
    }

    if (isset($_GET['page']) && $_GET['page'] === 'marketr-themeinfo-page') {
        return;
    }
    ?>
    <div class="updated notice notice-theme-info-class is-dismissible" data-notice="theme_info">
        <div class="marketr-theme-info-notice clearfix">
            <div class="marketr-theme-notice-content">
				<div class="notice-content">
					<div class="inner-notice-contetn">
						<h2 class="marketr-notice-h2">
							<?php
							printf(
								/* translators: 1: Theme name */
								esc_html__('Hello! Thank you for choosing our %1$s!', 'marketr'), '<strong>' . esc_html(wp_get_theme()->get('Name')) . '</strong>'
							);
							?>
						</h2>

						<p class="marketr-notice-p">
							<?php
							printf(
								/* translators: 1: Theme name */
								esc_html__('%1$s has been successfully installed and is ready for use. The links below will help you get started.', 'marketr'), '<strong>' . esc_html(wp_get_theme()->get('Name')) . '</strong>'
							);
							?>
						</p>
					</div>
					<div class="inner-notice-buttons">
						<a class="marketr-btn-theme-info button button-primary" target="_blank" href="<?php echo esc_url(admin_url('themes.php?page=marketr-themeinfo-page')); ?>" id="marketr-themeinfo-button"> <?php esc_html_e('Marketr Theme Information', 'marketr') ?></a>
						
						<a class="marketr-btn-theme-info button button-primary buy-noww" target="_blank" href="<?php echo esc_url(MARKETR_BUY_NOW); ?>" id="marketr-bundle-button"> <?php esc_html_e('Buy Now', 'marketr') ?></a>
						<a class="marketr-btn-theme-info button button-primary bundlee" target="_blank" href="<?php echo esc_url(MARKETR_BUNDLE); ?>" id="marketr-bundle-button"> <?php esc_html_e('Get All Themes', 'marketr') ?></a>
						<a class="marketr-btn-theme-info button button-primary live-demoo" target="_blank" href="<?php echo esc_url(MARKETR_LIVE_DEMO); ?>" id="marketr-bundle-button"> <?php esc_html_e('Live Demo', 'marketr') ?></a>
					</div>
				</div>
				<div class="notice-image">
					<img src="<?php echo esc_url( get_stylesheet_directory_uri() . '/assets/images/bundle-img.png' ); ?>" alt="<?php esc_attr_e( 'Theme Screenshot', 'marketr' ); ?>">
				</div>
            </div>
        </div>
    </div>
    <?php
}

add_action('admin_notices', 'marketr_activation_notice');

add_action('wp_ajax_marketr_dismiss_notice', 'marketr_dismiss_notice');

function marketr_notice_status() {
    delete_option('marketr_notice_dismissed');
}
add_action('after_switch_theme', 'marketr_notice_status');

function marketr_dismiss_notice() {
    update_option('marketr_notice_dismissed', true);
    wp_send_json_success();
}

function marketr_admin_enqueue_scripts(){
	wp_enqueue_style('marketr-admin-style', esc_url( get_template_directory_uri() ) . '/assets/css/marketr-notice.css');
	wp_enqueue_script('marketr-dismiss-notice-script', get_stylesheet_directory_uri() . '/assets/js/marketr-notice.js', array('jquery'), null, true);
}
add_action( 'admin_enqueue_scripts', 'marketr_admin_enqueue_scripts' );

function marketr_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'display_header_text' );
    $wp_customize->remove_control( 'display_header_text' );

}

add_action( 'customize_register', 'marketr_remove_customize_register', 11 );