<?php
/**
 * Template Name: Default Home Page
 */

get_header();
?>

<main id="primary">
    <?php if (get_theme_mod('marketr_banner_section_on_off_setting', false)) { ?>
        <section id="main-banner-wrap">
            <div class="container">
                <div class="main-banner-content-box">
                    <?php
                        $marketr_banner_heading = get_theme_mod( 'marketr_banner_heading', '' );
                        if ( ! empty( $marketr_banner_heading ) ) { ?>
                        <h3><?php echo esc_html( $marketr_banner_heading ); ?></h3>
                    <?php } ?>
                    <?php
                        $marketr_banner_text = get_theme_mod( 'marketr_banner_text', '' );
                        if ( ! empty( $marketr_banner_text ) ) { ?>
                        <p><?php echo esc_html( $marketr_banner_text ); ?></p>
                    <?php } ?>
                    <div class="banner-button">
                        <?php
                        $marketr_banner_button_link = get_theme_mod( 'marketr_banner_button_link', '' );
                        $marketr_banner_button_text = get_theme_mod( 'marketr_banner_button_text', 'Get A Quote' );
                        if ( ! empty( $marketr_banner_button_link ) ) { ?>
                            <a href="<?php echo esc_url( $marketr_banner_button_link ); ?>"><i class="fa-solid fa-arrow-right mr-2"></i><?php echo esc_html( $marketr_banner_button_text ); ?></a>
                        <?php } ?>
                    </div>
                    <div class="main-banner-inner-box">
                        <?php
                        $marketr_banner_image = get_theme_mod( 'marketr_banner_image', '' );
                        if ( ! empty( $marketr_banner_image ) ) { ?>
                            <img src="<?php echo esc_url( $marketr_banner_image ); ?>">
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>


    <?php if (get_theme_mod('marketr_about_section_on_off_setting', false)) { ?>
        <section id="about-wrap" class="py-5">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-5 col-md-6">
                        <div class="about-image">
                            <?php
                            $marketr_about_image_big = get_theme_mod( 'marketr_about_image_big', '' );
                            if ( ! empty( $marketr_about_image_big ) ) { ?>
                                <img class="about-image1" src="<?php echo esc_url( $marketr_about_image_big ); ?>">
                            <?php } ?>
                            <div class="inner-about-image">
                                <?php
                                $marketr_about_image_small = get_theme_mod( 'marketr_about_image_small', '' );
                                if ( ! empty( $marketr_about_image_small ) ) { ?>
                                    <img class="about-image2" src="<?php echo esc_url( $marketr_about_image_small ); ?>">
                                <?php } ?>
                            </div>
                            <div class="round-shape"></div>
                        </div>
                    </div>
                    <div class="col-lg-7 col-md-6 aa">
                        <?php
                            $marketr_about_short_heading = get_theme_mod( 'marketr_about_short_heading', '' );
                            if ( ! empty( $marketr_about_short_heading ) ) { ?>
                            <h4><?php echo esc_html( $marketr_about_short_heading ); ?></h4>
                        <?php } ?>
                        <?php
                            $marketr_about_heading = get_theme_mod( 'marketr_about_heading', '' );
                            if ( ! empty( $marketr_about_heading ) ) { ?>
                            <h3><?php echo esc_html( $marketr_about_heading ); ?></h3>
                        <?php } ?>
                        <?php
                            $marketr_about_content = get_theme_mod( 'marketr_about_content', '' );
                            if ( ! empty( $marketr_about_content ) ) { ?>
                            <p><?php echo esc_html( $marketr_about_content ); ?></p>
                        <?php } ?>
                        <?php
                            $marketr_about_list1 = get_theme_mod( 'marketr_about_list1', '' );
                            $marketr_about_list2 = get_theme_mod( 'marketr_about_list2', '' );
                            $marketr_about_list3 = get_theme_mod( 'marketr_about_list3', '' );
                            if ( ! empty( $marketr_about_list1 ) || ! empty( $marketr_about_list2 ) || ! empty( $marketr_about_list3 ) ) { ?>
                                <ul>
                                    <li><?php echo esc_html( $marketr_about_list1 ); ?></li>
                                    <li><?php echo esc_html( $marketr_about_list2 ); ?></li>
                                    <li><?php echo esc_html( $marketr_about_list3 ); ?></li>
                                </ul>
                        <?php } ?>
                        <div class="row align-items-center about-icon">
                            <div class="col-lg-6">
                                <?php
                                    $marketr_about_achivement_number = get_theme_mod( 'marketr_about_achivement_number', '' );
                                    $marketr_about_achivement_text = get_theme_mod( 'marketr_about_achivement_text', '' );
                                    if ( ! empty( $marketr_about_achivement_number ) || ! empty( $marketr_about_achivement_text ) ) { ?>
                                    <div class="row align-items-center">
                                        <div class="col-lg-3 col-md-3 text-center">
                                            <i class="fas fa-trophy"></i>
                                        </div>
                                        <div class="col-lg-9 col-md-9">
                                            <h5><?php echo esc_html( $marketr_about_achivement_number ); ?></h5>
                                            <p><?php echo esc_html( $marketr_about_achivement_text ); ?></p>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="col-lg-6">
                                <?php
                                    $marketr_about_leading_heading = get_theme_mod( 'marketr_about_leading_heading', '' );
                                    $marketr_about_leading_text = get_theme_mod( 'marketr_about_leading_text', '' );

                                    if ( ! empty( $marketr_about_leading_heading ) || ! empty( $marketr_about_leading_text ) ) { ?>
                                        <div class="row align-items-center">
                                            <div class="col-lg-3 col-md-3 text-center">
                                                <i class="fas fa-edit"></i>
                                            </div>
                                            <div class="col-lg-9 col-md-9">
                                                <h5><?php echo esc_html( $marketr_about_leading_heading ); ?></h5>
                                                <p><?php echo esc_html( $marketr_about_leading_text ); ?></p>
                                            </div>
                                        </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="about-button">
                            <?php
                            $marketr_about_button_link = get_theme_mod( 'marketr_about_button_link', '' );
                            $marketr_about_button_text = get_theme_mod( 'marketr_about_button_text', 'More About' );
                            if ( ! empty( $marketr_about_button_link ) ) { ?>
                                <a href="<?php echo esc_url( $marketr_about_button_link ); ?>"><i class="fa-solid fa-arrow-right mr-2"></i><?php echo esc_html( $marketr_about_button_text ); ?></a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>

</main>

<?php
get_footer();