<?php
/**
 * Title: Footer
 * Slug: marketplace-shop/footer
 * Categories: all, footer
 */

$marketplace_shop_images = array(
    MARKETPLACE_SHOP_URL . 'assets/images/call.png',
    MARKETPLACE_SHOP_URL . 'assets/images/global.png',
    MARKETPLACE_SHOP_URL . 'assets/images/location.png',
    MARKETPLACE_SHOP_URL . 'assets/images/sms.png',
);

?>

<!-- wp:group {"style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}},"backgroundColor":"secaccent","layout":{"type":"constrained","contentSize":"100%"}} -->
<div class="wp-block-group has-secaccent-background-color has-background" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"style":{"border":{"radius":"0px"},"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}}},"layout":{"type":"constrained","contentSize":"80%"}} -->
<div class="wp-block-group" style="border-radius:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:group {"className":"footer-contact","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|large","bottom":"var:preset|spacing|large"}},"border":{"bottom":{"color":"#ffffff6b","width":"1px"},"top":[],"right":[],"left":[]},"elements":{"link":{"color":{"text":"var:preset|color|pure-black"}}}},"backgroundColor":"highlight","textColor":"pure-black","layout":{"type":"constrained","contentSize":"100%"}} -->
<div class="wp-block-group footer-contact has-pure-black-color has-highlight-background-color has-text-color has-background has-link-color" style="border-bottom-color:#ffffff6b;border-bottom-width:1px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--large);padding-bottom:var(--wp--preset--spacing--large)"><!-- wp:columns {"className":"footer-contact-main"} -->
<div class="wp-block-columns footer-contact-main"><!-- wp:column {"width":"20%","className":"footer-contact-box"} -->
<div class="wp-block-column footer-contact-box" style="flex-basis:20%"><!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"25%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:25%"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":7,"scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url($marketplace_shop_images[0]); ?>" alt="" class="wp-image-7" style="object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"75%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:75%"><!-- wp:heading {"level":6,"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}},"typography":{"fontStyle":"normal","fontWeight":"600","fontSize":"23px"},"spacing":{"padding":{"top":"0","bottom":"0"}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<h6 class="wp-block-heading has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="padding-top:0;padding-bottom:0;font-size:23px;font-style:normal;font-weight:600"><?php esc_html_e( 'Call Us', 'marketplace-shop' ); ?></h6>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}},"spacing":{"padding":{"top":"5px","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"500"}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="margin-top:0;margin-bottom:0;padding-top:5px;padding-right:0;padding-bottom:0;padding-left:0;font-size:14px;font-style:normal;font-weight:500"><?php esc_html_e( '(+11)12345678900', 'marketplace-shop' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"25%","className":"footer-contact-box"} -->
<div class="wp-block-column footer-contact-box" style="flex-basis:25%"><!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"25%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:25%"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":8,"scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url($marketplace_shop_images[1]); ?>" alt="" class="wp-image-8" style="object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"75%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:75%"><!-- wp:heading {"level":6,"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}},"typography":{"fontStyle":"normal","fontWeight":"600","fontSize":"23px"},"spacing":{"padding":{"top":"0","bottom":"0"}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<h6 class="wp-block-heading has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="padding-top:0;padding-bottom:0;font-size:23px;font-style:normal;font-weight:600"><?php esc_html_e( 'Website', 'marketplace-shop' ); ?></h6>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}},"spacing":{"padding":{"top":"5px","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"500"}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="margin-top:0;margin-bottom:0;padding-top:5px;padding-right:0;padding-bottom:0;padding-left:0;font-size:14px;font-style:normal;font-weight:500"><?php esc_html_e( 'www.marketplaceshop.com', 'marketplace-shop' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"30%","className":"footer-contact-box"} -->
<div class="wp-block-column footer-contact-box" style="flex-basis:30%"><!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"25%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:25%"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":9,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url($marketplace_shop_images[2]); ?>" alt="" class="wp-image-9"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"75%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:75%"><!-- wp:heading {"level":6,"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}},"typography":{"fontStyle":"normal","fontWeight":"600","fontSize":"23px"},"spacing":{"padding":{"top":"0","bottom":"0"}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<h6 class="wp-block-heading has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="padding-top:0;padding-bottom:0;font-size:23px;font-style:normal;font-weight:600"><?php esc_html_e( 'Address', 'marketplace-shop' ); ?></h6>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}},"spacing":{"padding":{"top":"5px","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"500"}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="margin-top:0;margin-bottom:0;padding-top:5px;padding-right:0;padding-bottom:0;padding-left:0;font-size:14px;font-style:normal;font-weight:500"><?php esc_html_e( '101 E 129th St, East Chicago, IN 46312, US', 'marketplace-shop' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"25%","className":"footer-contact-box"} -->
<div class="wp-block-column footer-contact-box" style="flex-basis:25%"><!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"25%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:25%"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":10,"scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url($marketplace_shop_images[3]); ?>" alt="" class="wp-image-10" style="object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"75%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:75%"><!-- wp:heading {"level":6,"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}},"typography":{"fontStyle":"normal","fontWeight":"600","fontSize":"23px"},"spacing":{"padding":{"top":"0","bottom":"0"}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<h6 class="wp-block-heading has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="padding-top:0;padding-bottom:0;font-size:23px;font-style:normal;font-weight:600"><?php esc_html_e( 'Email', 'marketplace-shop' ); ?></h6>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}},"spacing":{"padding":{"top":"5px","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"500"}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="margin-top:0;margin-bottom:0;padding-top:5px;padding-right:0;padding-bottom:0;padding-left:0;font-size:14px;font-style:normal;font-weight:500"><?php esc_html_e( 'marketplaceshop@example.com', 'marketplace-shop' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|medium","padding":{"top":"70px","bottom":"70px"},"margin":{"top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|pure-black"}}}},"backgroundColor":"highlight","textColor":"pure-black","layout":{"type":"constrained","contentSize":"100%"}} -->
<div class="wp-block-group has-pure-black-color has-highlight-background-color has-text-color has-background has-link-color" style="margin-top:0;margin-bottom:0;padding-top:70px;padding-bottom:70px"><!-- wp:columns {"verticalAlignment":"top","style":{"spacing":{"blockGap":{"top":"0","left":"var:preset|spacing|medium"}}}} -->
<div class="wp-block-columns are-vertically-aligned-top"><!-- wp:column {"verticalAlignment":"top","width":"40%","style":{"spacing":{"padding":{"bottom":"var:preset|spacing|xx-small"}}}} -->
<div class="wp-block-column is-vertically-aligned-top" style="padding-bottom:var(--wp--preset--spacing--xx-small);flex-basis:40%"><!-- wp:site-title {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"},"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontSize":"medium","fontFamily":"poppins"} /-->

<!-- wp:paragraph {"style":{"spacing":{"padding":{"right":"0","bottom":"var:preset|spacing|x-small"}},"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontSize":"small","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family has-small-font-size" style="padding-right:0;padding-bottom:var(--wp--preset--spacing--x-small)"><?php esc_html_e( 'It is a long established fact that a', 'marketplace-shop' ); ?><br><?php esc_html_e( 'reader will be distracted by the', 'marketplace-shop' ); ?> <br><?php esc_html_e( 'readable content of a page wp-block-heading', 'marketplace-shop' ); ?> <br><?php esc_html_e( 'looking at its layout', 'marketplace-shop' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:social-links {"iconColor":"accent-text","iconColorValue":"#FFFFFE","openInNewTab":true,"size":"has-small-icon-size","className":"is-style-logos-only","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|x-small","left":"var:preset|spacing|x-small"}}}} -->
<ul class="wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only"><!-- wp:social-link {"url":"#","service":"facebook"} /-->

<!-- wp:social-link {"url":"#","service":"twitter"} /-->

<!-- wp:social-link {"url":"#","service":"youtube"} /-->

<!-- wp:social-link {"url":"#","service":"linkedin"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"60%","className":"footer-right","style":{"spacing":{"padding":{"bottom":"var:preset|spacing|xx-small"}}}} -->
<div class="wp-block-column is-vertically-aligned-center footer-right" style="padding-bottom:var(--wp--preset--spacing--xx-small);flex-basis:60%"><!-- wp:columns {"isStackedOnMobile":false,"style":{"spacing":{"blockGap":{"top":"32px","left":"32px"}}}} -->
<div class="wp-block-columns is-not-stacked-on-mobile"><!-- wp:column {"width":"33.3%","style":{"spacing":[]},"fontFamily":"jost"} -->
<div class="wp-block-column has-jost-font-family" style="flex-basis:33.3%"><!-- wp:heading {"level":5,"style":{"typography":{"letterSpacing":"1px","fontSize":"15px","textTransform":"uppercase","fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<h5 class="wp-block-heading has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="font-size:15px;font-style:normal;font-weight:700;letter-spacing:1px;text-transform:uppercase"><?php esc_html_e( 'Our Services', 'marketplace-shop' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'Home', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'About Us', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'Services', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'Features', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.3%","style":{"spacing":[]}} -->
<div class="wp-block-column" style="flex-basis:33.3%"><!-- wp:heading {"level":5,"style":{"typography":{"textTransform":"uppercase","letterSpacing":"1px","fontSize":"15px","fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<h5 class="wp-block-heading has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="font-size:15px;font-style:normal;font-weight:700;letter-spacing:1px;text-transform:uppercase"><?php esc_html_e( 'Help', 'marketplace-shop' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'About Us', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'Contact Us', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'Cart', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'Shipping Policy', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.3%","style":{"spacing":[]}} -->
<div class="wp-block-column" style="flex-basis:33.3%"><!-- wp:heading {"level":5,"style":{"typography":{"textTransform":"uppercase","letterSpacing":"1px","fontSize":"15px","fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<h5 class="wp-block-heading has-accent-text-color has-text-color has-link-color has-public-sans-font-family" style="font-size:15px;font-style:normal;font-weight:700;letter-spacing:1px;text-transform:uppercase"><?php esc_html_e( 'Important Liniks', 'marketplace-shop' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'privacy policy', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'terms and conditions', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'Faqs', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontFamily":"poppins"} -->
<p class="has-accent-text-color has-text-color has-link-color has-public-sans-font-family"><a href="#"><?php esc_html_e( 'Contact', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"elements":{"link":{"color":{"text":"var:preset|color|secondary-accent"}}},"spacing":{"margin":{"top":"0","bottom":"0"}},"border":{"top":{"color":"#ffffff6b","width":"1px"},"right":[],"bottom":[],"left":[]}},"backgroundColor":"secaccent","textColor":"secondary-accent","layout":{"type":"constrained","contentSize":"100%"}} -->
<div class="wp-block-group has-secondary-accent-color has-secaccent-background-color has-text-color has-background has-link-color" style="border-top-color:#ffffff6b;border-top-width:1px;margin-top:0;margin-bottom:0"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}},"fontFamily":"jost","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group has-jost-font-family"><!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontSize":"small","fontFamily":"public-sans"} -->
<p class="has-text-align-center has-accent-text-color has-text-color has-link-color has-public-sans-font-family has-small-font-size"><a target="_blank" href="https://www.misbahwp.com/products/marketplace-shop" data-type="link" data-id="https://www.misbahwp.com/products/marketplace-shop"><?php esc_html_e( 'Marketplace Shop Theme', 'marketplace-shop' ); ?></a> <?php esc_html_e( 'By', 'marketplace-shop' ); ?> <a target="_blank" href="https://www.misbahwp.com/" data-type="link" data-id="https://www.misbahwp.com/"><?php esc_html_e( 'Misbah WP', 'marketplace-shop' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:site-title {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontSize":"small","fontFamily":"public-sans"} /-->

<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-text"}}}},"textColor":"accent-text","fontSize":"small","fontFamily":"public-sans"} -->
<p class="has-text-align-center has-accent-text-color has-text-color has-link-color has-public-sans-font-family has-small-font-size"><?php esc_html_e( '· All rights reserved', 'marketplace-shop' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->