<?php
/**
 * Useful Plugin Panel
 *
 * @package marin
 */
?>
<div id="useful-plugin-panel" class="panel-left">
	<?php
	$marin_free_plugins = array(
        'lead-generation-form' => array(
			'name'      => 'Lead Generation Form',
			'slug'      => 'lead-generation-form',
			'filename'  => 'lead-generation-form.php',
        ), 
		'slider-factory' => array(
			'name'     => 'Slider Factory',
			'slug'     => 'slider-factory',
			'filename' => 'slider-factory.php',
		),
		'filter-gallery' => array(
			'name'     => 'Filter Gallery',
			'slug'     => 'filter-gallery',
			'filename' => 'filter-gallery.php',
		),
        'flickr-album-gallery' => array(
			'name'      => 'Flickr Album Gallery',
			'slug'      => 'flickr-album-gallery',
			'filename'  => 'flickr-album-gallery.php',
        ),
        'ultimate-responsive-image-slider' => array(
			'name'      => 'Ultimate Responsive Image Slider',
			'slug'      => 'ultimate-responsive-image-slider',
			'filename'  => 'ultimate-responsive-image-slider.php',
        ),
        'customizer-login-page' => array(
			'name'     => 'Customizer Login Page',
			'slug'     => 'customizer-login-page',
			'filename' => 'customizer-login-page.php',
        ),
	);
	if ( ! empty( $marin_free_plugins ) ) {
		?>
		<div class="recomended-plugin-wrap">
		<?php
		foreach ( $marin_free_plugins as $marin_plugin ) {
			$marin_info = marin_call_plugin_api( $marin_plugin['slug'] );
			?>
			<div class="recom-plugin-wrap w-3-col">
				<div class="plugin-title-install clearfix">
					<span class="title" title="<?php echo esc_attr( $marin_plugin['name'] ); ?>">
						<?php echo esc_html( $marin_plugin['name'] ); ?>	
					</span>
					<?php if($marin_plugin['slug'] == 'lead-generation-form') : ?>
							<p><?php esc_html_e('Lead Generation Form is the ultimate WordPress plugin for capturing and managing leads. With a drag-and-drop form builder, you can create stunning, customizable forms to convert visitors into leads.', 'crypto-airdrop'); ?></p>
					<?php endif; ?>  

					<?php if ( $marin_plugin['slug'] == 'slider-factory' ) : ?>
						<p><?php esc_html_e( 'Slider factory is a responsive block builder plugin that can help you create “Perfect Slider Gallery” page or section for your WordPress website.', 'marin' ); ?></p>
					<?php endif; ?>

					<?php if ( $marin_plugin['slug'] == 'filter-gallery' ) : ?>
						<p><?php esc_html_e( 'The Filter Gallery is best gallery filtering plugin for WordPress.  It can filter your Images according to your filters. All your images will be shown in beautiful grid layout.', 'marin' ); ?></p>
					<?php endif; ?>

					<?php if($marin_plugin['slug'] == 'flickr-album-gallery') : ?>
							<p><?php esc_html_e('Flickr album gallery pro is a Flickr JS API plugin to display albums galleries on WordPress websites and blogs. Generate multiple albums gallery shortcode using the plugin to display on individual pages.', 'crypto-airdrop'); ?></p>
					<?php endif; ?>
							
					<?php if($marin_plugin['slug'] == 'ultimate-responsive-image-slider') : ?>
							<p><?php esc_html_e('Ultimate responsive image slider a fully responsive image slide show plugin for WordPress blogs and websites. Add infinite image slides in a single slider using multiple image uploader.', 'crypto-airdrop'); ?></p>
					<?php endif; ?>
							
					<?php if($marin_plugin['slug'] == 'customizer-login-page') : ?>
							<p><?php esc_html_e('Customizer Login Page Plugin allows you to create a beautiful admin login page. It gives you a list of options for customization. You can personalize your admin login page directly from Customizer.', 'crypto-airdrop'); ?></p>
					<?php endif; ?>

					<?php
					echo '<div class="button-wrap">';
					echo Marin_Getting_Started_Page_Plugin_Helper::instance()->get_button_html( $marin_plugin['slug'] );
					echo '</div>';
					?>
				</div>
			</div>
			</br>
			<?php
		}
		?>
		</div>
		<?php
	}
	?>
</div>
