<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// Overwrite parent theme background defaults and registers support for WordPress features.
add_action( 'after_setup_theme', 'lalita_background_setup' );
function lalita_background_setup() {
	add_theme_support( "custom-background",
		array(
			'default-color' 		 => 'ffffff',
			'default-image'          => '',
			'default-repeat'         => 'repeat',
			'default-position-x'     => 'left',
			'default-position-y'     => 'top',
			'default-size'           => 'auto',
			'default-attachment'     => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => ''
		)
	);
}

// Overwrite theme URL
function lalita_theme_uri_link() {
	return 'https://wpkoi.com/marga-wpkoi-wordpress-theme/';
}

// Overwrite parent theme's blog header function
add_action( 'lalita_after_header', 'lalita_blog_header_image', 11 );
function lalita_blog_header_image() {

	if ( ( is_front_page() && is_home() ) || ( is_home() ) ) { 
		$blog_header_image 			=  lalita_get_setting( 'blog_header_image' ); 
		$blog_header_title 			=  lalita_get_setting( 'blog_header_title' ); 
		$blog_header_text 			=  lalita_get_setting( 'blog_header_text' ); 
		$blog_header_button_text 	=  lalita_get_setting( 'blog_header_button_text' ); 
		$blog_header_button_url 	=  lalita_get_setting( 'blog_header_button_url' ); 
		if ( $blog_header_image != '' ) { ?>
		<div class="page-header-image grid-parent page-header-blog" style="background-image: url('<?php echo esc_url($blog_header_image); ?>') !important;">
        	<div class="page-header-noiseoverlay"></div>
        	<div class="page-header-blog-inner">
                <div class="page-header-blog-content-h grid-container">
                    <div class="page-header-blog-content">
                    <?php if ( $blog_header_title != '' ) { ?>
                        <div class="page-header-blog-text">
                            <?php if ( $blog_header_title != '' ) { ?>
                            <h2><?php echo wp_kses_post( $blog_header_title ); ?></h2>
                            <div class="clearfix"></div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                    </div>
                </div>
                <div class="page-header-blog-content page-header-blog-content-b">
                	<?php if ( $blog_header_text != '' ) { ?>
                	<div class="page-header-blog-text">
						<?php if ( $blog_header_title != '' ) { ?>
                        <p><?php echo wp_kses_post( $blog_header_text ); ?></p>
                        <div class="clearfix"></div>
                        <?php } ?>
                    </div>
                    <?php } ?>
                    <div class="page-header-blog-button">
                        <?php if ( $blog_header_button_text != '' ) { ?>
                        <a class="read-more button" href="<?php echo esc_url( $blog_header_button_url ); ?>"><?php echo esc_html( $blog_header_button_text ); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
		</div>
		<?php
		}
	}
}

// Extra cutomizer functions
if ( ! function_exists( 'marga_customize_register' ) ) {
	add_action( 'customize_register', 'marga_customize_register' );
	function marga_customize_register( $wp_customize ) {
				
		// Add Marga customizer section
		$wp_customize->add_section(
			'marga_layout_effects',
			array(
				'title' => __( 'Marga Effects', 'marga' ),
				'priority' => 24,
			)
		);
		
		// Text frame
		$wp_customize->add_setting(
			'marga_settings[text_frame]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'marga_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'marga_settings[text_frame]',
			array(
				'type' => 'select',
				'label' => __( 'Text frame', 'marga' ),
				'choices' => array(
					'enable' => __( 'Enable', 'marga' ),
					'disable' => __( 'Disable', 'marga' )
				),
				'settings' => 'marga_settings[text_frame]',
				'section' => 'marga_layout_effects',
				'priority' => 10
			)
		);
		
		// Frame texts
		$wp_customize->add_setting(
			'marga_settings[frame_text_content]',
			array(
				'default' => '',
				'type' => 'option',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			'marga_settings[frame_text_content]',
			array(
				'type' 		 => 'textarea',
				'label'      => __( 'Frame texts', 'lalita' ),
				'section'    => 'marga_layout_effects',
				'settings'   => 'marga_settings[frame_text_content]',
				'priority' => 11,
				'description' => __( 'Longer texts are looks better...', 'lalita' )
			)
		);
		
		// Hide frame on mobile
		$wp_customize->add_setting(
			'marga_settings[hide_frame]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'marga_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'marga_settings[hide_frame]',
			array(
				'type' => 'select',
				'label' => __( 'Hide frame on mobile', 'marga' ),
				'choices' => array(
					'enable' => __( 'Enable', 'marga' ),
					'disable' => __( 'Disable', 'marga' )
				),
				'section' => 'marga_layout_effects',
				'settings' => 'marga_settings[hide_frame]',
				'priority' => 12
			)
		);
		
		// Logo style
		$wp_customize->add_setting(
			'marga_settings[logo_style]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'marga_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'marga_settings[logo_style]',
			array(
				'type' => 'select',
				'label' => __( 'Logo style', 'marga' ),
				'choices' => array(
					'enable' => __( 'Enable', 'marga' ),
					'disable' => __( 'Disable', 'marga' )
				),
				'settings' => 'marga_settings[logo_style]',
				'section' => 'marga_layout_effects',
				'priority' => 14
			)
		);
		
		// Blog image effect
		$wp_customize->add_setting(
			'marga_settings[blog_image]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'marga_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'marga_settings[blog_image]',
			array(
				'type' => 'select',
				'label' => __( 'Blog image effect', 'marga' ),
				'choices' => array(
					'enable' => __( 'Enable', 'marga' ),
					'disable' => __( 'Disable', 'marga' )
				),
				'settings' => 'marga_settings[blog_image]',
				'section' => 'marga_layout_effects',
				'priority' => 16
			)
		);
		
		// Marga effect colors
		$wp_customize->add_setting(
			'marga_settings[marga_color_1]', array(
				'default' => '#ff0005',
				'type' => 'option',
				'sanitize_callback' => 'marga_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'marga_settings[marga_color_1]',
				array(
					'label' => __( 'Effect color 1', 'marga' ),
					'section' => 'marga_layout_effects',
					'settings' => 'marga_settings[marga_color_1]',
					'priority' => 45
				)
			)
		);
		
		
		$wp_customize->add_setting(
			'marga_settings[marga_color_2]', array(
				'default' => '#ffffff',
				'type' => 'option',
				'sanitize_callback' => 'marga_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'marga_settings[marga_color_2]',
				array(
					'label' => __( 'Effect color 2', 'marga' ),
					'section' => 'marga_layout_effects',
					'settings' => 'marga_settings[marga_color_2]',
					'priority' => 46
				)
			)
		);
		
	}
}

//Sanitize choices.
if ( ! function_exists( 'marga_sanitize_choices' ) ) {
	function marga_sanitize_choices( $input, $setting ) {
		// Ensure input is a slug
		$input = sanitize_key( $input );

		// Get list of choices from the control
		// associated with the setting
		$choices = $setting->manager->get_control( $setting->id )->choices;

		// If the input is a valid key, return it;
		// otherwise, return the default
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}
}

// Sanitize colors. Allow blank value.
if ( ! function_exists( 'marga_sanitize_hex_color' ) ) {
	function marga_sanitize_hex_color( $color ) {
	    if ( '' === $color ) {
	        return '';
		}

	    // 3 or 6 hex digits, or the empty string.
	    if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) ) {
	        return $color;
		}

	    return '';
	}
}

// Marga effects colors css
if ( ! function_exists( 'marga_effect_colors_css' ) ) {
	function marga_effect_colors_css() {
		// Get Customizer settings
		$marga_settings = get_option( 'marga_settings' );
		
		$marga_color_1  	 = '#ff0005';
		$marga_color_2  	 = '#ffffff';
		
		if ( isset( $marga_settings['marga_color_1'] ) ) {
			$marga_color_1 = $marga_settings['marga_color_1'];
		}
		if ( isset( $marga_settings['marga_color_2'] ) ) {
			$marga_color_2 = $marga_settings['marga_color_2'];
		}
		
		$lalita_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_default_fonts()
		);
		
		$fixed_side_family = lalita_get_font_family_css( 'font_fixed_side', 'lalita_settings', lalita_get_default_fonts() );
		$fixed_side_font_weight = $lalita_settings[ 'fixed_side_font_weight' ];
		$fixed_side_font_transform = $lalita_settings[ 'fixed_side_font_transform' ];
		$fixed_side_font_size = $lalita_settings[ 'fixed_side_font_size' ];
		
		
		$marga_extracolors = '
		.marga-frame {background-color: ' . esc_attr( $marga_color_1 ) . ';border-color: ' . esc_attr( $marga_color_1 ) . ';color: ' . esc_attr( $marga_color_2 ) . ';font-family: ' . wp_kses_post( $fixed_side_family ) . ';font-weight: ' . esc_attr( $fixed_side_font_weight ) . ';text-transform: ' . esc_attr( $fixed_side_font_transform ) . ';font-size: ' . esc_attr( $fixed_side_font_size ) . 'px;}.marga-logo-style .site-branding .main-title a, .marga-logo-style .site-branding .main-title a:hover, .marga-logo-style .site-branding .main-title a:visited {background: ' . esc_attr( $marga_color_1 ) . ';color: ' . esc_attr( $marga_color_2 ) . ';}.inside-navigation .search-form input[type="search"]:focus {color: ' . esc_attr( $marga_color_2 ) . ' !important}';
		
		return $marga_extracolors;
	}
}

// The dynamic styles of the parent theme added inline to the parent stylesheet.
// For the customizer functions it is better to enqueue after the child theme stylesheet.
if ( ! function_exists( 'marga_remove_parent_dynamic_css' ) ) {
	add_action( 'init', 'marga_remove_parent_dynamic_css' );
	function marga_remove_parent_dynamic_css() {
		remove_action( 'wp_enqueue_scripts', 'lalita_enqueue_dynamic_css', 50 );
	}
}

// Enqueue this CSS after the child stylesheet, not after the parent stylesheet.
if ( ! function_exists( 'marga_enqueue_parent_dynamic_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'marga_enqueue_parent_dynamic_css', 50 );
	function marga_enqueue_parent_dynamic_css() {
		$css = lalita_base_css() . lalita_font_css() . lalita_advanced_css() . lalita_spacing_css() . lalita_no_cache_dynamic_css() .marga_effect_colors_css();

		// escaped secure before in parent theme
		wp_add_inline_style( 'lalita-child', $css );
	}
}

//Adds custom classes to the array of body classes.
if ( ! function_exists( 'marga_body_classes' ) ) {
	add_filter( 'body_class', 'marga_body_classes' );
	function marga_body_classes( $classes ) {
		// Get Customizer settings
		$marga_settings = get_option( 'marga_settings' );
		
		$text_frame 	= 'enable';
		$hide_frame 	= 'enable';
		$blog_image 	= 'enable';
		$logo_style		= 'enable';
		
		if ( isset( $marga_settings['text_frame'] ) ) {
			$text_frame = $marga_settings['text_frame'];
		}
		
		if ( isset( $marga_settings['hide_frame'] ) ) {
			$hide_frame = $marga_settings['hide_frame'];
		}
		
		if ( isset( $marga_settings['blog_image'] ) ) {
			$blog_image = $marga_settings['blog_image'];
		}
		
		if ( isset( $marga_settings['logo_style'] ) ) {
			$logo_style = $marga_settings['logo_style'];
		}
		
		// Text frame
		if ( $text_frame != 'disable' ) {
			$classes[] = 'marga-text-frame';
		}
		
		// Hide frame on mobile
		if ( $hide_frame != 'disable' ) {
			$classes[] = 'marga-hide-frame';
		}
		
		// Blog image effect
		if ( $blog_image != 'disable' ) {
			$classes[] = 'marga-blog-image';
		}
		
		// Logo style
		if ( $logo_style != 'disable' ) {
			$classes[] = 'marga-logo-style';
		}
		
		return $classes;
	}
}

// Enqueue scripts
if ( ! function_exists( 'marga_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'marga_scripts' );
	function marga_scripts() {
		
		$marga_settings = get_option( 'marga_settings' );
		$text_frame		 = 'enable';
		if ( isset( $marga_settings['text_frame'] ) ) {
			$text_frame = $marga_settings['text_frame'];
		}
		
		if ( $text_frame != 'disable' ) {
			wp_enqueue_script( 'marga-marquee', esc_url( get_stylesheet_directory_uri() ) . "/js/jquery.marquee.min.js", array( 'jquery'), LALITA_VERSION, true );
		}
	}
}

if ( ! function_exists( 'marga_frame_html' ) ) {
	add_action( 'lalita_before_header', 'marga_frame_html' );
	/**
	 * HTML for the color frame
	 */
	function marga_frame_html() {
		$marga_settings = get_option( 'marga_settings' );
		
		$text_frame 	     = 'enable';
		$frame_text_content  = '';
		if ( isset( $marga_settings['text_frame'] ) ) {
			$text_frame = $marga_settings['text_frame'];
		}
		if ( isset( $marga_settings['frame_text_content'] ) ) {
			$frame_text_content = $marga_settings['frame_text_content'];
		}
		
		if ( ( $text_frame != 'disable' ) && ( $frame_text_content != '' ) ) {
	?>
    <div class="marga-frame marga-frame-top"><?php echo wp_kses_post( $frame_text_content ); ?></div>
    <div class="marga-frame marga-frame-right"></div>
    <div class="marga-frame marga-frame-left"></div>
    <div class="marga-frame marga-frame-bottom"><?php echo wp_kses_post( $frame_text_content ); ?></div>
    <?php
		}
	}
}