<?php

//options

function mapro_theme_info_menu() {

	add_theme_page( 
		esc_html__('Welcome To Mapro WordPress Theme', 'mapro'), 
		esc_html__('Mapro Theme Info', 'mapro'), 
		'manage_options', 
		'axis_magazine_theme_info_options', 
		'mapro_theme_info_display' 
	);

}


add_action( 'admin_menu', 'mapro_theme_info_menu' );



function mapro_theme_info_display() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( esc_html_e( 'You do not have sufficient permissions to access this page.', 'mapro' ) );
	}
	
	?>
	<div class="wrap axis-magazine-adm">
		<h1 class="header-welcome"><?php esc_html_e('Welcome to Mapro', 'mapro'); ?></h1>
		<div class="axis-magazine-adm-dsply-fl axis-magazine-adm-fl-wrap axis-magazine-adm-jc-sp-btw">

			<div class="axis-magazine-adm-wid-49 theme-para theme-doc axis-magazine-adm-mobwid-100">
				<h4><?php esc_html_e('Theme Documentation','mapro'); ?></h4>
				<p><?php esc_html_e('Documentation for this theme includes all theme information that is needed to get your site up and running', 'mapro'); ?></p>
				<p>
					<a href="<?php echo esc_url('http://thedavidgibson.com/mapro-documentation/'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Theme Documentation', 'mapro'); ?>
					</a>
				</p>
			</div>


			<div class="axis-magazine-adm-wid-49 theme-para theme-opt axis-magazine-adm-mobwid-100">
				<h4><?php esc_html_e('Theme Options','mapro'); ?></h4>
				<p class="">
					<?php esc_html_e('Mapro Theme supports Theme Customizer. Click "Go To Customizer" to open the Customizer now.',  'mapro'); ?>
				</p>
				<p>
					<a href="<?php echo esc_url(admin_url('customize.php')); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Go To Customizer', 'mapro'); ?>
					</a>
				</p>
			</div>

			<div class="axis-magazine-adm-wid-49 theme-para theme-opt axis-magazine-adm-mobwid-100">
				<h4><?php esc_html_e('Mapro Pro','mapro'); ?></h4>
				<p class="">
					<?php esc_html_e('Mapro Pro includes portfolio page templates, additional features and more options to customize your website.',  'mapro'); ?>
				</p>
				<p>
					<a href="<?php echo esc_url('http://thedavidgibson.com/wptheme/mapro/detail.html'); ?>" class="button button-primary" target="_blank">
						<?php esc_html_e('Upgrade to Mapro Pro', 'mapro'); ?>
					</a>
				</p>
			</div>
  

			<div class="axis-magazine-adm-wid-49 theme-para theme-review axis-magazine-adm-mobwid-100">
				<h4><?php esc_html_e('Leave us a review','mapro'); ?></h4>
				<p><?php esc_html_e('We would love to hear your feedback.', 'mapro'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://wordpress.org/support/theme/mapro/reviews/#new-post'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Submit a review', 'mapro'); ?>
					</a>
				</p>
			</div>


			<div class="axis-magazine-adm-wid-49 theme-para theme-support axis-magazine-adm-mobwid-100">
				<h4><?php esc_html_e('Support','mapro'); ?></h4>
				<p><?php esc_html_e('Reach out in the theme support forums', 'mapro'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://wordpress.org/support/theme/mapro/'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Support Forum', 'mapro'); ?>
					</a>
				</p>
			</div>

			
			
			<div class="theme-upgrade axis-magazine-adm-wid-100">
				<table class="axis-magazine-adm-wid-100">
					<thead class="theme-table-head">
						<tr>
							<th class="feature"><h3><?php esc_html_e('Features', 'mapro'); ?></h3></th>
							<th class="axis-magazine-adm-wid-33"><h3><?php esc_html_e('Mapro Lite', 'mapro'); ?></h3></th>
							<th class="axis-magazine-adm-wid-33"><h3><?php esc_html_e('Mapro Pro', 'mapro'); ?></h3></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td class="feature-items-title">
								<h3><?php esc_html_e('Theme Price', 'mapro'); ?></h3>
							</td>
							<td class="free-btn"><?php esc_html_e('Free', 'mapro'); ?></td>
							<td>
									<?php esc_html_e('$49', 'mapro'); ?>
								 
							</td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Responsive Design', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Number Of Home Pages', 'mapro'); ?></h3></td>
							<td><span class="number-index-styles"><?php esc_html_e('1', 'mapro'); ?></span></td>
							<td><span class="number-index-styles"><?php esc_html_e('3', 'mapro'); ?></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Portfolio Page Template', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Testimonials Page Template', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Team Page Template', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Gallery Page Template', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Pricing Page Template', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Shortcodes', 'mapro'); ?></h3></td>
							<td><span class="number-index-styles"><?php esc_html_e('0', 'mapro'); ?></span></td>
							<td><span class="number-index-styles"><?php esc_html_e('20+', 'mapro'); ?></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Full Width Template', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Footer Credits Options', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Color Options', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Gutenberg Compatible', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Elementor Compatible', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Major Browser Compatible', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Woocommerce Compatible', 'mapro'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class=""></td>
							<td class=""></td>
							<td class="go-pro">
								<span class="">
									<a class="link" href="<?php echo esc_url('http://thedavidgibson.com/wptheme/mapro/detail.html'); ?>" target="_blank">
										<?php esc_html_e('View Pro', 'mapro'); ?>
									</a>
								</span>
							</td>
						</tr>
					</tbody>
				</table>
			</div>




		</div>
	</div>
	<?php
}
?>
