<?php
/**
 * The template part for displaying a message that posts cannot be found.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 */
?>

<article id="post-0" class="post hentry no-results not-found boxed group">
	<header class="entry-header">
		<h1 class="entry-title"><?php esc_html_e( 'Nothing Found', 'mallow' ); ?></h1>
	</header>

	<div class="entry-content">
		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p><?php printf(
					/* translators: %s: New post link in dashboard */
					esc_html__( 'Ready to publish your first post? %s.', 'mallow' ),
					'<a href="' . esc_url( admin_url( 'post-new.php' ) ) . '">' . esc_html__( 'Get started here', 'mallow' ) . '</a>'
				); ?></p>

		<?php elseif ( is_search() ) : ?>

			<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords or browse our archives.', 'mallow' ); ?></p>

		<?php else : ?>

			<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help or browse our archives.', 'mallow' ); ?></p>

		<?php endif; ?>

		<h3 class="widget-title archive-title"><?php esc_html_e( 'Last 30 Posts', 'mallow' ); ?></h3>
		<ul>
			<?php
			$r = new WP_Query( array( 'showposts' => 30, 'post_status' => 'publish', 'ignore_sticky_posts' => 1 ) );
			while ( $r->have_posts() ) : $r->the_post();
				?>
				<li>
					<a href="<?php the_permalink() ?>"><?php the_title() ?></a>
				</li>
				<?php
			endwhile;
			?>
		</ul>

		<h3 class="widget-title archive-title"><?php esc_html_e( 'Archives by Month:', 'mallow' ); ?></h3>
		<ul>
			<?php wp_get_archives( 'type=monthly' ); ?>
		</ul>
	</div>
</article>
