<article id="post-<?php the_ID(); ?>" <?php post_class( 'boxed' ); ?>>
	<?php $nothumb = "no-thumb"; ?>

	<?php if ( has_post_thumbnail() ): ?>
		<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="home-thumb boxed">
			<?php the_post_thumbnail(); ?>
		</a>
		<?php $nothumb = ""; ?>
	<?php endif; ?>

	<header class="entry-header <?php echo esc_attr( $nothumb ); ?>">
		<?php if ( 'post' == get_post_type() ) : ?>
			<div class="entry-meta cat-meta">
				<?php
				/* translators: used between list items, there is a space after the comma */
				$categories_list = get_the_category_list( esc_html__( ', ', 'mallow' ) );
				if ( $categories_list && mallow_categorized_blog() ) {
					/* translators: %s: categories */
					printf( esc_html__( '%1$s ', 'mallow' ), $categories_list );
				} ?>
			</div>
		<?php endif; ?>

		<h2 class="entry-title h3"><a href="<?php the_permalink(); ?>"
									  <?php /* translators: %s: post title */ ?>
		                              title="<?php echo esc_attr( sprintf( esc_html__( 'Permalink to %s', 'mallow' ), the_title_attribute( 'echo=0' ) ) ); ?>"
		                              rel="bookmark"><?php the_title(); ?></a></h2>
	</header>

	<div class="entry-summary  <?php echo esc_attr( $nothumb ); ?>">
		<?php the_excerpt(); ?>
	</div>

	<div class="sticky-meta entry-meta boxed">
		<a href="<?php the_permalink(); ?>"
		   <?php /* translators: %s: post title */ ?>
		   title="<?php echo esc_attr( sprintf( esc_html__( 'Permalink to %s', 'mallow' ), the_title_attribute( 'echo=0' ) ) ); ?>"
		   rel="bookmark"><?php mallow_posted_on(); ?></a>
		<span class="sep"> &nbsp; | &nbsp; </span>
		<span
			class="comments-link"><?php comments_popup_link( esc_html__( 'No Comment', 'mallow' ), esc_html__( '1 Comment', 'mallow' ), esc_html__( '% Comments', 'mallow' ) ); ?></span>
	</div>

</article>
