
<article id="post-<?php the_ID(); ?>" <?php post_class( 'boxed group' ); ?>>
	<header class="entry-header">
		<h1 class="entry-title"><?php the_title(); ?></h1>

		<div class="entry-meta">
			<span class="posted-by">
            	<?php esc_html_e( 'By ', 'mallow' ); ?>
	            <?php the_author_link(); ?>
            </span>

			<?php
			echo '<span>';
			mallow_posted_on();
			echo '</span> ';
			?>
			<span class="sep"> &nbsp; | &nbsp; </span>
			<span><?php comments_popup_link(
					esc_html__( 'Leave a comment', 'mallow' ),
					esc_html__( '1 Comment', 'mallow' ),
					esc_html__( '% Comments', 'mallow' )
				); ?></span>
			<?php edit_post_link( esc_html__( 'Edit', 'mallow' ), '<span class="sep"> &nbsp; | &nbsp; </span><span>', '</span>' ); ?>
		</div>
	</header>

	<div class="entry-content boxed">
		<?php the_content(); ?>
		
		<?php the_tags( '<p class="post-tags"><span>' . esc_html__( 'Tags:', 'mallow' ) . '</span> ', ', ', '</p>' ); ?>
		
		<?php wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'mallow' ),
			'after'  => '</div>'
		) ); ?>
	</div>

	<footer class="boxed">
		<?php if ( get_the_author_meta( 'description' ) ) : ?>
			<div class="author-box boxed">
				<h3 class="widget-title"><?php esc_html_e( 'About the author', 'mallow' ); ?></h3>

				<?php get_avatar( get_the_author_meta( 'user_email' ), 80 ); ?>
				<p class="author-description"><?php the_author_posts_link(); ?>, <?php the_author_meta( 'description' ); ?></p>
			</div>
		<?php endif; ?>

		<nav class="post-nav group">
			<?php if ( $prev_post = get_previous_post() ) : ?>
				<div class="prev-post boxed">
					<div class="entry-meta cat-meta"><?php esc_html_e( 'Previous Post', 'mallow' ); ?></div>

					<h4 class="entry-title h3"><a href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>">
							<?php echo get_the_title( $prev_post->ID ); ?></a></h4>
				</div>
			<?php endif; ?>
			
			<?php if ( $next_post = get_next_post() ) : ?>
				<div class="next-post boxed">
					<div class="entry-meta cat-meta"><?php esc_html_e( 'Next Post', 'mallow' ); ?></div>

					<h4 class="entry-title h3"><a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>">
							<?php echo get_the_title( $next_post->ID ); ?></a></h4>
				</div>
			<?php endif; ?>
		</nav>
	</footer>
</article>

